/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.logging;

import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/taskbased/logging/TaskLoggingUtils;", "", "<init>", "()V", "buildStartTaskLogMessage", "", "taskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "profilingProcessStartingPoint", "Lcom/android/tools/profilers/taskbased/home/TaskHomeTabModel$ProfilingProcessStartingPoint;", "isProcessProfileable", "", "intellij.android.profilers"})
public final class TaskLoggingUtils {
    @NotNull
    public static final TaskLoggingUtils INSTANCE = new TaskLoggingUtils();

    private TaskLoggingUtils() {
    }

    @NotNull
    public final String buildStartTaskLogMessage(@NotNull ProfilerTaskType taskType, @NotNull TaskHomeTabModel.ProfilingProcessStartingPoint profilingProcessStartingPoint, boolean isProcessProfileable) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)((Object)profilingProcessStartingPoint), (String)"profilingProcessStartingPoint");
        StringBuilder message = new StringBuilder();
        message.append("Attempting to start the '" + taskType.getDescription() + "' task from " + (profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.NOW ? "now (non-startup)" : "process start (startup)"));
        if (profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.PROCESS_START) {
            message.append(".");
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        message.append(" with a " + (isProcessProfileable ? "'profileable'" : "'debuggable'") + " process.");
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

