/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.common.constants.strings;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.profilers.taskbased.common.constants.strings.TaskBasedUxStrings;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/taskbased/common/constants/strings/StringUtils;", "", "<init>", "()V", "getTaskTabTitle", "", "taskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "isTaskTitleV2Enabled", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\ncom/android/tools/profilers/taskbased/common/constants/strings/StringUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    public static final int $stable;

    private StringUtils() {
    }

    @NotNull
    public final String getTaskTabTitle(@NotNull ProfilerTaskType taskType, boolean isTaskTitleV2Enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        String taskTitle = TaskBasedUxStrings.INSTANCE.getTaskTitle(taskType, isTaskTitleV2Enabled);
        String taskSubtitle = TaskBasedUxStrings.INSTANCE.getTaskSubtitle(taskType, isTaskTitleV2Enabled);
        if (StringsKt.isBlank((CharSequence)taskTitle)) {
            return "Task not supported yet";
        }
        if (isTaskTitleV2Enabled) {
            CharSequence charSequence;
            CharSequence charSequence2 = taskSubtitle;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = taskTitle;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }
        Object tabTitle = taskTitle;
        if (!StringsKt.isBlank((CharSequence)taskSubtitle)) {
            tabTitle = (String)tabTitle + " (" + taskSubtitle + ")";
        }
        return tabTitle;
    }
}

