/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerDropDownComponent;
import com.android.tools.profilers.ProfilerFlows;
import com.android.tools.profilers.Selection;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.memory.CapturePanelTabContainer;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.HeapSetNodeHRenderer;
import com.android.tools.profilers.memory.chart.MemoryVisualizationModel;
import com.android.tools.profilers.memory.chart.MemoryVisualizationTooltipView;
import com.android.tools.profilers.memory.chart.VisualizationTooltipModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J&\u00101\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u00102\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u000200H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\"\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00064"}, d2={"Lcom/android/tools/profilers/memory/chart/MemoryVisualizationView;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/profilers/memory/CapturePanelTabContainer;", "selection", "Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "model", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;", "<init>", "(Lcom/android/tools/profilers/memory/MemoryCaptureSelection;Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;)V", "(Lcom/android/tools/profilers/memory/MemoryCaptureSelection;Lcom/android/tools/profilers/StudioProfilersView;)V", "getModel", "()Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;", "panel", "Ljavax/swing/JPanel;", "axisFilterFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/tools/profilers/Selection;", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel$XAxisFilter;", "axisFilterDropDown", "Ljavax/swing/JComponent;", "initialClassGrouping", "Lcom/android/tools/profilers/memory/ClassGrouping;", "toolbarComponents", "", "Ljava/awt/Component;", "getToolbarComponents", "()Ljava/util/List;", "onSelectionChanged", "", "selected", "", "rebuildUI", "component", "getComponent", "()Ljavax/swing/JComponent;", "createChartPanel", "getCodeLocation", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "chart", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "createAxis", "Lcom/android/tools/adtui/AxisComponent;", "formatter", "Lcom/android/tools/adtui/model/formatter/BaseAxisFormatter;", "range", "Lcom/android/tools/adtui/model/Range;", "createChart", "node", "globalRange", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMemoryVisualizationView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryVisualizationView.kt\ncom/android/tools/profilers/memory/chart/MemoryVisualizationView\n+ 2 Selection.kt\ncom/android/tools/profilers/SelectionKt\n*L\n1#1,202:1\n44#2:203\n*S KotlinDebug\n*F\n+ 1 MemoryVisualizationView.kt\ncom/android/tools/profilers/memory/chart/MemoryVisualizationView\n*L\n66#1:203\n*E\n"})
public final class MemoryVisualizationView
extends AspectObserver
implements CapturePanelTabContainer {
    @NotNull
    private final MemoryCaptureSelection selection;
    @NotNull
    private final StudioProfilersView profilersView;
    @NotNull
    private final MemoryVisualizationModel model;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final MutableStateFlow<Selection<MemoryVisualizationModel.XAxisFilter>> axisFilterFlow;
    @NotNull
    private final JComponent axisFilterDropDown;
    @Nullable
    private ClassGrouping initialClassGrouping;
    public static final int $stable = 8;

    @VisibleForTesting
    public MemoryVisualizationView(@NotNull MemoryCaptureSelection selection, @NotNull StudioProfilersView profilersView, @NotNull MemoryVisualizationModel model) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.selection = selection;
        this.profilersView = profilersView;
        this.model = model;
        this.panel = new JPanel(new BorderLayout());
        Enum initialValue$iv = this.model.getAxisFilter();
        boolean $i$f$selectionOf = false;
        this.axisFilterFlow = ProfilerFlows.createMutableStateFlow(new Selection<Enum>(initialValue$iv, ArraysKt.toList((Object[])MemoryVisualizationModel.XAxisFilter.values())));
        this.axisFilterDropDown = new ProfilerDropDownComponent(this.model.getAxisFilter().toString(), "View by", null, (StateFlow)this.axisFilterFlow, null, arg_0 -> MemoryVisualizationView._init_$lambda$0(this, arg_0), MemoryVisualizationView::_init_$lambda$1);
    }

    @VisibleForTesting
    @NotNull
    public final MemoryVisualizationModel getModel() {
        return this.model;
    }

    public MemoryVisualizationView(@NotNull MemoryCaptureSelection selection, @NotNull StudioProfilersView profilersView) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        this(selection, profilersView, new MemoryVisualizationModel());
    }

    @NotNull
    public final List<Component> getToolbarComponents() {
        JLabel jLabel;
        List components = new ArrayList();
        JLabel $this$_get_toolbarComponents__u24lambda_u240 = jLabel = new JLabel("View by:");
        boolean bl = false;
        $this$_get_toolbarComponents__u24lambda_u240.setForeground(UIUtil.getLabelDisabledForeground());
        $this$_get_toolbarComponents__u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)1, (int)12, (int)0, (int)0));
        JLabel viewByLabel = jLabel;
        components.add(viewByLabel);
        components.add(this.axisFilterDropDown);
        return components;
    }

    @Override
    public void onSelectionChanged(boolean selected) {
        if (selected) {
            this.selection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_FILTER, () -> MemoryVisualizationView.onSelectionChanged$lambda$0(this));
            Object object = this.selection.getSelectedHeapSet();
            if (object == null || (object = object.getClassGrouping()) == null) {
                return;
            }
            this.initialClassGrouping = object;
            this.rebuildUI();
            this.selection.getFilterHandler().refreshFilterContent();
        } else {
            this.selection.getAspect().removeDependencies((AspectObserver)this);
            HeapSet heapSet = this.selection.getSelectedHeapSet();
            if (heapSet != null) {
                ClassGrouping classGrouping = this.initialClassGrouping;
                if (classGrouping == null) {
                    return;
                }
                heapSet.setClassGrouping(classGrouping);
            }
            this.selection.getFilterHandler().refreshFilterContent();
        }
    }

    private final void rebuildUI() {
        HeapSet heapSet = this.selection.getSelectedHeapSet();
        if (heapSet != null) {
            heapSet.setClassGrouping(this.selection.getSelectedCapture() instanceof NativeAllocationSampleCaptureObject ? ClassGrouping.NATIVE_ARRANGE_BY_CALLSTACK : ClassGrouping.ARRANGE_BY_CALLSTACK);
        }
        this.panel.removeAll();
        this.panel.add((Component)this.createChartPanel(), "Center");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    private final JPanel createChartPanel() {
        if (this.selection.getSelectedHeapSet() == null) {
            return new JPanel();
        }
        HeapSet heapSet = this.selection.getSelectedHeapSet();
        Intrinsics.checkNotNull((Object)heapSet);
        ClassifierSetHNode selected = new ClassifierSetHNode(this.model, heapSet, 0);
        selected.updateChildrenOffsets();
        Range captureRange = new Range(0.0, (double)selected.getEnd());
        Range globalRange = new Range(captureRange);
        RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(globalRange, captureRange, TimeUnit.MICROSECONDS);
        horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
        AxisComponent axis = this.createAxis(this.model.formatter(), captureRange);
        HTreeChart<ClassifierSetHNode> chart = this.createChart(selected, captureRange, globalRange);
        chart.addMouseMotionListener((MouseMotionListener)new MemoryVisualizationTooltipView(chart, this.profilersView.getComponent(), new VisualizationTooltipModel(captureRange, this.model)));
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
        panel.add((Component)axis, new TabularLayout.Constraint(0, 0, 0, 4, null));
        panel.add((Component)chart, new TabularLayout.Constraint(0, 0, 0, 4, null));
        panel.add((Component)new HTreeChartVerticalScrollBar(chart), new TabularLayout.Constraint(0, 1, 0, 4, null));
        panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
        CodeNavigator navigator = this.profilersView.getStudioProfilers().getIdeServices().getCodeNavigator();
        this.profilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, () -> MemoryVisualizationView.createChartPanel$lambda$0(this, chart));
        return panel;
    }

    private final CodeLocation getCodeLocation(HTreeChart<ClassifierSetHNode> chart) {
        ClassifierSet nativeSet;
        ClassifierSetHNode classifierSetHNode = (ClassifierSetHNode)chart.getFocusedNode();
        ClassifierSet classifierSet = nativeSet = classifierSetHNode != null ? classifierSetHNode.getData() : null;
        if (nativeSet instanceof NativeCallStackSet && !Strings.isNullOrEmpty((String)((NativeCallStackSet)nativeSet).getFileName())) {
            return new CodeLocation.Builder(((NativeCallStackSet)nativeSet).getName()).setMethodName(((NativeCallStackSet)nativeSet).getName()).setFileName(((NativeCallStackSet)nativeSet).getFileName()).setLineNumber(((NativeCallStackSet)nativeSet).getLineNumber() - 1).build();
        }
        return null;
    }

    private final AxisComponent createAxis(BaseAxisFormatter formatter, Range range) {
        ResizingAxisComponentModel resizingAxisComponentModel = new ResizingAxisComponentModel.Builder(range, formatter).build();
        Intrinsics.checkNotNullExpressionValue((Object)resizingAxisComponentModel, (String)"build(...)");
        AxisComponentModel axisModel = (AxisComponentModel)resizingAxisComponentModel;
        AxisComponent axis = new AxisComponent(axisModel, AxisComponent.AxisOrientation.BOTTOM, true);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        axis.addComponentListener((ComponentListener)new ComponentAdapter(axis){
            final /* synthetic */ AxisComponent $axis;
            {
                this.$axis = $axis;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$axis.setMarkerLengths(this.$axis.getHeight(), 0);
                this.$axis.repaint();
            }
        });
        return axis;
    }

    private final HTreeChart<ClassifierSetHNode> createChart(ClassifierSetHNode node, Range range, Range globalRange) {
        HTreeChart hTreeChart;
        HTreeChart.Orientation orientation = HTreeChart.Orientation.TOP_DOWN;
        HTreeChart $this$createChart_u24lambda_u240 = hTreeChart = new HTreeChart.Builder((HNode)node, range, (HRenderer)new HeapSetNodeHRenderer()).setGlobalXRange(globalRange).setOrientation(orientation).setRootVisible(false).build();
        boolean bl = false;
        $this$createChart_u24lambda_u240.setDrawDebugInfo(this.profilersView.getStudioProfilers().getIdeServices().getFeatureConfig().isPerformanceMonitoringEnabled());
        return hTreeChart;
    }

    private static final Unit _init_$lambda$0(MemoryVisualizationView this$0, MemoryVisualizationModel.XAxisFilter filter) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        this$0.model.setAxisFilter(filter);
        this$0.axisFilterFlow.setValue(((Selection)this$0.axisFilterFlow.getValue()).select(filter));
        this$0.rebuildUI();
        return Unit.INSTANCE;
    }

    private static final String _init_$lambda$1(MemoryVisualizationModel.XAxisFilter it) {
        return String.valueOf((Object)it);
    }

    private static final void onSelectionChanged$lambda$0(MemoryVisualizationView this$0) {
        this$0.rebuildUI();
    }

    private static final CodeLocation createChartPanel$lambda$0(MemoryVisualizationView this$0, HTreeChart $chart) {
        return this$0.getCodeLocation((HTreeChart<ClassifierSetHNode>)$chart);
    }
}

