/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.NativeAllocationMethodSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import kotlin.jvm.functions.Function1;

final class NativeFunctionClassifier {
    NativeFunctionClassifier() {
    }

    public static Classifier of(int depth) {
        return new Classifier.Join<Memory.AllocationStack.StackFrame>(NativeFunctionClassifier.stackFrameAt(depth), frame -> new NativeCallStackSet((Memory.AllocationStack.StackFrame)frame, depth + 1), Classifier.of(inst -> inst.getClassEntry().getClassName(), NativeAllocationMethodSet::new));
    }

    private static Function1<InstanceObject, Memory.AllocationStack.StackFrame> stackFrameAt(int depth) {
        return instance -> {
            int stackDepth = instance.getCallStackDepth();
            Memory.AllocationStack stack = instance.getAllocationCallStack();
            if (stackDepth <= 0 || depth >= stackDepth || stack == null) {
                return null;
            }
            int frameIndex = stackDepth - depth - 1;
            Memory.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
            return fullStack.getFrames(frameIndex);
        };
    }
}

