/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.BitmapDuplicationInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaptureObject
extends MemoryObject {
    public static final String DEFAULT_HEAP_NAME = "default";
    public static final String IMAGE_HEAP_NAME = "image";
    public static final String ZYGOTE_HEAP_NAME = "zygote";
    public static final String APP_HEAP_NAME = "app";
    public static final String JNI_HEAP_NAME = "JNI";
    public static final String NATIVE_HEAP_NAME = "Native";
    public static final String ALL_HEAP_NAME = "All";
    public static final int DEFAULT_HEAP_ID = 0;
    public static final int JNI_HEAP_ID = 4;
    public static final int DEFAULT_CLASSLOADER_ID = -1;
    public static final String INVALID_HEAP_NAME = "INVALID";

    @Nullable
    default public String getInfoMessage() {
        return null;
    }

    @Nullable
    default public Common.Session getSession() {
        return null;
    }

    @Nullable
    default public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        return null;
    }

    default public boolean isExportable() {
        return false;
    }

    @Nullable
    public String getExportableExtension();

    public void saveToFile(@NotNull OutputStream var1) throws IOException;

    @Nullable
    default public Memory.AllocationStack.StackFrame getStackFrame(long methodId) {
        return null;
    }

    @NotNull
    public List<ClassifierAttribute> getClassifierAttributes();

    @NotNull
    public List<InstanceAttribute> getInstanceAttributes();

    @NotNull
    public Collection<HeapSet> getHeapSets();

    @Nullable
    public HeapSet getHeapSet(int var1);

    @NotNull
    public Stream<InstanceObject> getInstances();

    public long getStartTimeNs();

    public long getEndTimeNs();

    @NotNull
    public ClassDb getClassDatabase();

    public boolean load(@Nullable Range var1, @Nullable Executor var2);

    public boolean isDoneLoading();

    public boolean isError();

    public void unload();

    @NotNull
    default public Set<CaptureObjectInstanceFilter> getSupportedClassTypeFilters() {
        return Collections.EMPTY_SET;
    }

    @NotNull
    default public Set<CaptureObjectInstanceFilter> getSupportedIssueTypeFilters() {
        return Collections.EMPTY_SET;
    }

    @Nullable
    default public ActivityFragmentLeakInstanceFilter getActivityFragmentLeakFilter() {
        return null;
    }

    @Nullable
    default public BitmapDuplicationInstanceFilter getBitmapDuplicationFilter() {
        return null;
    }

    @NotNull
    default public Set<CaptureObjectInstanceFilter> getSelectedInstanceFilters() {
        return Collections.EMPTY_SET;
    }

    default public ListenableFuture<Void> setClassTypeFilter(@Nullable CaptureObjectInstanceFilter filter, @NotNull Executor analyzeJoiner) {
        return Utils.makeEmptyTask();
    }

    default public ListenableFuture<Void> setIssueTypeFilter(@Nullable CaptureObjectInstanceFilter filter, @NotNull Executor analyzeJoiner) {
        return Utils.makeEmptyTask();
    }

    default public boolean isGroupingSupported(ClassGrouping grouping) {
        switch (grouping) {
            case ARRANGE_BY_CLASS: 
            case ARRANGE_BY_PACKAGE: 
            case ARRANGE_BY_CALLSTACK: {
                return true;
            }
        }
        return false;
    }

    default public boolean canSafelyLoad() {
        return true;
    }

    public static class Utils {
        static ListenableFutureTask<Void> makeEmptyTask() {
            return ListenableFutureTask.create(() -> null);
        }
    }

    public static enum InstanceAttribute {
        LABEL(1, SortOrder.ASCENDING),
        ALLOCATION_TIME(3, SortOrder.DESCENDING),
        DEALLOCATION_TIME(2, SortOrder.DESCENDING),
        DEPTH(0, SortOrder.ASCENDING),
        NATIVE_SIZE(4, SortOrder.DESCENDING),
        SHALLOW_SIZE(5, SortOrder.DESCENDING),
        RETAINED_SIZE(6, SortOrder.DESCENDING);

        private final int myWeight;
        @NotNull
        private final SortOrder mySortOrder;

        private InstanceAttribute(int weight, SortOrder sortOrder) {
            this.myWeight = weight;
            this.mySortOrder = sortOrder;
        }

        public int getWeight() {
            return this.myWeight;
        }

        @NotNull
        public SortOrder getSortOrder() {
            return this.mySortOrder;
        }
    }

    public static enum ClassifierAttribute {
        LABEL(0, SortOrder.ASCENDING),
        ALLOCATIONS(2, SortOrder.DESCENDING),
        DEALLOCATIONS(1, SortOrder.DESCENDING),
        TOTAL_COUNT(3, SortOrder.DESCENDING),
        NATIVE_SIZE(4, SortOrder.DESCENDING),
        SHALLOW_SIZE(5, SortOrder.DESCENDING),
        RETAINED_SIZE(6, SortOrder.DESCENDING),
        ALLOCATIONS_SIZE(7, SortOrder.DESCENDING),
        DEALLOCATIONS_SIZE(8, SortOrder.DESCENDING),
        REMAINING_SIZE(9, SortOrder.DESCENDING),
        MODULE(10, SortOrder.ASCENDING),
        SHALLOW_DIFFERENCE(0, SortOrder.DESCENDING);

        private final int myWeight;
        @NotNull
        private final SortOrder mySortOrder;

        private ClassifierAttribute(int weight, SortOrder sortOrder) {
            this.myWeight = weight;
            this.mySortOrder = sortOrder;
        }

        public int getWeight() {
            return this.myWeight;
        }

        @NotNull
        public SortOrder getSortOrder() {
            return this.mySortOrder;
        }
    }
}

