/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.MemoryTimelineComponent;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class MemoryUsageTooltipView
extends TooltipView {
    @NotNull
    private final MemoryUsageTooltip myTooltip;

    MemoryUsageTooltipView(@NotNull StageView view, @NotNull MemoryUsageTooltip tooltip) {
        super(((Stage)((Object)view.getStage())).getTimeline());
        this.myTooltip = tooltip;
    }

    @NotNull
    protected JComponent createTooltip() {
        MemoryStageLegends legends2 = this.myTooltip.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends2).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        if (this.myTooltip.useLiveAllocationTracking()) {
            legend.configure((Legend)legends2.getJavaLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_JAVA_CAPTURED));
            legend.configure((Legend)legends2.getNativeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_NATIVE_CAPTURED));
            legend.configure((Legend)legends2.getGraphicsLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_GRAPHICS_CAPTURED));
            legend.configure((Legend)legends2.getStackLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_STACK_CAPTURED));
            legend.configure((Legend)legends2.getCodeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_CODE_CAPTURED));
            legend.configure((Legend)legends2.getOtherLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_OTHERS_CAPTURED));
            legend.configure((Legend)legends2.getObjectsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.MEMORY_OBJECTS_CAPTURED));
            legend.configure(legends2.getGcDurationLegend(), new LegendConfig(LegendConfig.IconType.NONE, ProfilerColors.MEMORY_OBJECTS_CAPTURED));
            legend.configure(legends2.getSamplingRateDurationLegend(), new LegendConfig(legendStr -> MemoryTimelineComponent.getIconForSamplingMode(BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.getModeFromDisplayName(legendStr)), UIUtil.TRANSPARENT_COLOR));
        } else {
            legend.configure((Legend)legends2.getJavaLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_JAVA));
            legend.configure((Legend)legends2.getNativeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_NATIVE));
            legend.configure((Legend)legends2.getGraphicsLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_GRAPHICS));
            legend.configure((Legend)legends2.getStackLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_STACK));
            legend.configure((Legend)legends2.getCodeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_CODE));
            legend.configure((Legend)legends2.getOtherLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_OTHERS));
            legend.configure((Legend)legends2.getObjectsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.MEMORY_OBJECTS));
        }
        legend.configure((Legend)legends2.getTotalLegend(), new LegendConfig(LegendConfig.IconType.NONE, ProfilerColors.DEFAULT_STAGE_BACKGROUND));
        return legend;
    }
}

