/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerDropDownComponent;
import com.android.tools.profilers.ProfilerFlows;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Selection;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryHeapView
extends AspectObserver {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final JPanel myHeapToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
    @NotNull
    private final ProfilerDropDownComponent<HeapSet> myHeapDropDownComponent;
    @NotNull
    private final MutableStateFlow<Selection<HeapSet>> myHeapSelectionFlow;
    @Nullable
    private CaptureObject myCaptureObject = null;
    @Nullable
    private List<HeapSet> myHeaps = null;

    MemoryHeapView(@NotNull MemoryCaptureSelection selection) {
        this.mySelection = selection;
        this.myHeapSelectionFlow = ProfilerFlows.createMutableStateFlow(Selection.Companion.emptySelection());
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::setNewCapture).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::updateCaptureState).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP, this::refreshHeap);
        JLabel heapLabel = new JLabel("Heap:");
        heapLabel.setForeground(UIUtil.getLabelDisabledForeground());
        heapLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)12, (int)0, (int)0));
        this.myHeapToolbar.add(heapLabel);
        this.myHeapDropDownComponent = new ProfilerDropDownComponent<HeapSet>(StringUtils.capitalize((String)"app"), "Select heap", null, (StateFlow<Selection<HeapSet>>)this.myHeapSelectionFlow, (Function1<HeapSet, Icon>)null, (Function1<HeapSet, Unit>)((Function1)heap -> {
            this.mySelection.selectHeapSet((HeapSet)heap);
            return Unit.INSTANCE;
        }), (Function1<HeapSet, String>)((Function1)this::getHeapDisplayName));
        this.myHeapToolbar.add(this.myHeapDropDownComponent);
        this.setNewCapture();
        this.refreshHeap();
    }

    @NotNull
    JComponent getComponent() {
        return this.myHeapToolbar;
    }

    @VisibleForTesting
    @NotNull
    ProfilerDropDownComponent<HeapSet> getHeapDropDown() {
        return this.myHeapDropDownComponent;
    }

    private void setNewCapture() {
        this.myCaptureObject = this.mySelection.getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.myHeaps = null;
            return;
        }
        this.mySelection.selectHeapSet(null);
        this.myHeaps = new ArrayList<HeapSet>(this.myCaptureObject.getHeapSets());
        this.refreshHeap();
    }

    private void updateCaptureState() {
        this.setNewCapture();
    }

    private void refreshHeap() {
        HeapSet heapSet = this.mySelection.getSelectedHeapSet();
        List<Object> heaps = this.myHeaps == null ? Collections.emptyList() : this.myHeaps;
        this.myHeapSelectionFlow.setValue(new Selection<HeapSet>(heapSet, heaps));
    }

    private String getHeapDisplayName(HeapSet value) {
        if (value != null) {
            return StringUtils.capitalize((String)value.getName());
        }
        return StringUtils.capitalize((String)"app");
    }
}

