/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.LiveDataView;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.memory.DetailedMemoryChart;
import com.android.tools.profilers.memory.GarbageCollectionComponent;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.LiveMemoryFootprintModel;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.android.tools.profilers.memory.MemoryUsageTooltipView;
import com.android.tools.profilers.sessions.SessionAspect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LiveMemoryFootprintView
extends LiveDataView<LiveMemoryFootprintModel> {
    public final DetailedMemoryChart myDetailedMemoryChart;
    public final JComponent myComponent;
    private final TooltipModel myMemoryUsageTooltip;
    private final LiveMemoryFootprintModel myMemoryFootprintModel;
    private final StudioProfilersView myProfilersView;
    private final JButton myForceGarbageCollectionButton;
    private final DefaultContextMenuItem myForceGarbageCollectionAction;
    private final DurationDataRenderer<GcDurationData> gcDurationDataRenderer;
    private final GarbageCollectionComponent myGarbageCollectionComponent;

    public LiveMemoryFootprintView(@NotNull StudioProfilersView profilersView, @NotNull LiveMemoryFootprintModel memoryFootprintModel) {
        super(memoryFootprintModel);
        this.myMemoryFootprintModel = memoryFootprintModel;
        this.myProfilersView = profilersView;
        this.myDetailedMemoryChart = new DetailedMemoryChart(this.myMemoryFootprintModel.getDetailedMemoryUsage(), this.myMemoryFootprintModel.getLegends(), (Timeline)this.myMemoryFootprintModel.getTimeline(), this.myMemoryFootprintModel.getMemoryAxis(), this.myMemoryFootprintModel.getObjectAxis(), this.myMemoryFootprintModel.getRangeSelectionModel(), new JPanel(), profilersView.getComponent(), this.myMemoryFootprintModel.isLiveAllocationTrackingReady(), (Function0<Boolean>)((Function0)this::shouldShowTooltip), LineChart.ALWAYS_1);
        this.myGarbageCollectionComponent = new GarbageCollectionComponent();
        TabularLayout topPanelLayout = new TabularLayout("*", "*,Fit-");
        this.myComponent = new JPanel((LayoutManager)topPanelLayout);
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myMemoryUsageTooltip = this.myMemoryFootprintModel.getTooltip();
        this.myForceGarbageCollectionButton = this.myGarbageCollectionComponent.makeGarbageCollectionButton(memoryFootprintModel.getMemoryDataProvider(), profilersView.getStudioProfilers());
        this.myForceGarbageCollectionAction = this.myGarbageCollectionComponent.makeGarbageCollectionAction(this.myMemoryFootprintModel.getStudioProfilers(), this.myForceGarbageCollectionButton, this.getComponent());
        this.myForceGarbageCollectionButton.setToolTipText(this.myForceGarbageCollectionAction.getDefaultToolTipText());
        this.gcDurationDataRenderer = this.myGarbageCollectionComponent.makeGcDurationDataRenderer(memoryFootprintModel.getDetailedMemoryUsage(), memoryFootprintModel.getTooltipLegends());
        this.myDetailedMemoryChart.registerRenderer((AbstractDurationDataRenderer)this.getGcDurationDataRenderer());
    }

    @VisibleForTesting
    DurationDataRenderer<GcDurationData> getGcDurationDataRenderer() {
        return this.gcDurationDataRenderer;
    }

    @VisibleForTesting
    public JButton getGarbageCollectionButton() {
        return this.myForceGarbageCollectionButton;
    }

    @VisibleForTesting
    private DefaultContextMenuItem getGarbageCollectionAction() {
        return this.myForceGarbageCollectionAction;
    }

    public Boolean shouldShowTooltip() {
        return true;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    private RangeSelectionComponent getRangeSelectionComponent() {
        return this.myDetailedMemoryChart.getRangeSelectionComponent();
    }

    @Override
    public void registerTooltip(ViewBinder<StageView, TooltipModel, TooltipView> binder, @NotNull RangeTooltipComponent tooltip, Stage stage) {
        this.getTooltipComponent().addMouseListener(new ProfilerTooltipMouseAdapter(stage, () -> this.myMemoryUsageTooltip));
        binder.bind(MemoryUsageTooltip.class, MemoryUsageTooltipView::new);
        stage.setTooltip(this.myMemoryUsageTooltip);
        tooltip.registerListenersOn(this.getTooltipComponent());
    }

    @Override
    public void populateUi(RangeTooltipComponent tooltipComponent) {
        this.myComponent.add((Component)tooltipComponent, new TabularLayout.Constraint(0, 0, 2, 1));
        this.myComponent.add((Component)this.myDetailedMemoryChart.makeMonitorPanel(this.myDetailedMemoryChart.getOverlayPanel()), new TabularLayout.Constraint(0, 0));
        this.buildContextMenu();
        Runnable onSessionChanged = () -> this.myGarbageCollectionComponent.updateGcButton(this.myMemoryFootprintModel.getStudioProfilers(), this.myForceGarbageCollectionButton);
        this.myMemoryFootprintModel.getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, onSessionChanged);
    }

    private void buildContextMenu() {
        IdeProfilerComponents ideProfilerComponents = this.myProfilersView.getIdeProfilerComponents();
        ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.getRangeSelectionComponent(), ContextMenuItem.SEPARATOR);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.getRangeSelectionComponent(), (ContextMenuItem)this.getGarbageCollectionAction());
        contextMenuInstaller.installGenericContextMenu((JComponent)this.getRangeSelectionComponent(), ContextMenuItem.SEPARATOR);
        this.myProfilersView.installCommonMenuItems((JComponent)this.getRangeSelectionComponent());
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        panel.add((Component)toolbar, "West");
        toolbar.removeAll();
        toolbar.add(this.myForceGarbageCollectionButton);
        this.myGarbageCollectionComponent.updateGcButton(this.myMemoryFootprintModel.getStudioProfilers(), this.myForceGarbageCollectionButton);
        return panel;
    }

    public JComponent getTooltipComponent() {
        return this.myDetailedMemoryChart.getRangeSelectionComponent();
    }
}

