/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.intellij.ui.JBColor;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B%\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J4\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000fH\u0016J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001cH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/android/tools/profilers/memory/HeapDumpRenderer;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/adtui/chart/linechart/AbstractDurationDataRenderer;", "model", "Lcom/android/tools/adtui/model/DurationDataModel;", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "viewRange", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Lcom/android/tools/adtui/model/DurationDataModel;Lcom/android/tools/adtui/model/Range;)V", "startsCache", "Lit/unimi/dsi/fastutil/doubles/DoubleArrayList;", "durationsCache", "labelCache", "", "Ljavax/swing/JLabel;", "mousePosition", "Ljava/awt/Point;", "heapDumpHoveredListener", "Ljava/util/function/Consumer;", "", "mouseOverHeapDump", "isMouseOverHeapDump", "()Z", "setMouseOverHeapDump", "(Z)V", "addHeapDumpHoverListener", "", "listener", "renderLines", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "g2d", "Ljava/awt/Graphics2D;", "transformedPaths", "Ljava/awt/geom/Path2D;", "transformedSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "renderOverlay", "host", "Ljava/awt/Component;", "handleMouseEvent", "overlayComponent", "selectionComponent", "event", "Ljava/awt/event/MouseEvent;", "modelChanged", "Companion", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHeapDumpRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapDumpRenderer.kt\ncom/android/tools/profilers/memory/HeapDumpRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1869#2,2:181\n1761#2,3:183\n*S KotlinDebug\n*F\n+ 1 HeapDumpRenderer.kt\ncom/android/tools/profilers/memory/HeapDumpRenderer\n*L\n55#1:181,2\n140#1:183,3\n*E\n"})
public final class HeapDumpRenderer
extends AspectObserver
implements AbstractDurationDataRenderer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> model;
    @NotNull
    private final Range viewRange;
    @NotNull
    private final DoubleArrayList startsCache;
    @NotNull
    private final DoubleArrayList durationsCache;
    @NotNull
    private final List<JLabel> labelCache;
    @NotNull
    private Point mousePosition;
    @NotNull
    private final List<Consumer<Boolean>> heapDumpHoveredListener;
    private boolean isMouseOverHeapDump;
    public static final int $stable = 8;
    @Deprecated
    public static final double labelXPadding = 4.0;
    @Deprecated
    public static final double labelYPadding = 4.0;
    private static final JBColor labelBgColor = JBColor.DARK_GRAY;
    private static final JBColor labelColor = JBColor.WHITE;

    public HeapDumpRenderer(@NotNull DurationDataModel<CaptureDurationData<? extends CaptureObject>> model, @NotNull Range viewRange) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        this.model = model;
        this.viewRange = viewRange;
        this.startsCache = new DoubleArrayList();
        this.durationsCache = new DoubleArrayList();
        this.labelCache = new ArrayList();
        this.mousePosition = new Point();
        this.heapDumpHoveredListener = new ArrayList();
        this.model.addDependency((AspectObserver)this).onChange((Enum)DurationDataModel.Aspect.DURATION_DATA, this::modelChanged);
    }

    public final boolean isMouseOverHeapDump() {
        return this.isMouseOverHeapDump;
    }

    private final void setMouseOverHeapDump(boolean mouseOverHeapDump) {
        this.isMouseOverHeapDump = mouseOverHeapDump;
        Iterable $this$forEach$iv = this.heapDumpHoveredListener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.accept(mouseOverHeapDump);
        }
    }

    public final void addHeapDumpHoverListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        listener.accept(this.isMouseOverHeapDump);
        this.heapDumpHoveredListener.add(listener);
    }

    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> transformedSeries) {
        Intrinsics.checkNotNullParameter((Object)lineChart, (String)"lineChart");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter(transformedPaths, (String)"transformedPaths");
        Intrinsics.checkNotNullParameter(transformedSeries, (String)"transformedSeries");
        Shape origClip = g2d.getClip();
        double origX = origClip.getBounds().x;
        int origY = origClip.getBounds().y;
        int origWidth = origClip.getBounds().width;
        int origHeight = origClip.getBounds().height;
        Dimension dim = lineChart.getSize();
        int dimWidth = dim.width;
        int dimHeight = dim.height;
        double height = Math.min(origHeight, dimHeight);
        Rectangle2D.Float clipRect = new Rectangle2D.Float();
        int n = this.startsCache.size();
        for (int i = 0; i < n; ++i) {
            Graphics2D graphics2D;
            double xStart = this.startsCache.getDouble(i);
            double xLen = this.durationsCache.getDouble(i);
            double scaledXStart = xStart * (double)dimWidth;
            double scaledDuration = xLen * (double)dimWidth;
            double newX = Math.max(scaledXStart, origX);
            clipRect.setRect(newX, (double)origY, Math.min(scaledDuration + scaledXStart - newX, origX + (double)origWidth - newX), height);
            Graphics2D $this$renderLines_u24lambda_u240 = graphics2D = g2d;
            boolean bl = false;
            $this$renderLines_u24lambda_u240.setColor(ProfilerColors.MEMORY_HEAP_DUMP_BG);
            $this$renderLines_u24lambda_u240.setClip(clipRect);
            $this$renderLines_u24lambda_u240.fill(clipRect);
            int left = (int)clipRect.x;
            int right = (int)(clipRect.x + clipRect.width);
            int height2 = (int)clipRect.height;
            int top = (int)clipRect.y;
            int bottom = (int)clipRect.y + height2;
            int midY = top + height2 / 2;
            $this$renderLines_u24lambda_u240.setColor(scaledXStart < (double)this.mousePosition.x && (double)this.mousePosition.x < scaledXStart + scaledDuration ? (Color)StudioColorsKt.getSelectionOverlayBackground() : (Color)StudioColorsKt.getPrimaryContentBackground());
            $this$renderLines_u24lambda_u240.fill(clipRect);
            $this$renderLines_u24lambda_u240.setColor(StudioColorsKt.getLinkForeground());
            float[] fArray = new float[]{8.0f, 8.0f};
            $this$renderLines_u24lambda_u240.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f));
            $this$renderLines_u24lambda_u240.drawLine(left, midY, right, midY);
            $this$renderLines_u24lambda_u240.setStroke(new BasicStroke(4.0f));
            $this$renderLines_u24lambda_u240.drawLine(left, top, left, bottom);
            $this$renderLines_u24lambda_u240.drawLine(right, top, right, bottom);
            JLabel label = this.labelCache.get(i);
            boolean bl2 = false;
            g2d.setColor((Color)labelBgColor);
            g2d.fillRect((int)clipRect.x, (int)((double)clipRect.height - 8.0 - (double)label.getHeight()), (int)((double)label.getWidth() + 8.0), (int)((double)label.getHeight() + 8.0));
            double labelXOffset = scaledXStart + 4.0;
            double labelYOffset = (double)(clipRect.height - (float)label.getHeight()) - 4.0;
            g2d.translate(labelXOffset, labelYOffset);
            label.paint(g2d);
            g2d.translate(-labelXOffset, -labelYOffset);
        }
        g2d.setClip(origClip);
    }

    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleMouseEvent(@NotNull Component overlayComponent, @NotNull Component selectionComponent, @NotNull MouseEvent event) {
        boolean bl;
        HeapDumpRenderer heapDumpRenderer;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)overlayComponent, (String)"overlayComponent");
            Intrinsics.checkNotNullParameter((Object)selectionComponent, (String)"selectionComponent");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean it = bl2 = false;
            boolean bl3 = false;
            Point point = event.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.mousePosition = point;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.startsCache.size());
            heapDumpRenderer = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl4 = false;
                    double xStart = this.startsCache.getDouble(i);
                    double xLen = this.durationsCache.getDouble(i);
                    double scaledStartX = xStart * (double)overlayComponent.getWidth();
                    double scaledDur = xLen * (double)overlayComponent.getWidth();
                    if (!(scaledStartX < (double)this.mousePosition.x && (double)this.mousePosition.x < scaledStartX + scaledDur && overlayComponent.getY() < this.mousePosition.y && this.mousePosition.y < overlayComponent.getY() + overlayComponent.getHeight())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        heapDumpRenderer.setMouseOverHeapDump(bl5);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    private final void modelChanged() {
        this.startsCache.clear();
        this.durationsCache.clear();
        this.labelCache.clear();
        RangedSeries rangedSeries = this.model.getSeries();
        Intrinsics.checkNotNullExpressionValue((Object)rangedSeries, (String)"getSeries(...)");
        RangedSeries series = rangedSeries;
        double xMin = series.getXRange().getMin();
        double xLen = series.getXRange().getLength();
        for (SeriesData data : series.getSeries()) {
            void $this$modelChanged_u24lambda_u240;
            JLabel jLabel;
            String string;
            this.startsCache.add(((double)data.x - xMin) / xLen);
            this.durationsCache.add((double)((CaptureDurationData)((Object)data.value)).getDurationUs() / xLen);
            if (((CaptureDurationData)((Object)data.value)).getDurationUs() == Long.MAX_VALUE) {
                string = "in progress";
            } else {
                String string2 = TimeAxisFormatter.DEFAULT.getFormattedString(this.viewRange.getLength(), (double)((CaptureDurationData)((Object)data.value)).getDurationUs(), true);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedString(...)");
            }
            String text = string;
            JLabel jLabel2 = jLabel = new JLabel("Dump (" + text + ")");
            List<JLabel> list = this.labelCache;
            boolean bl = false;
            $this$modelChanged_u24lambda_u240.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
            $this$modelChanged_u24lambda_u240.setForeground((Color)labelColor);
            $this$modelChanged_u24lambda_u240.setBackground((Color)JBColor.DARK_GRAY);
            Dimension size = $this$modelChanged_u24lambda_u240.getPreferredSize();
            $this$modelChanged_u24lambda_u240.setBounds(0, 0, size.width, size.height);
            list.add(jLabel);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/profilers/memory/HeapDumpRenderer$Companion;", "", "<init>", "()V", "labelXPadding", "", "labelYPadding", "labelBgColor", "Lcom/intellij/ui/JBColor;", "kotlin.jvm.PlatformType", "getLabelBgColor", "()Lcom/intellij/ui/JBColor;", "labelColor", "getLabelColor", "intellij.android.profilers.ui"})
    private static final class Companion {
        private Companion() {
        }

        public final JBColor getLabelBgColor() {
            return labelBgColor;
        }

        public final JBColor getLabelColor() {
            return labelColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

