/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.stdui.TimelineScrollbar;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.DetailedMemoryChart;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GarbageCollectionComponent;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.DoubleSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003:\u00017B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0017J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0004J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00032\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0014J\u001b\u0010)\u001a\u0015\u0012\f\u0012\n ,*\u0004\u0018\u00010+0+0*\u00a2\u0006\u0002\b\u000bH\u0004J\u001b\u0010-\u001a\u0015\u0012\f\u0012\n ,*\u0004\u0018\u00010.0.0*\u00a2\u0006\u0002\b\u000bH\u0004JI\u0010/\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u000201 ,*\f\u0012\u0006\b\u0001\u0012\u000201\u0018\u000100000*\u00a2\u0006\u0002\b\u000b2\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020100032\u0006\u00104\u001a\u000205H\u0004J\b\u00106\u001a\u00020\u0018H\u0002R\u001b\u0010\n\u001a\u00078\u0000\u00a2\u0006\u0002\b\u000bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryTimelineComponent;", "T", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "Lcom/intellij/ui/components/JBPanel;", "stageView", "Lcom/android/tools/profilers/StageView;", "timeAxis", "Ljavax/swing/JComponent;", "<init>", "(Lcom/android/tools/profilers/StageView;Ljavax/swing/JComponent;)V", "stage", "Lorg/jetbrains/annotations/NotNull;", "getStage", "()Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "getLineChart", "()Lcom/android/tools/adtui/chart/linechart/LineChart;", "overlay", "Lcom/android/tools/adtui/chart/linechart/OverlayComponent;", "detailedMemoryChart", "Lcom/android/tools/profilers/memory/DetailedMemoryChart;", "rangeSelectionComponent", "Lcom/android/tools/adtui/RangeSelectionComponent;", "getRangeSelectionComponent", "()Lcom/android/tools/adtui/RangeSelectionComponent;", "garbageCollectionComponent", "Lcom/android/tools/profilers/memory/GarbageCollectionComponent;", "shouldShowTooltip", "", "fillEndSupplier", "Ljava/util/function/DoubleSupplier;", "makeScrollbar", "registerRenderer", "", "renderer", "Lcom/android/tools/adtui/chart/linechart/AbstractDurationDataRenderer;", "makeMonitorPanel", "", "overlayPanel", "makeGcDurationDataRenderer", "Lcom/android/tools/adtui/chart/linechart/DurationDataRenderer;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "makeAllocationSamplingRateRenderer", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDurationData;", "makeAllocationRenderer", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "model", "Lcom/android/tools/adtui/model/DurationDataModel;", "tag", "", "makeRangeSelectionComponent", "Companion", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBaseMemoryTimelineComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMemoryTimelineComponent.kt\ncom/android/tools/profilers/memory/BaseMemoryTimelineComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public abstract class BaseMemoryTimelineComponent<T extends BaseStreamingMemoryProfilerStage>
extends JBPanel<BaseMemoryTimelineComponent<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T stage;
    @NotNull
    private final LineChart lineChart;
    @NotNull
    private final OverlayComponent overlay;
    @NotNull
    private final DetailedMemoryChart detailedMemoryChart;
    @NotNull
    private final RangeSelectionComponent rangeSelectionComponent;
    @NotNull
    private final GarbageCollectionComponent garbageCollectionComponent;
    public static final int $stable = 8;

    public BaseMemoryTimelineComponent(@NotNull StageView<T> stageView, @NotNull JComponent timeAxis) {
        Intrinsics.checkNotNullParameter(stageView, (String)"stageView");
        Intrinsics.checkNotNullParameter((Object)timeAxis, (String)"timeAxis");
        super((LayoutManager)new TabularLayout("*"));
        this.stage = (BaseStreamingMemoryProfilerStage)((Object)stageView.getStage());
        DetailedMemoryUsage detailedMemoryUsage = ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getDetailedMemoryUsage();
        MemoryStageLegends memoryStageLegends = ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getLegends();
        StreamingTimeline streamingTimeline = ((StreamingStage)((Object)this.stage)).getTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"getTimeline(...)");
        Timeline timeline = (Timeline)streamingTimeline;
        ClampedAxisComponentModel clampedAxisComponentModel = ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getMemoryAxis();
        ClampedAxisComponentModel clampedAxisComponentModel2 = ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getObjectsAxis();
        RangeSelectionModel rangeSelectionModel2 = ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getRangeSelectionModel();
        JPanel jPanel = stageView.getTooltipPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getTooltipPanel(...)");
        this.detailedMemoryChart = new DetailedMemoryChart(detailedMemoryUsage, memoryStageLegends, timeline, clampedAxisComponentModel, clampedAxisComponentModel2, rangeSelectionModel2, jPanel, stageView.getProfilersView().getComponent(), ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).isLiveAllocationTrackingReady(), (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

            public final Boolean invoke() {
                return ((BaseMemoryTimelineComponent)((Object)this.receiver)).shouldShowTooltip();
            }
        }), this.fillEndSupplier());
        this.garbageCollectionComponent = new GarbageCollectionComponent();
        this.lineChart = this.detailedMemoryChart.getLineChart();
        this.rangeSelectionComponent = this.detailedMemoryChart.getRangeSelectionComponent();
        this.overlay = this.detailedMemoryChart.getOverlay();
        this.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        JBPanel overlayPanel = this.detailedMemoryChart.getOverlayPanel();
        RangeTooltipComponent tooltip = this.detailedMemoryChart.getTooltip();
        LayoutManager layoutManager = this.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.android.tools.adtui.TabularLayout");
        ((TabularLayout)layoutManager).setRowSizing(1, "*");
        this.add((Component)tooltip, new TabularLayout.Constraint(0, 0, 2, 1));
        if (((StreamingStage)((Object)this.stage)).getStudioProfilers().getSelectedSessionSupportLevel() == SupportLevel.DEBUGGABLE) {
            EventMonitorView eventMonitorView;
            EventMonitorView $this$_init__u24lambda_u240 = eventMonitorView = new EventMonitorView(stageView.getProfilersView(), ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getEventMonitor());
            boolean bl = false;
            $this$_init__u24lambda_u240.registerTooltip(tooltip, (Stage)((Object)this.stage));
            EventMonitorView eventsView = eventMonitorView;
            this.add(eventsView.getComponent(), new TabularLayout.Constraint(0, 0, 0, 4, null));
        }
        JComponent jComponent = this.makeScrollbar();
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            this.add(it, new TabularLayout.Constraint(3, 0, 0, 4, null));
        }
        this.add(timeAxis, new TabularLayout.Constraint(2, 0, 0, 4, null));
        this.add((Component)this.makeMonitorPanel(overlayPanel), new TabularLayout.Constraint(1, 0, 0, 4, null));
    }

    @NotNull
    protected final T getStage() {
        return this.stage;
    }

    @NotNull
    protected final LineChart getLineChart() {
        return this.lineChart;
    }

    @NotNull
    public final RangeSelectionComponent getRangeSelectionComponent() {
        return this.rangeSelectionComponent;
    }

    protected boolean shouldShowTooltip() {
        return true;
    }

    @VisibleForTesting
    @NotNull
    public DoubleSupplier fillEndSupplier() {
        DoubleSupplier doubleSupplier = LineChart.ALWAYS_1;
        Intrinsics.checkNotNullExpressionValue((Object)doubleSupplier, (String)"ALWAYS_1");
        return doubleSupplier;
    }

    @Nullable
    protected JComponent makeScrollbar() {
        StreamingTimeline streamingTimeline = ((StreamingStage)((Object)this.stage)).getTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"getTimeline(...)");
        return (JComponent)new TimelineScrollbar((Timeline)streamingTimeline, (JComponent)((Object)this));
    }

    protected final void registerRenderer(@NotNull AbstractDurationDataRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.detailedMemoryChart.registerRenderer(renderer);
    }

    @NotNull
    protected JBPanel makeMonitorPanel(@NotNull JBPanel<?> overlayPanel) {
        Intrinsics.checkNotNullParameter(overlayPanel, (String)"overlayPanel");
        return this.detailedMemoryChart.makeMonitorPanel(overlayPanel);
    }

    @NotNull
    protected final DurationDataRenderer<GcDurationData> makeGcDurationDataRenderer() {
        return this.garbageCollectionComponent.makeGcDurationDataRenderer(((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getDetailedMemoryUsage(), ((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getTooltipLegends());
    }

    @NotNull
    protected final DurationDataRenderer<AllocationSamplingRateDurationData> makeAllocationSamplingRateRenderer() {
        DurationDataRenderer durationDataRenderer = new DurationDataRenderer.Builder(((BaseStreamingMemoryProfilerStage)((Object)this.stage)).getAllocationSamplingRateDurations(), (Color)JBColor.BLACK).setDurationBg(ProfilerColors.DEFAULT_STAGE_BACKGROUND).setIconMapper(BaseMemoryTimelineComponent::makeAllocationSamplingRateRenderer$lambda$0).setLabelOffsets((float)(-StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE.getIconHeight() / 2.0f).setHostInsets((Insets)JBUI.insets((int)ProfilerLayout.Y_AXIS_TOP_MARGIN, (int)0, (int)0, (int)0)).setClickRegionPadding(0, 0).setHoverHandler(arg_0 -> BaseMemoryTimelineComponent.makeAllocationSamplingRateRenderer$lambda$1(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)durationDataRenderer, (String)"build(...)");
        return durationDataRenderer;
    }

    @NotNull
    protected final DurationDataRenderer<CaptureDurationData<? extends CaptureObject>> makeAllocationRenderer(@NotNull DurationDataModel<CaptureDurationData<? extends CaptureObject>> model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        DurationDataRenderer durationDataRenderer = new DurationDataRenderer.Builder(model, (Color)JBColor.LIGHT_GRAY).setDurationBg(ProfilerColors.MEMORY_ALLOC_BG).setLabelColors((Color)JBColor.DARK_GRAY, (Color)JBColor.GRAY, (Color)JBColor.LIGHT_GRAY, (Color)JBColor.WHITE).setLabelProvider(arg_0 -> BaseMemoryTimelineComponent.makeAllocationRenderer$lambda$0(this, tag, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)durationDataRenderer, (String)"build(...)");
        return durationDataRenderer;
    }

    private final RangeSelectionComponent makeRangeSelectionComponent() {
        return this.detailedMemoryChart.makeRangeSelectionComponent();
    }

    private static final Icon makeAllocationSamplingRateRenderer$lambda$0(AllocationSamplingRateDurationData it) {
        return Companion.getIconForSamplingMode(BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.Companion.getModeFromFrequency(it.getCurrentRate().getSamplingNumInterval()));
    }

    private static final void makeAllocationSamplingRateRenderer$lambda$1(BaseMemoryTimelineComponent this$0, AllocationSamplingRateDurationData it) {
        ((BaseStreamingMemoryProfilerStage)((Object)this$0.stage)).getTooltipLegends().getSamplingRateDurationLegend().setPickData((DurationData)it);
    }

    private static final String makeAllocationRenderer$lambda$0(BaseMemoryTimelineComponent this$0, String $tag, CaptureDurationData it) {
        String string;
        if (it.getDurationUs() == Long.MAX_VALUE) {
            string = "in progress";
        } else {
            String string2 = TimeAxisFormatter.DEFAULT.getFormattedString(((StreamingStage)((Object)this$0.stage)).getTimeline().getViewRange().getLength(), (double)it.getDurationUs(), true);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedString(...)");
        }
        String duration = string;
        return $tag + " record (" + duration + ")";
    }

    @JvmStatic
    @NotNull
    public static final Icon getIconForSamplingMode(@NotNull BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode mode) {
        return Companion.getIconForSamplingMode(mode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryTimelineComponent$Companion;", "", "<init>", "()V", "getIconForSamplingMode", "Ljavax/swing/Icon;", "mode", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage$LiveAllocationSamplingMode;", "intellij.android.profilers.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Icon getIconForSamplingMode(@NotNull BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode mode) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    Icon icon2 = StudioIcons.Profiler.Events.ALLOCATION_TRACKING_FULL;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ALLOCATION_TRACKING_FULL");
                    break;
                }
                case 2: {
                    Icon icon3 = StudioIcons.Profiler.Events.ALLOCATION_TRACKING_SAMPLED;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ALLOCATION_TRACKING_SAMPLED");
                    break;
                }
                case 3: {
                    Icon icon4 = StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE;
                    icon = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ALLOCATION_TRACKING_NONE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.values().length];
                try {
                    nArray[BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.SAMPLED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

