/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.leakcanary;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.LeakCanary;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ExportableArtifact;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.leakcanary.LeakCanaryModel;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001/B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010#R\u0014\u0010$\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001cR\u0014\u0010(\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001c\u00a8\u00060"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanarySessionArtifact;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/LeakCanary$LeakCanaryAnalysisEnded;", "Lcom/android/tools/profilers/ExportableArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "leakCanaryAnalysisEnded", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;Lcom/android/tools/profiler/proto/LeakCanary$LeakCanaryAnalysisEnded;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getSession", "()Lcom/android/tools/profiler/proto/Common$Session;", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "artifactProto", "getArtifactProto", "()Lcom/android/tools/profiler/proto/LeakCanary$LeakCanaryAnalysisEnded;", "name", "", "getName", "()Ljava/lang/String;", "timestampNs", "", "getTimestampNs", "()J", "isOngoing", "", "()Z", "canExport", "getCanExport", "exportableName", "getExportableName", "exportExtension", "getExportExtension", "export", "", "outputStream", "Ljava/io/OutputStream;", "doSelect", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLeakCanarySessionArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanarySessionArtifact.kt\ncom/android/tools/profilers/leakcanary/LeakCanarySessionArtifact\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class LeakCanarySessionArtifact
implements SessionArtifact<LeakCanary.LeakCanaryAnalysisEnded>,
ExportableArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Common.Session session;
    @NotNull
    private final Common.SessionMetaData sessionMetaData;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LeakCanary.LeakCanaryAnalysisEnded artifactProto;
    @NotNull
    private final String name;
    private final long timestampNs;
    private final boolean isOngoing;

    public LeakCanarySessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull LeakCanary.LeakCanaryAnalysisEnded leakCanaryAnalysisEnded) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
        Intrinsics.checkNotNullParameter((Object)leakCanaryAnalysisEnded, (String)"leakCanaryAnalysisEnded");
        this.profilers = profilers;
        this.session = session;
        this.sessionMetaData = sessionMetaData;
        Logger logger = Logger.getInstance(LeakCanarySessionArtifact.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.artifactProto = leakCanaryAnalysisEnded;
        this.name = "LeakCanary";
        this.timestampNs = leakCanaryAnalysisEnded.getEndTimestamp();
        this.isOngoing = leakCanaryAnalysisEnded.getEndTimestamp() == Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    @Override
    @NotNull
    public LeakCanary.LeakCanaryAnalysisEnded getArtifactProto() {
        return this.artifactProto;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @Override
    public boolean isOngoing() {
        return this.isOngoing;
    }

    @Override
    public boolean getCanExport() {
        return !this.isOngoing();
    }

    @Override
    @NotNull
    public String getExportableName() {
        return "leakcanary-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss"));
    }

    @Override
    @NotNull
    public String getExportExtension() {
        return "asdb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        boolean bl = this.getCanExport();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Transport.BytesRequest request = Transport.BytesRequest.newBuilder().setStreamId(this.getSession().getStreamId()).setId(String.valueOf(this.getSession().getStartTimestamp())).build();
        Transport.FileResponse response = this.getProfilers().getClient().getTransportClient().getFile(request);
        String string = response.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        if (((CharSequence)string).length() > 0) {
            try {
                Long l;
                Object object = new FileInputStream(new File(response.getFilePath()));
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)object;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = l;
            }
            catch (IOException e) {
                this.logger.warn("Failed to export Leak Canary file", (Throwable)e);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.logger.warn("Failed to export Leak Canary file, file path is empty.");
        }
    }

    @Override
    public void doSelect() {
        boolean needsToOpenLeakCanary;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.getSession() != this.getProfilers().getSession();
        if (needsToChangeSession) {
            this.getProfilers().getSessionsManager().setSession(this.getSession());
        }
        boolean bl2 = needsToOpenLeakCanary = !(this.getProfilers().getStage() instanceof LeakCanaryModel);
        if (needsToOpenLeakCanary) {
            this.getProfilers().setStage(new LeakCanaryModel(this.getProfilers()));
        }
        Stage stage = this.getProfilers().getStage();
        Intrinsics.checkNotNull((Object)((Object)stage), (String)"null cannot be cast to non-null type com.android.tools.profilers.leakcanary.LeakCanaryModel");
        ((LeakCanaryModel)stage).loadFromPastSession(this.getArtifactProto().getStartTimestamp(), this.getArtifactProto().getEndTimestamp(), this.getSession());
        this.getProfilers().getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.getProfilers().getSessionsManager().isSessionAlive());
    }

    @JvmStatic
    @NotNull
    public static final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
        return Companion.getSessionArtifacts(profilers, session, sessionMetadata);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanarySessionArtifact$Companion;", "", "<init>", "()V", "getSessionArtifacts", "", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetadata", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nLeakCanarySessionArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanarySessionArtifact.kt\ncom/android/tools/profilers/leakcanary/LeakCanarySessionArtifact$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1869#2,2:114\n*S KotlinDebug\n*F\n+ 1 LeakCanarySessionArtifact.kt\ncom/android/tools/profilers/leakcanary/LeakCanarySessionArtifact$Companion\n*L\n105#1:114,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sessionMetadata, (String)"sessionMetadata");
            List artifacts = new ArrayList();
            ProfilerClient profilerClient = profilers.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"getClient(...)");
            List<Common.Event> leakInfoEvents = LeakCanaryModel.Companion.getLeakCanaryAnalysisInfo(profilerClient, session, new Range((double)session.getStartTimestamp(), (double)session.getEndTimestamp()));
            Iterable $this$forEach$iv = leakInfoEvents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Common.Event leakEvent = (Common.Event)element$iv;
                boolean bl = false;
                Companion $this$getSessionArtifacts_u24lambda_u240_u240 = Companion;
                boolean bl2 = false;
                LeakCanary.LeakCanaryAnalysisEnded leakCanaryAnalysisEnded = leakEvent.getLeakCanaryAnalysisStatus().getAnalysisEnded();
                Intrinsics.checkNotNullExpressionValue((Object)leakCanaryAnalysisEnded, (String)"getAnalysisEnded(...)");
                artifacts.add(new LeakCanarySessionArtifact(profilers, session, sessionMetadata, leakCanaryAnalysisEnded));
            }
            return artifacts;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

