/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.leakcanary;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.inspectors.common.api.actions.NavigateToCodeAction;
import com.android.tools.leakcanarylib.data.Analysis;
import com.android.tools.leakcanarylib.data.AnalysisFailure;
import com.android.tools.leakcanarylib.data.AnalysisSuccess;
import com.android.tools.leakcanarylib.data.AnalysisUpdate;
import com.android.tools.leakcanarylib.data.Leak;
import com.android.tools.leakcanarylib.data.LeakTrace;
import com.android.tools.leakcanarylib.data.LeakingStatus;
import com.android.tools.leakcanarylib.data.Node;
import com.android.tools.leakcanarylib.data.ReferencingField;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ModelStage;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.leakcanary.LeakCanaryHeapDumper;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 W2\u00020\u00012\u00020\u0002:\u0001WB\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000200J\u000e\u00104\u001a\u0002002\u0006\u0010\"\u001a\u00020!J\u000e\u00105\u001a\u0002002\u0006\u0010(\u001a\u00020\u0012J\u000e\u00106\u001a\u0002002\u0006\u0010+\u001a\u00020\u0012J\b\u00107\u001a\u000200H\u0007J\u0010\u00108\u001a\u0002002\b\u00109\u001a\u0004\u0018\u00010\u0018J\b\u0010:\u001a\u000200H\u0002J\b\u0010;\u001a\u000200H\u0002J\b\u0010<\u001a\u000200H\u0002J\u0016\u0010=\u001a\u0002002\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u0010\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020!2\u0006\u0010C\u001a\u00020DH\u0002J\u0012\u0010F\u001a\u0002002\b\u0010C\u001a\u0004\u0018\u00010DH\u0002J \u0010G\u001a\u0002002\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020!H\u0002J\b\u0010K\u001a\u00020LH\u0016J\u001e\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020$2\u0006\u0010O\u001a\u00020$2\u0006\u0010H\u001a\u00020\rJ&\u0010P\u001a\b\u0012\u0004\u0012\u00020D0\u00172\u0006\u0010H\u001a\u00020\r2\u0006\u0010N\u001a\u00020$2\u0006\u0010O\u001a\u00020$H\u0002J\u000e\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020SJ\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020!0U2\u0006\u0010R\u001a\u00020SJ\u0010\u0010V\u001a\u0002002\u0006\u0010%\u001a\u00020$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001cR\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001cR\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020!0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020!0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001c\u00a8\u0006X"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryModel;", "Lcom/android/tools/profilers/ModelStage;", "Lcom/android/tools/adtui/model/updater/Updatable;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "statusListener", "Lcom/android/tools/idea/transport/poller/TransportEventListener;", "hostAnalysisTriggerListener", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sessionData", "Lcom/android/tools/profiler/proto/Common$Session;", "Lorg/jetbrains/annotations/NotNull;", "heapDumper", "Lcom/android/tools/profilers/leakcanary/LeakCanaryHeapDumper;", "requiredRetainedObjectCount", "", "getRequiredRetainedObjectCount", "()I", "_leaks", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/android/tools/leakcanarylib/data/Leak;", "leaks", "Lkotlinx/coroutines/flow/StateFlow;", "getLeaks", "()Lkotlinx/coroutines/flow/StateFlow;", "_selectedLeak", "selectedLeak", "getSelectedLeak", "_isRecording", "", "isRecording", "_elapsedNs", "", "elapsedNs", "getElapsedNs", "_objectRetainedCount", "objectRetainedCount", "getObjectRetainedCount", "_analysisProgress", "analysisProgress", "getAnalysisProgress", "_isLeakCanaryPresent", "isLeakCanaryPresent", "enter", "", "exit", "startListening", "stopListening", "setIsRecording", "setObjectRetainedCount", "setAnalysisProgress", "clearLeaks", "onLeakSelection", "newLeak", "registerLeakCanaryListeners", "checkLeakCanaryPresence", "deregisterLeakCanaryListeners", "addLeaks", "newLeaks", "leakDetected", "event", "Lcom/android/tools/profiler/proto/Common$Event;", "handleRetainedObject", "analysis", "Lcom/android/tools/leakcanarylib/data/Analysis;", "handleAnalysisProgress", "handleLeakAnalysis", "toggleLeakCanaryLogcatTracking", "session", "enable", "endSession", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "loadFromPastSession", "startTimestamp", "endTimeStamp", "getAllLeakCanaryEvents", "goToDeclaration", "node", "Lcom/android/tools/leakcanarylib/data/Node;", "isDeclarationAvailableAsync", "Ljava/util/concurrent/CompletableFuture;", "update", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLeakCanaryModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n774#2:400\n865#2,2:401\n1869#2,2:403\n1617#2,9:405\n1869#2:414\n1870#2:416\n1626#2:417\n1#3:415\n*S KotlinDebug\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel\n*L\n201#1:400\n201#1:401,2\n292#1:403,2\n311#1:405,9\n311#1:414\n311#1:416\n311#1:417\n311#1:415\n*E\n"})
public final class LeakCanaryModel
extends ModelStage
implements Updatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    private TransportEventListener statusListener;
    private TransportEventListener hostAnalysisTriggerListener;
    @NotNull
    private final Logger logger;
    @NotNull
    private Common.Session sessionData;
    @NotNull
    private final LeakCanaryHeapDumper heapDumper;
    private final int requiredRetainedObjectCount;
    @NotNull
    private final MutableStateFlow<List<Leak>> _leaks;
    @NotNull
    private final StateFlow<List<Leak>> leaks;
    @NotNull
    private final MutableStateFlow<Leak> _selectedLeak;
    @NotNull
    private final StateFlow<Leak> selectedLeak;
    @NotNull
    private final MutableStateFlow<Boolean> _isRecording;
    @NotNull
    private final StateFlow<Boolean> isRecording;
    @NotNull
    private final MutableStateFlow<Long> _elapsedNs;
    @NotNull
    private final StateFlow<Long> elapsedNs;
    @NotNull
    private final MutableStateFlow<Integer> _objectRetainedCount;
    @NotNull
    private final StateFlow<Integer> objectRetainedCount;
    @NotNull
    private final MutableStateFlow<Integer> _analysisProgress;
    @NotNull
    private final StateFlow<Integer> analysisProgress;
    @NotNull
    private final MutableStateFlow<Boolean> _isLeakCanaryPresent;
    @NotNull
    private final StateFlow<Boolean> isLeakCanaryPresent;

    /*
     * WARNING - void declaration
     */
    public LeakCanaryModel(@NotNull StudioProfilers profilers) {
        void $this$heapDumper_u24lambda_u240;
        LeakCanaryHeapDumper leakCanaryHeapDumper;
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        super(profilers);
        this.profilers = profilers;
        Logger logger = Logger.getInstance(LeakCanaryModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.sessionData = session;
        LeakCanaryHeapDumper leakCanaryHeapDumper2 = leakCanaryHeapDumper = new LeakCanaryHeapDumper(this.profilers);
        LeakCanaryModel leakCanaryModel = this;
        boolean bl = false;
        $this$heapDumper_u24lambda_u240.setOnHostAnalysisFinished((Function1<? super Analysis, Unit>)((Function1)arg_0 -> LeakCanaryModel.heapDumper$lambda$0$0(this, arg_0)));
        leakCanaryModel.heapDumper = leakCanaryHeapDumper;
        this.requiredRetainedObjectCount = 5;
        this._leaks = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.leaks = FlowKt.asStateFlow(this._leaks);
        this._selectedLeak = StateFlowKt.MutableStateFlow(null);
        this.selectedLeak = FlowKt.asStateFlow(this._selectedLeak);
        this._isRecording = StateFlowKt.MutableStateFlow((Object)false);
        this.isRecording = FlowKt.asStateFlow(this._isRecording);
        this._elapsedNs = StateFlowKt.MutableStateFlow((Object)0L);
        this.elapsedNs = FlowKt.asStateFlow(this._elapsedNs);
        this._objectRetainedCount = StateFlowKt.MutableStateFlow((Object)0);
        this.objectRetainedCount = FlowKt.asStateFlow(this._objectRetainedCount);
        this._analysisProgress = StateFlowKt.MutableStateFlow((Object)0);
        this.analysisProgress = FlowKt.asStateFlow(this._analysisProgress);
        this._isLeakCanaryPresent = StateFlowKt.MutableStateFlow((Object)true);
        this.isLeakCanaryPresent = FlowKt.asStateFlow(this._isLeakCanaryPresent);
    }

    public final int getRequiredRetainedObjectCount() {
        return this.requiredRetainedObjectCount;
    }

    @NotNull
    public final StateFlow<List<Leak>> getLeaks() {
        return this.leaks;
    }

    @NotNull
    public final StateFlow<Leak> getSelectedLeak() {
        return this.selectedLeak;
    }

    @NotNull
    public final StateFlow<Boolean> isRecording() {
        return this.isRecording;
    }

    @NotNull
    public final StateFlow<Long> getElapsedNs() {
        return this.elapsedNs;
    }

    @NotNull
    public final StateFlow<Integer> getObjectRetainedCount() {
        return this.objectRetainedCount;
    }

    @NotNull
    public final StateFlow<Integer> getAnalysisProgress() {
        return this.analysisProgress;
    }

    @NotNull
    public final StateFlow<Boolean> isLeakCanaryPresent() {
        return this.isLeakCanaryPresent;
    }

    @Override
    public void enter() {
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.sessionData = session;
        if (!this.profilers.getSessionsManager().isSessionAlive()) {
            this.profilers.getSessionsManager().setTaskDb(this.sessionData);
        }
    }

    @Override
    public void exit() {
        this.profilers.getSessionsManager().unsetTaskDb(this.sessionData);
    }

    public final void startListening() {
        this.profilers.getUpdater().register((Updatable)this);
        this.setIsRecording(true);
        this.checkLeakCanaryPresence();
        this.setObjectRetainedCount(0);
        this.setAnalysisProgress(0);
        this.registerLeakCanaryListeners();
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.toggleLeakCanaryLogcatTracking(session, true, false);
    }

    public final void stopListening() {
        this.setIsRecording(false);
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.toggleLeakCanaryLogcatTracking(session, false, true);
        this.deregisterLeakCanaryListeners();
        this.profilers.getUpdater().unregister((Updatable)this);
        TaskEventTrackerUtils.trackTaskFinished(this.profilers, true, TaskFinishedState.COMPLETED);
    }

    public final void setIsRecording(boolean isRecording) {
        this._isRecording.setValue((Object)isRecording);
    }

    public final void setObjectRetainedCount(int objectRetainedCount) {
        this._objectRetainedCount.setValue((Object)objectRetainedCount);
    }

    public final void setAnalysisProgress(int analysisProgress) {
        this._analysisProgress.setValue((Object)analysisProgress);
    }

    @VisibleForTesting
    public final void clearLeaks() {
        this._leaks.setValue((Object)CollectionsKt.emptyList());
        this.onLeakSelection(null);
    }

    public final void onLeakSelection(@Nullable Leak newLeak) {
        this._selectedLeak.setValue((Object)newLeak);
    }

    private final void registerLeakCanaryListeners() {
        long startTime = this.profilers.getSession().getStartTimestamp();
        this.statusListener = new TransportEventListener(Common.Event.Kind.LEAKCANARY_ANALYSIS, this.profilers.getIdeServices().getMainExecutor(), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$0(this), () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$1(this), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$2(startTime), null, arg_0 -> LeakCanaryModel.registerLeakCanaryListeners$lambda$3(this, arg_0), 164, null);
        TransportEventPoller transportEventPoller = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener = this.statusListener;
        if (transportEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusListener");
            transportEventListener = null;
        }
        transportEventPoller.registerListener(transportEventListener);
        this.hostAnalysisTriggerListener = new TransportEventListener(Common.Event.Kind.LEAKCANARY_HOST_ANALYSIS_TRIGGER, this.profilers.getIdeServices().getPoolExecutor(), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$4(this), () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$5(this), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$6(startTime), null, arg_0 -> LeakCanaryModel.registerLeakCanaryListeners$lambda$7(this, arg_0), 164, null);
        TransportEventPoller transportEventPoller2 = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener2 = this.hostAnalysisTriggerListener;
        if (transportEventListener2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostAnalysisTriggerListener");
            transportEventListener2 = null;
        }
        transportEventPoller2.registerListener(transportEventListener2);
    }

    private final void checkLeakCanaryPresence() {
        Commands.Command.Builder builder;
        Commands.Command.Builder $this$checkLeakCanaryPresence_u24lambda_u240 = builder = Commands.Command.newBuilder();
        boolean bl = false;
        $this$checkLeakCanaryPresence_u24lambda_u240.setStreamId(this.profilers.getSession().getStreamId());
        $this$checkLeakCanaryPresence_u24lambda_u240.setPid(this.profilers.getSession().getPid());
        $this$checkLeakCanaryPresence_u24lambda_u240.setType(Commands.Command.CommandType.CHECK_LEAKCANARY_PRESENT);
        Commands.Command command = builder.build();
        this.profilers.getIdeServices().getPoolExecutor().execute(() -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1(this, command));
    }

    private final void deregisterLeakCanaryListeners() {
        TransportEventPoller transportEventPoller = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener = this.statusListener;
        if (transportEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusListener");
            transportEventListener = null;
        }
        transportEventPoller.unregisterListener(transportEventListener);
        TransportEventPoller transportEventPoller2 = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener2 = this.hostAnalysisTriggerListener;
        if (transportEventListener2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostAnalysisTriggerListener");
            transportEventListener2 = null;
        }
        transportEventPoller2.unregisterListener(transportEventListener2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void addLeaks(@NotNull List<Leak> newLeaks) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(newLeaks, (String)"newLeaks");
        Iterable $this$filter$iv = newLeaks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Leak it = (Leak)element$iv$iv;
            boolean bl = false;
            if (!(!((List)this._leaks.getValue()).contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List uniqueNewLeaks = (List)destination$iv$iv;
        if (!((Collection)uniqueNewLeaks).isEmpty()) {
            this._leaks.setValue((Object)CollectionsKt.plus((Collection)((Collection)this._leaks.getValue()), (Iterable)uniqueNewLeaks));
        }
    }

    private final void leakDetected(Common.Event event) {
        String string = event.getLeakcanaryAnalysis().getData();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getData(...)");
        Analysis analysis = Analysis.Companion.fromString(string);
        if (analysis == null) {
            return;
        }
        Analysis analysis2 = analysis;
        if (this.handleRetainedObject(analysis2)) {
            return;
        }
        if (this.handleAnalysisProgress(analysis2)) {
            return;
        }
        this.handleLeakAnalysis(analysis2);
    }

    private final boolean handleRetainedObject(Analysis analysis) {
        boolean bl;
        if (!(analysis instanceof AnalysisUpdate)) {
            return false;
        }
        Regex retainedObjectsRegex = new Regex("Found (\\d+) objects retained");
        MatchResult matchResult = Regex.find$default((Regex)retainedObjectsRegex, (CharSequence)((AnalysisUpdate)analysis).getMessage(), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl2 = false;
            Object object = (String)CollectionsKt.getOrNull((List)matchResult2.getGroupValues(), (int)1);
            if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                int count = ((Number)object).intValue();
                boolean bl3 = false;
                this.setObjectRetainedCount(count);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean handleAnalysisProgress(Analysis analysis) {
        boolean bl;
        if (!(analysis instanceof AnalysisUpdate)) {
            return false;
        }
        Regex analysisProgressRegex = new Regex("Analysis in progress, (\\d+)% done");
        MatchResult matchResult = Regex.find$default((Regex)analysisProgressRegex, (CharSequence)((AnalysisUpdate)analysis).getMessage(), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl2 = false;
            Object object = (String)CollectionsKt.getOrNull((List)matchResult2.getGroupValues(), (int)1);
            if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                int progress = ((Number)object).intValue();
                boolean bl3 = false;
                this.setAnalysisProgress(progress);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void handleLeakAnalysis(Analysis analysis) {
        if (analysis == null) {
            return;
        }
        this.setObjectRetainedCount(0);
        this.setAnalysisProgress(0);
        if (analysis instanceof AnalysisSuccess) {
            this.addLeaks(((AnalysisSuccess)analysis).getLeaks());
        } else if (analysis instanceof AnalysisFailure) {
            this.logger.warn("Leak analysis failure", ((AnalysisFailure)analysis).getException());
        }
        if (this._selectedLeak.getValue() == null && !((Collection)this._leaks.getValue()).isEmpty()) {
            this.onLeakSelection((Leak)CollectionsKt.first((List)((List)this._leaks.getValue())));
        }
    }

    private final void toggleLeakCanaryLogcatTracking(Common.Session session, boolean enable, boolean endSession) {
        Commands.Command.Builder builder;
        Commands.Command.Builder $this$toggleLeakCanaryLogcatTracking_u24lambda_u240 = builder = Commands.Command.newBuilder();
        boolean bl = false;
        $this$toggleLeakCanaryLogcatTracking_u24lambda_u240.setStreamId(session.getStreamId());
        $this$toggleLeakCanaryLogcatTracking_u24lambda_u240.setPid(session.getPid());
        if (enable) {
            $this$toggleLeakCanaryLogcatTracking_u24lambda_u240.setType(Commands.Command.CommandType.START_LOGCAT_TRACKING);
        } else {
            $this$toggleLeakCanaryLogcatTracking_u24lambda_u240.setType(Commands.Command.CommandType.STOP_LOGCAT_TRACKING);
            if (endSession) {
                $this$toggleLeakCanaryLogcatTracking_u24lambda_u240.setSessionId(session.getSessionId());
            }
        }
        Commands.Command.Builder cmd = builder;
        this.profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(cmd).build());
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.UNKNOWN_STAGE;
    }

    public final void loadFromPastSession(long startTimestamp, long endTimeStamp, @NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List<Analysis> analysisEvents = this.getAllLeakCanaryEvents(session, startTimestamp, endTimeStamp);
        Iterable $this$forEach$iv = analysisEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Analysis analysis = (Analysis)element$iv;
            boolean bl = false;
            if (!(analysis instanceof AnalysisSuccess)) continue;
            this.addLeaks(((AnalysisSuccess)analysis).getLeaks());
        }
        if (!((Collection)this._leaks.getValue()).isEmpty()) {
            this.onLeakSelection((Leak)CollectionsKt.first((List)((List)this._leaks.getValue())));
        }
        TaskEventTrackerUtils.trackTaskFinished(this.profilers, false, TaskFinishedState.COMPLETED);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Analysis> getAllLeakCanaryEvents(Common.Session session, long startTimestamp, long endTimeStamp) {
        void $this$mapNotNullTo$iv$iv;
        ProfilerClient profilerClient = this.profilers.getClient();
        Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"getClient(...)");
        List<Common.Event> eventList = Companion.getLeaksFromRange(profilerClient, session, new Range((double)startTimestamp, (double)endTimeStamp));
        Iterable $this$mapNotNull$iv = eventList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Analysis it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Common.Event event = (Common.Event)element$iv$iv;
            boolean bl2 = false;
            String string = event.getLeakcanaryAnalysis().getData();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getData(...)");
            if (Analysis.Companion.fromString(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void goToDeclaration(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Function0 codeLocationSupplier = () -> LeakCanaryModel.goToDeclaration$lambda$0(node);
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        NavigateToCodeAction action = new NavigateToCodeAction(() -> LeakCanaryModel.goToDeclaration$lambda$1(codeLocationSupplier), navigator);
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)((AnAction)action), (DataContext)DataContext.EMPTY_CONTEXT, null, (String)"CodeInspection", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
    }

    @NotNull
    public final CompletableFuture<Boolean> isDeclarationAvailableAsync(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CodeLocation codeLocation = new CodeLocation.Builder(StringsKt.removeSuffix((String)node.getClassName(), (CharSequence)"[]")).build();
        Intrinsics.checkNotNullExpressionValue((Object)codeLocation, (String)"build(...)");
        CodeLocation codeLocationSupplier = codeLocation;
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        return navigator.isNavigatableAsync(codeLocationSupplier);
    }

    public void update(long elapsedNs) {
        MutableStateFlow<Long> mutableStateFlow = this._elapsedNs;
        mutableStateFlow.setValue((Object)(((Number)mutableStateFlow.getValue()).longValue() + elapsedNs));
    }

    private static final Unit heapDumper$lambda$0$0(LeakCanaryModel this$0, Analysis analysis) {
        Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
        this$0.handleLeakAnalysis(analysis);
        return Unit.INSTANCE;
    }

    private static final long registerLeakCanaryListeners$lambda$0(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int registerLeakCanaryListeners$lambda$1(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final long registerLeakCanaryListeners$lambda$2(long $startTime) {
        return $startTime;
    }

    private static final boolean registerLeakCanaryListeners$lambda$3(LeakCanaryModel this$0, Common.Event event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean it = bl = false;
        boolean bl2 = false;
        this$0.leakDetected(event);
        return bl;
    }

    private static final long registerLeakCanaryListeners$lambda$4(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int registerLeakCanaryListeners$lambda$5(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final long registerLeakCanaryListeners$lambda$6(long $startTime) {
        return $startTime;
    }

    private static final boolean registerLeakCanaryListeners$lambda$7(LeakCanaryModel this$0, Common.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"<unused var>");
        this$0.heapDumper.triggerAndAnalyze();
        return false;
    }

    private static final void checkLeakCanaryPresence$lambda$1(LeakCanaryModel this$0, Commands.Command $command) {
        Transport.ExecuteResponse response = this$0.profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand($command).build());
        TransportEventListener listener = new TransportEventListener(Common.Event.Kind.LEAKCANARY_PRESENCE_CHECK, this$0.profilers.getIdeServices().getPoolExecutor(), arg_0 -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1$0(response, arg_0), () -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1$1(this$0), () -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1$2(this$0), null, null, null, arg_0 -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1$3(this$0, arg_0), 224, null);
        this$0.profilers.getTransportPoller().registerListener(listener);
    }

    private static final boolean checkLeakCanaryPresence$lambda$1$0(Transport.ExecuteResponse $response, Common.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCommandId() == $response.getCommandId();
    }

    private static final long checkLeakCanaryPresence$lambda$1$1(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int checkLeakCanaryPresence$lambda$1$2(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final boolean checkLeakCanaryPresence$lambda$1$3(LeakCanaryModel this$0, Common.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean isPresent = event.getLeakcanaryPresenceCheck().getIsPresent();
        this$0.logger.info("LeakCanary presence check returned: " + isPresent);
        this$0.profilers.getIdeServices().getMainExecutor().execute(() -> LeakCanaryModel.checkLeakCanaryPresence$lambda$1$3$0(this$0, isPresent));
        return true;
    }

    private static final void checkLeakCanaryPresence$lambda$1$3$0(LeakCanaryModel this$0, boolean $isPresent) {
        this$0._isLeakCanaryPresent.setValue((Object)$isPresent);
    }

    private static final CodeLocation goToDeclaration$lambda$0(Node $node) {
        return new CodeLocation.Builder(StringsKt.removeSuffix((String)$node.getClassName(), (CharSequence)"[]")).build();
    }

    private static final CodeLocation goToDeclaration$lambda$1(Function0 $tmp0) {
        return (CodeLocation)$tmp0.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion;", "", "<init>", "()V", "getLeaksFromRange", "", "Lcom/android/tools/profiler/proto/Common$Event;", "profilerClient", "Lcom/android/tools/profilers/ProfilerClient;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "range", "Lcom/android/tools/adtui/model/Range;", "getLeakCanaryAnalysisInfo", "getLeakClassName", "", "leak", "Lcom/android/tools/leakcanarylib/data/Leak;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nLeakCanaryModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n1374#2:400\n1460#2,5:401\n1374#2:406\n1460#2,5:407\n774#2:412\n865#2,2:413\n785#2:415\n796#2:416\n1878#2,2:417\n797#2,2:419\n1880#2:421\n799#2:422\n*S KotlinDebug\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion\n*L\n347#1:400\n347#1:401,5\n365#1:406\n365#1:407,5\n366#1:412\n366#1:413,2\n381#1:415\n381#1:416\n381#1:417,2\n381#1:419,2\n381#1:421\n381#1:422\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Common.Event> getLeaksFromRange(@NotNull ProfilerClient profilerClient, @NotNull Common.Session session, @NotNull Range range) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)profilerClient, (String)"profilerClient");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List list = profilerClient.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.LEAKCANARY_ANALYSIS).setFromTimestamp((long)range.getMin()).setToTimestamp((long)range.getMax()).build()).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Transport.EventGroup group = (Transport.EventGroup)element$iv$iv;
                boolean bl = false;
                List list2 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEventsList(...)");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)list2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Common.Event> getLeakCanaryAnalysisInfo(@NotNull ProfilerClient profilerClient, @NotNull Common.Session session, @NotNull Range range) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)profilerClient, (String)"profilerClient");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List list = profilerClient.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.LEAKCANARY_ANALYSIS_STATUS).setFromTimestamp((long)range.getMin()).setToTimestamp((long)range.getMax()).build()).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Transport.EventGroup group = (Transport.EventGroup)element$iv$iv;
                boolean bl = false;
                List list2 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEventsList(...)");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)list2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Common.Event event = (Common.Event)element$iv$iv;
                boolean bl = false;
                if (!event.getIsEnded()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String getLeakClassName(@Nullable Leak leak) {
            Object object;
            block14: {
                LeakTrace leakTrace;
                block13: {
                    Object object2;
                    void $this$filterIndexedTo$iv$iv;
                    Leak leak2 = leak;
                    if ((leak2 != null ? leak2.getDisplayedLeakTrace() : null) == null || leak.getDisplayedLeakTrace().isEmpty()) {
                        return "";
                    }
                    leakTrace = (LeakTrace)CollectionsKt.first((List)leak.getDisplayedLeakTrace());
                    Iterable $this$filterIndexed$iv = leakTrace.getNodes();
                    boolean $i$f$filterIndexed = false;
                    Iterable iterable = $this$filterIndexed$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIndexedTo = false;
                    void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv$iv$iv = 0;
                    for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                        boolean bl;
                        void node;
                        void element$iv$iv;
                        int n;
                        if ((n = index$iv$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Object t = item$iv$iv$iv;
                        int index$iv$iv = n;
                        boolean bl2 = false;
                        Node node2 = (Node)element$iv$iv;
                        int index = index$iv$iv;
                        boolean bl3 = false;
                        switch (WhenMappings.$EnumSwitchMapping$0[node.getLeakingStatus().ordinal()]) {
                            case 1: {
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (index == CollectionsKt.getLastIndex((List)leakTrace.getNodes()) || ((Node)leakTrace.getNodes().get(index + 1)).getLeakingStatus() != LeakingStatus.NO) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List suspectNodeList = (List)destination$iv$iv;
                    object = (Node)CollectionsKt.firstOrNull((List)suspectNodeList);
                    if (object == null) break block13;
                    Node node = object;
                    boolean bl = false;
                    ReferencingField referenceField = node.getReferencingField();
                    Object object3 = referenceField;
                    if (object3 == null || (object3 = object3.getClassName()) == null) {
                        object3 = "";
                    }
                    if ((object2 = referenceField) == null || (object2 = object2.getReferenceName()) == null) {
                        object2 = "";
                    }
                    String string = (String)object3 + "." + (String)object2;
                    object = string;
                    if (string != null) break block14;
                }
                object = ((Node)CollectionsKt.last((List)leakTrace.getNodes())).getClassName();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LeakingStatus.values().length];
                try {
                    nArray[LeakingStatus.UNKNOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LeakingStatus.NO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

