/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.idea.flags.enums.PowerProfilerDisplayMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002\u001e\u001fB;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip;", "Lcom/android/tools/adtui/model/TooltipModel;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip$Aspect;", "timeline", "Lcom/android/tools/adtui/model/Timeline;", "counterName", "", "primaryPowerRailValues", "Lcom/android/tools/adtui/model/RangedSeries;", "", "secondaryPowerRailValues", "displayMode", "Lcom/android/tools/idea/flags/enums/PowerProfilerDisplayMode;", "<init>", "(Lcom/android/tools/adtui/model/Timeline;Ljava/lang/String;Lcom/android/tools/adtui/model/RangedSeries;Lcom/android/tools/adtui/model/RangedSeries;Lcom/android/tools/idea/flags/enums/PowerProfilerDisplayMode;)V", "getTimeline", "()Lcom/android/tools/adtui/model/Timeline;", "getCounterName", "()Ljava/lang/String;", "getDisplayMode", "()Lcom/android/tools/idea/flags/enums/PowerProfilerDisplayMode;", "value", "Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip$PowerCounterActiveValuesUws;", "activeValueUws", "getActiveValueUws", "()Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip$PowerCounterActiveValuesUws;", "dispose", "", "updateValue", "Aspect", "PowerCounterActiveValuesUws", "intellij.android.profilers"})
public final class PowerRailTooltip
extends AspectModel<Aspect>
implements TooltipModel {
    @NotNull
    private final Timeline timeline;
    @NotNull
    private final String counterName;
    @NotNull
    private final RangedSeries<Long> primaryPowerRailValues;
    @NotNull
    private final RangedSeries<Long> secondaryPowerRailValues;
    @NotNull
    private final PowerProfilerDisplayMode displayMode;
    @NotNull
    private PowerCounterActiveValuesUws activeValueUws;

    public PowerRailTooltip(@NotNull Timeline timeline, @NotNull String counterName, @NotNull RangedSeries<Long> primaryPowerRailValues, @NotNull RangedSeries<Long> secondaryPowerRailValues, @NotNull PowerProfilerDisplayMode displayMode) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Intrinsics.checkNotNullParameter((Object)counterName, (String)"counterName");
        Intrinsics.checkNotNullParameter(primaryPowerRailValues, (String)"primaryPowerRailValues");
        Intrinsics.checkNotNullParameter(secondaryPowerRailValues, (String)"secondaryPowerRailValues");
        Intrinsics.checkNotNullParameter((Object)displayMode, (String)"displayMode");
        this.timeline = timeline;
        this.counterName = counterName;
        this.primaryPowerRailValues = primaryPowerRailValues;
        this.secondaryPowerRailValues = secondaryPowerRailValues;
        this.displayMode = displayMode;
        this.activeValueUws = new PowerCounterActiveValuesUws(0L, 0L);
        this.timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> PowerRailTooltip._init_$lambda$0(this));
    }

    @NotNull
    public final Timeline getTimeline() {
        return this.timeline;
    }

    @NotNull
    public final String getCounterName() {
        return this.counterName;
    }

    @NotNull
    public final PowerProfilerDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @NotNull
    public final PowerCounterActiveValuesUws getActiveValueUws() {
        return this.activeValueUws;
    }

    public void dispose() {
        this.timeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private final void updateValue() {
        long newSecondaryValueUws;
        Range range = this.timeline.getTooltipRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getTooltipRange(...)");
        List primarySeries = this.primaryPowerRailValues.getSeriesForRange(range);
        Range range2 = this.timeline.getTooltipRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getTooltipRange(...)");
        List secondarySeries = this.secondaryPowerRailValues.getSeriesForRange(range2);
        long newPrimaryValueUws = primarySeries.isEmpty() ? 0L : ((Number)((SeriesData)primarySeries.get((int)0)).value).longValue();
        long l = newSecondaryValueUws = secondarySeries.isEmpty() ? 0L : ((Number)((SeriesData)secondarySeries.get((int)0)).value).longValue();
        if (newPrimaryValueUws != this.activeValueUws.getPrimaryValue() || newSecondaryValueUws != this.activeValueUws.getSecondaryValue()) {
            this.activeValueUws = new PowerCounterActiveValuesUws(newPrimaryValueUws, newSecondaryValueUws);
            this.changed(Aspect.VALUE_CHANGED);
        }
    }

    private static final void _init_$lambda$0(PowerRailTooltip this$0) {
        this$0.updateValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip$Aspect;", "", "<init>", "(Ljava/lang/String;I)V", "VALUE_CHANGED", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect VALUE_CHANGED = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        @NotNull
        public static EnumEntries<Aspect> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.VALUE_CHANGED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/PowerRailTooltip$PowerCounterActiveValuesUws;", "", "primaryValue", "", "secondaryValue", "<init>", "(JJ)V", "getPrimaryValue", "()J", "getSecondaryValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.profilers"})
    public static final class PowerCounterActiveValuesUws {
        private final long primaryValue;
        private final long secondaryValue;

        public PowerCounterActiveValuesUws(long primaryValue, long secondaryValue) {
            this.primaryValue = primaryValue;
            this.secondaryValue = secondaryValue;
        }

        public final long getPrimaryValue() {
            return this.primaryValue;
        }

        public final long getSecondaryValue() {
            return this.secondaryValue;
        }

        public final long component1() {
            return this.primaryValue;
        }

        public final long component2() {
            return this.secondaryValue;
        }

        @NotNull
        public final PowerCounterActiveValuesUws copy(long primaryValue, long secondaryValue) {
            return new PowerCounterActiveValuesUws(primaryValue, secondaryValue);
        }

        public static /* synthetic */ PowerCounterActiveValuesUws copy$default(PowerCounterActiveValuesUws powerCounterActiveValuesUws, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = powerCounterActiveValuesUws.primaryValue;
            }
            if ((n & 2) != 0) {
                l2 = powerCounterActiveValuesUws.secondaryValue;
            }
            return powerCounterActiveValuesUws.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "PowerCounterActiveValuesUws(primaryValue=" + this.primaryValue + ", secondaryValue=" + this.secondaryValue + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.primaryValue);
            result = result * 31 + Long.hashCode(this.secondaryValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PowerCounterActiveValuesUws)) {
                return false;
            }
            PowerCounterActiveValuesUws powerCounterActiveValuesUws = (PowerCounterActiveValuesUws)other;
            if (this.primaryValue != powerCounterActiveValuesUws.primaryValue) {
                return false;
            }
            return this.secondaryValue == powerCounterActiveValuesUws.secondaryValue;
        }
    }
}

