/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.DragAndDropList;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuListScrollPane;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.ThreadCellRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

final class CpuThreadsView {
    @NotNull
    private final HideablePanel myPanel;
    @NotNull
    private final DragAndDropList<CpuThreadsModel.RangedCpuThread> myThreads;
    @NotNull
    private final AspectObserver myObserver;
    private int myLastHoveredRow = -1;
    @NotNull
    private final CpuThreadsModel myThreadStates;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    @NotNull
    private final StudioProfilers myStudioProfilers;
    @NotNull
    private final AxisComponentModel myTimeAxisGuide;
    @NotNull
    private final Supplier<Integer> myGetSelectedThread;
    @NotNull
    private final Consumer<Integer> mySetSelectedThread;
    @NotNull
    private final AspectModel<CpuProfilerAspect> myAspect;
    private final Stage myStage;

    public CpuThreadsView(CpuThreadsModel threadStates, UpdatableManager updatableManager, StudioProfilers studioProfilers, AxisComponentModel timeAxisGuide, Supplier<Integer> getSelectedThread, Consumer<Integer> setSelectedThread, AspectModel<CpuProfilerAspect> aspect, Stage stage) {
        this.myThreadStates = threadStates;
        this.myUpdatableManager = updatableManager;
        this.myStudioProfilers = studioProfilers;
        this.myTimeAxisGuide = timeAxisGuide;
        this.myGetSelectedThread = getSelectedThread;
        this.mySetSelectedThread = setSelectedThread;
        this.myAspect = aspect;
        this.myStage = stage;
        this.myThreads = new DragAndDropList((DragAndDropListModel)this.myThreadStates);
        this.myPanel = this.createHideablePanel();
        this.setupListeners();
        this.myThreads.setBorder(null);
        this.myThreads.setCellRenderer((ListCellRenderer)new ThreadCellRenderer((JList<CpuThreadsModel.RangedCpuThread>)this.myThreads, this.myUpdatableManager));
        this.myThreads.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myThreads.getSelectionModel().setSelectionMode(0);
        DelegateMouseEventHandler.delegateTo((Component)this.myPanel).installListenerOn(this.myThreads).installMotionListenerOn(this.myThreads);
        this.myPanel.addStateChangedListener(actionEvent -> this.myStudioProfilers.getIdeServices().getFeatureTracker().trackToggleCpuThreadsHideablePanel());
        this.myObserver = new AspectObserver();
        this.myAspect.addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.SELECTED_THREADS, this::updateThreadSelection);
    }

    @VisibleForTesting
    public CpuThreadsView(@NotNull CpuProfilerStage stage) {
        this(stage.getThreadStates(), stage.getUpdatableManager(), stage.getStudioProfilers(), stage.getTimeAxisGuide(), stage::getSelectedThread, stage::setSelectedThread, stage.getAspect(), stage);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private HideablePanel createHideablePanel() {
        final AxisComponent axisComponent = new AxisComponent(this.myTimeAxisGuide, AxisComponent.AxisOrientation.BOTTOM, true);
        axisComponent.setShowAxisLine(false);
        axisComponent.setShowLabels(false);
        axisComponent.setHideTickAtMin(true);
        axisComponent.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        JPanel threads = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        final HideablePanel threadsPanel = new HideablePanel.Builder("THREADS", (JComponent)threads).setShowSeparator(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).setIconTextGap(6).setTitleLeftPadding(7).build();
        final CpuListScrollPane scrollingThreads = new CpuListScrollPane((JList)this.myThreads, (JComponent)threadsPanel);
        scrollingThreads.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentResized(ComponentEvent e) {
                axisComponent.setMarkerLengths(scrollingThreads.getHeight(), 0);
            }
        });
        threads.add((Component)axisComponent, new TabularLayout.Constraint(0, 0));
        threads.add((Component)((Object)scrollingThreads), new TabularLayout.Constraint(0, 0));
        threadsPanel.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_AXIS_GUIDE_COLOR, (int)2, (int)0, (int)0, (int)0));
        threadsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myThreads.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                threadsPanel.setTitle(String.format("THREADS (%d)", CpuThreadsView.this.myThreads.getModel().getSize()));
            }
        });
        threads.setBorder((Border)JBUI.Borders.empty());
        return threadsPanel;
    }

    private void setupListeners() {
        CpuThreadsModel model = this.myThreadStates;
        this.myThreads.addListSelectionListener(e -> {
            int selectedIndex = this.myThreads.getSelectedIndex();
            if (selectedIndex >= 0) {
                CpuThreadsModel.RangedCpuThread thread = (CpuThreadsModel.RangedCpuThread)model.getElementAt(selectedIndex);
                if (this.myGetSelectedThread.get().intValue() != thread.getThreadId()) {
                    this.mySetSelectedThread.accept(thread.getThreadId());
                    this.myStudioProfilers.getIdeServices().getFeatureTracker().trackSelectThread();
                }
            } else {
                this.mySetSelectedThread.accept(-1);
            }
        });
        this.myThreads.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CpuThreadsView.this.myThreads.getSelectedIndex() < 0 && CpuThreadsView.this.myThreads.getModel().getSize() > 0) {
                    CpuThreadsView.this.myThreads.setSelectedIndex(0);
                }
            }
        });
        ProfilerTooltipMouseAdapter adapter = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuThreadsTooltip((Timeline)this.myStudioProfilers.getTimeline())){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                this.handleMoved(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                CpuThreadsView.this.myLastHoveredRow = -1;
                this.handleMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.repaintLastHoveredRow();
                CpuThreadsView.this.myLastHoveredRow = -1;
                super.mouseExited(e);
            }

            private void handleMoved(MouseEvent e) {
                this.repaintLastHoveredRow();
                CpuThreadsView.this.myLastHoveredRow = CpuThreadsView.this.myThreads.locationToIndex(e.getPoint());
                if (CpuThreadsView.this.myLastHoveredRow != -1) {
                    this.repaintLastHoveredRow();
                    CpuThreadsModel.RangedCpuThread model = (CpuThreadsModel.RangedCpuThread)CpuThreadsView.this.myThreads.getModel().getElementAt(CpuThreadsView.this.myLastHoveredRow);
                    if (CpuThreadsView.this.myStage.getTooltip() instanceof CpuThreadsTooltip) {
                        CpuThreadsTooltip tooltip = (CpuThreadsTooltip)CpuThreadsView.this.myStage.getTooltip();
                        tooltip.setThread(model.getName(), model.getStateSeries());
                    }
                }
            }

            private void repaintLastHoveredRow() {
                Rectangle cellBounds = CpuThreadsView.this.myThreads.getCellBounds(CpuThreadsView.this.myLastHoveredRow, CpuThreadsView.this.myLastHoveredRow);
                if (cellBounds != null) {
                    CpuThreadsView.this.myPanel.repaint(SwingUtilities.convertRectangle(CpuThreadsView.this.myThreads, cellBounds, (Component)CpuThreadsView.this.myPanel));
                }
            }
        };
        this.myThreads.addMouseListener((MouseListener)adapter);
        this.myThreads.addMouseMotionListener((MouseMotionListener)adapter);
    }

    private void updateThreadSelection() {
        if (this.myGetSelectedThread.get() == -1) {
            this.myThreads.clearSelection();
            return;
        }
        for (int i = 0; i < this.myThreads.getModel().getSize(); ++i) {
            CpuThreadsModel.RangedCpuThread thread = (CpuThreadsModel.RangedCpuThread)this.myThreads.getModel().getElementAt(i);
            if (this.myGetSelectedThread.get().intValue() != thread.getThreadId()) continue;
            this.myThreads.setSelectedIndex(i);
            break;
        }
    }
}

