/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceProducer;
import com.android.tools.profilers.cpu.systemtrace.PerfettoProducer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParserUtil {
    private static final Set<ProfilingConfiguration.TraceType> AVAILABLE_TRACE_TYPES = ImmutableSet.of((Object)((Object)ProfilingConfiguration.TraceType.ART), (Object)((Object)ProfilingConfiguration.TraceType.SIMPLEPERF), (Object)((Object)ProfilingConfiguration.TraceType.ATRACE), (Object)((Object)ProfilingConfiguration.TraceType.PERFETTO));
    private static final Predicate<File> ART_TESTER = ArtTraceParser::verifyFileHasArtHeader;
    private static final Predicate<File> SIMPLE_PREF_TESTER = SimpleperfTraceParser::verifyFileHasSimpleperfHeader;
    private static final Predicate<File> ATRACE_FILE_TESTER = AtraceProducer::verifyFileHasAtraceHeader;
    private static final Predicate<File> PERFETTO_FILE_TESTER = PerfettoProducer::verifyFileHasPerfettoTraceHeader;

    @Nullable
    public static ProfilingConfiguration.TraceType getFileTraceType(@NotNull File traceFile, @NotNull ProfilingConfiguration.TraceType profilerType) {
        boolean isKnownType = !ProfilingConfiguration.TraceType.UNSPECIFIED.equals((Object)profilerType);
        Set<ProfilingConfiguration.TraceType> traceTypesToTry = CpuCaptureParserUtil.getTraceTypesToTryToParseWith(profilerType, isKnownType);
        for (ProfilingConfiguration.TraceType traceType : traceTypesToTry) {
            Optional<Boolean> inputVerification = CpuCaptureParserUtil.getInputVerification(traceType, traceFile, isKnownType);
            if (!inputVerification.isPresent() || !inputVerification.get().booleanValue()) continue;
            return traceType;
        }
        return null;
    }

    private static Set<ProfilingConfiguration.TraceType> getTraceTypesToTryToParseWith(@NotNull ProfilingConfiguration.TraceType profilerType, boolean isKnownType) {
        if (isKnownType) {
            return ImmutableSet.of((Object)((Object)profilerType));
        }
        return AVAILABLE_TRACE_TYPES;
    }

    private static Optional<Boolean> getInputVerification(@NotNull ProfilingConfiguration.TraceType type, @NotNull File traceFile, boolean expectedToBeCorrectParser) {
        Optional<Predicate<File>> traceInputVerification = CpuCaptureParserUtil.getTraceInputVerification(type);
        if (traceInputVerification.isEmpty()) {
            return Optional.empty();
        }
        try {
            boolean inputVerificationStatus = traceInputVerification.get().test(traceFile);
            if (expectedToBeCorrectParser && !inputVerificationStatus) {
                throw new CpuCaptureParser.FileHeaderParsingFailureException(traceFile.getAbsolutePath(), type);
            }
            return Optional.of(inputVerificationStatus);
        }
        catch (Throwable t) {
            if (expectedToBeCorrectParser) {
                throw new CpuCaptureParser.FileHeaderParsingFailureException(traceFile.getAbsolutePath(), type, t);
            }
            return Optional.empty();
        }
    }

    @VisibleForTesting
    private static Optional<Predicate<File>> getTraceInputVerification(@NotNull ProfilingConfiguration.TraceType type) {
        return switch (type) {
            case ProfilingConfiguration.TraceType.ART -> Optional.of(ART_TESTER);
            case ProfilingConfiguration.TraceType.SIMPLEPERF -> Optional.of(SIMPLE_PREF_TESTER);
            case ProfilingConfiguration.TraceType.ATRACE -> Optional.of(ATRACE_FILE_TESTER);
            case ProfilingConfiguration.TraceType.PERFETTO -> Optional.of(PERFETTO_FILE_TESTER);
            default -> Optional.empty();
        };
    }
}

