/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.InterimStageView;
import com.android.tools.profilers.LiveStage;
import com.android.tools.profilers.LiveStageView;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StageWithToolbarView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuCaptureStageView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.leakcanary.LeakCanaryModel;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.AllocationStageView;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryCaptureStage;
import com.android.tools.profilers.memory.MemoryCaptureStageView;
import com.android.tools.profilers.taskbased.tabs.task.leakcanary.LeakCanaryTaskView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010#\u001a\u00020$H\u0016JR\u0010%\u001a\u00020$\"\u000e\b\u0000\u0010&*\b\u0012\u0002\b\u0003\u0018\u00010\"\"\u000e\b\u0001\u0010'*\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u001a\u0010*\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u0002H'0+H\u0007J\u0018\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u001c\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/profilers/TaskProfilersView;", "Lcom/android/tools/profilers/StudioProfilersView;", "studioProfilers", "Lcom/android/tools/profilers/StudioProfilers;", "ideProfilerComponents", "Lcom/android/tools/profilers/IdeProfilerComponents;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/IdeProfilerComponents;Lcom/intellij/openapi/Disposable;)V", "getStudioProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getIdeProfilerComponents", "()Lcom/android/tools/profilers/IdeProfilerComponents;", "stageComponent", "Ljavax/swing/JPanel;", "getStageComponent", "()Ljavax/swing/JPanel;", "layeredPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "stageWithToolbarView", "Lcom/android/tools/profilers/StageWithToolbarView;", "getStageWithToolbarView", "()Lcom/android/tools/profilers/StageWithToolbarView;", "stageView", "Lcom/android/tools/profilers/StageView;", "getStageView", "()Lcom/android/tools/profilers/StageView;", "binder", "Lcom/android/tools/adtui/model/ViewBinder;", "Lcom/android/tools/profilers/Stage;", "dispose", "", "bind", "S", "T", "clazz", "Ljava/lang/Class;", "constructor", "Ljava/util/function/BiFunction;", "buildStageView", "stage", "installCommonMenuItems", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class TaskProfilersView
implements StudioProfilersView {
    @NotNull
    private final StudioProfilers studioProfilers;
    @NotNull
    private final IdeProfilerComponents ideProfilerComponents;
    @NotNull
    private final JPanel stageComponent;
    @NotNull
    private final TooltipLayeredPane layeredPane;
    @NotNull
    private final StageWithToolbarView stageWithToolbarView;
    @NotNull
    private final ViewBinder<TaskProfilersView, Stage<?>, StageView<?>> binder;
    public static final int $stable = 8;

    public TaskProfilersView(@NotNull StudioProfilers studioProfilers, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)studioProfilers), (String)"studioProfilers");
        Intrinsics.checkNotNullParameter((Object)ideProfilerComponents, (String)"ideProfilerComponents");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.studioProfilers = studioProfilers;
        this.ideProfilerComponents = ideProfilerComponents;
        this.stageComponent = new JPanel(new BorderLayout());
        this.layeredPane = new TooltipLayeredPane((JComponent)this.getStageComponent());
        this.binder = new ViewBinder();
        this.binder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.binder.bind(CpuProfilerStage.class, InterimStageView::new);
        this.binder.bind(CpuCaptureStage.class, CpuCaptureStageView::new);
        this.binder.bind(MainMemoryProfilerStage.class, InterimStageView::new);
        this.binder.bind(MemoryCaptureStage.class, MemoryCaptureStageView::new);
        this.binder.bind(AllocationStage.class, AllocationStageView::new);
        this.binder.bind(LiveStage.class, LiveStageView::new);
        this.binder.bind(LeakCanaryModel.class, LeakCanaryTaskView::new);
        this.stageWithToolbarView = new StageWithToolbarView(this.getStudioProfilers(), this.getStageComponent(), this.getIdeProfilerComponents(), arg_0 -> TaskProfilersView._init_$lambda$0(this, arg_0), this.getStageComponent());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    @NotNull
    public StudioProfilers getStudioProfilers() {
        return this.studioProfilers;
    }

    @Override
    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        return this.ideProfilerComponents;
    }

    @Override
    @NotNull
    public JPanel getStageComponent() {
        return this.stageComponent;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.layeredPane;
    }

    @Override
    @NotNull
    public StageWithToolbarView getStageWithToolbarView() {
        return this.stageWithToolbarView;
    }

    @Override
    @Nullable
    public StageView<?> getStageView() {
        return this.getStageWithToolbarView().getStageView();
    }

    public void dispose() {
    }

    @VisibleForTesting
    public final <S extends Stage<?>, T extends StageView<?>> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<TaskProfilersView, S, T> constructor) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        this.binder.bind(clazz, constructor);
    }

    private final StageView<?> buildStageView(Stage<?> stage) {
        Object object = this.binder.build((Object)this, stage);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (StageView)((Object)object);
    }

    @Override
    public void installCommonMenuItems(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ContextMenuInstaller contextMenuInstaller = this.getIdeProfilerComponents().createContextMenuInstaller();
        Intrinsics.checkNotNullExpressionValue((Object)contextMenuInstaller, (String)"createContextMenuInstaller(...)");
        ContextMenuInstaller contextMenuInstaller2 = contextMenuInstaller;
        ProfilerContextMenu.createIfAbsent(this.getStageComponent()).getContextMenuItems().forEach(arg_0 -> TaskProfilersView.installCommonMenuItems$lambda$0(contextMenuInstaller2, component, arg_0));
    }

    private static final StageView _init_$lambda$0(TaskProfilersView this$0, Stage stage) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        return this$0.buildStageView(stage);
    }

    private static final void installCommonMenuItems$lambda$0(ContextMenuInstaller $contextMenuInstaller, JComponent $component, ContextMenuItem item) {
        ContextMenuItem contextMenuItem = item;
        Intrinsics.checkNotNull((Object)contextMenuItem);
        $contextMenuInstaller.installGenericContextMenu($component, contextMenuItem);
    }
}

