/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.flat.FlatComboBox;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class StageNavigationToolbar
extends JPanel {
    private final StudioProfilers profilers;
    private final CommonButton backButton;

    public StageNavigationToolbar(StudioProfilers profilers) {
        super(ProfilerLayout.createToolbarLayout());
        this.profilers = profilers;
        this.backButton = new CommonButton(AllIcons.Actions.Back);
        this.backButton.addActionListener(action -> this.confirmExit("Go back?", () -> {
            profilers.setStage(profilers.getStage().getParentStage());
            profilers.getSessionsManager().resetSelectedArtifactProto();
            profilers.getIdeServices().getFeatureTracker().trackGoBack();
        }));
        this.add((Component)this.backButton);
        this.add((Component)new FlatSeparator());
        FlatComboBox stageCombo = new FlatComboBox();
        Supplier getSupportedStages = () -> profilers.getDirectStages().stream().filter(st -> profilers.getSelectedSessionSupportLevel().isStageSupported((Class<? extends Stage<?>>)st)).collect(Collectors.toList());
        JComboBoxView<Class, ProfilerAspect> stages = new JComboBoxView<Class, ProfilerAspect>((JComboBox<Class>)stageCombo, profilers, ProfilerAspect.STAGE, getSupportedStages, profilers::getStageClass, stage -> this.confirmExit("Exit?", () -> {
            profilers.getIdeServices().getFeatureTracker().trackSelectMonitor();
            profilers.setNewStage((Class<? extends Stage>)stage);
        }), () -> profilers.getStage().getHomeStageClass());
        stageCombo.setRenderer(new StageComboBoxRenderer());
        stages.bind();
        this.add((Component)stageCombo);
        this.add((Component)new FlatSeparator());
    }

    @VisibleForTesting
    @NotNull
    CommonButton getBackButton() {
        return this.backButton;
    }

    private void confirmExit(String title, Runnable exit2) {
        String msg = this.profilers.getStage().getConfirmExitMessage();
        if (msg != null) {
            this.profilers.getIdeServices().openYesNoDialog(msg, title, exit2, () -> {});
        } else {
            exit2.run();
        }
    }

    public static class StageComboBoxRenderer
    extends ColoredListCellRenderer<Class> {
        private static ImmutableMap<Class<? extends Stage>, String> CLASS_TO_NAME = ImmutableMap.of(CpuProfilerStage.class, (Object)"CPU", MainMemoryProfilerStage.class, (Object)"MEMORY", CustomEventProfilerStage.class, (Object)"CUSTOM EVENTS");

        protected void customizeCellRenderer(@NotNull JList list, Class value, int index, boolean selected, boolean hasFocus) {
            String name = (String)CLASS_TO_NAME.get((Object)value);
            this.append(name == null ? "[UNKNOWN]" : name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

