/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.inprocess.InProcessChannelBuilder;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class ProfilerClient {
    @NotNull
    private final ManagedChannel myChannel;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myTransportClient;
    @NotNull
    private final EventServiceGrpc.EventServiceBlockingStub myEventClient;

    public ProfilerClient(@NotNull String name) {
        this(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)name).usePlaintext().directExecutor()).build());
    }

    @VisibleForTesting
    public ProfilerClient(@NotNull ManagedChannel channel) {
        this.myChannel = channel;
        this.myTransportClient = TransportServiceGrpc.newBlockingStub((Channel)channel);
        this.myEventClient = EventServiceGrpc.newBlockingStub((Channel)channel);
    }

    @NotNull
    public TransportServiceGrpc.TransportServiceBlockingStub getTransportClient() {
        return this.myTransportClient;
    }

    public CompletableFuture<Transport.ExecuteResponse> executeAsync(Commands.Command command, Executor executor) {
        return TransportClient.executeAsync((TransportServiceGrpc.TransportServiceBlockingStub)this.myTransportClient, (Commands.Command)command, (Executor)executor);
    }

    @NotNull
    public EventServiceGrpc.EventServiceBlockingStub getEventClient() {
        return this.myEventClient;
    }

    public void shutdownChannel() {
        if (!this.myChannel.isShutdown()) {
            this.myChannel.shutdown();
        }
    }
}

