/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.LeakCanary;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0007J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J9\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000b0\u001b\u00a2\u0006\u0002\b\u001dH\u0007J9\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000b0\u001b\u00a2\u0006\u0002\b\u001dH\u0007J8\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u001e\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0!H\u0002JL\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\"\b\u0002\u0010%\u001a\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130&\u0018\u00010\u0011H\u0007J\u0017\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J!\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b/J#\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u0001012\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b2J\u001e\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u0001012\u0006\u0010)\u001a\u00020*H\u0002J\u0015\u00104\u001a\u00020*2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u00109\u001a\u00020\u000b2\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010:\u001a\u00020\u000b2\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006;"}, d2={"Lcom/android/tools/profilers/ImportedSessionUtils;", "", "<init>", "()V", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyToTemp", "Ljava/io/File;", "file", "importFileWithArtifactEvent", "", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "sessionType", "Lcom/android/tools/profiler/proto/Common$SessionData$SessionStarted$SessionType;", "makeEvent", "Lkotlin/Function2;", "", "Lcom/android/tools/profiler/proto/Common$Event;", "importFile", "makeStartedEvent", "groupId", "timeStamp", "kind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "prepare", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Common$Event$Builder;", "Lkotlin/ExtensionFunctionType;", "makeEndedEvent", "withFileImportedOnce", "handle", "Lkotlin/Function3;", "importEventBasedArtifact", "metaDataSessionType", "Lcom/android/tools/profiler/proto/Common$SessionMetaData$SessionType;", "makeArtifactEvents", "", "getSessionInfoFromDb", "Lcom/android/tools/profiler/proto/Common$SessionData;", "connection", "Ljava/sql/Connection;", "getSessionInfoFromDb$intellij_android_profilers", "getDbMetadata", "", "", "getDbMetadata$intellij_android_profilers", "getTimestampRangeFromDbFile", "Lkotlin/Pair;", "getTimestampRangeFromDbFile$intellij_android_profilers", "getTimestampRangeFromDbConn", "getDbConnectionFromFile", "getDbConnectionFromFile$intellij_android_profilers", "importAsdbTask", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "importLeakCanaryTask", "importLiveTask", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nImportedSessionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportedSessionUtils.kt\ncom/android/tools/profilers/ImportedSessionUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,365:1\n37#2:366\n36#2,3:367\n*S KotlinDebug\n*F\n+ 1 ImportedSessionUtils.kt\ncom/android/tools/profilers/ImportedSessionUtils\n*L\n198#1:366\n198#1:367,3\n*E\n"})
public final class ImportedSessionUtils {
    @NotNull
    public static final ImportedSessionUtils INSTANCE = new ImportedSessionUtils();

    private ImportedSessionUtils() {
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private final File copyToTemp(File file) {
        File file2;
        try {
            File file3 = FileUtil.createTempFile((String)("profiler-import-" + FilesKt.getNameWithoutExtension((File)file)), (String)("." + FilesKt.getExtension((File)file)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempFile(...)");
            File tempFile = file3;
            FileUtil.copy((File)file, (File)tempFile);
        }
        catch (IOException e) {
            this.getLogger().warn("Failed to create a temporary copy of the imported file: " + file.getPath() + ". Using original file.", (Throwable)e);
            file2 = file;
        }
        return file2;
    }

    @JvmStatic
    public static final void importFileWithArtifactEvent(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType, @NotNull Function2<? super Long, ? super Long, Common.Event> makeEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        Intrinsics.checkNotNullParameter(makeEvent, (String)"makeEvent");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function3<? super Long, ? super Long, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ImportedSessionUtils.importFileWithArtifactEvent$lambda$0(file, sessionsManager, sessionType, makeEvent, arg_0, arg_1, arg_2)));
    }

    @JvmStatic
    public static final void importFile(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function3<? super Long, ? super Long, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ImportedSessionUtils.importFile$lambda$0(file, sessionsManager, sessionType, arg_0, arg_1, arg_2)));
    }

    @JvmStatic
    @NotNull
    public static final Common.Event makeStartedEvent(long groupId, long timeStamp, @NotNull Common.Event.Kind kind, @NotNull Function1<? super Common.Event.Builder, Unit> prepare) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(prepare, (String)"prepare");
        Common.Event.Builder builder = Common.Event.newBuilder().setKind(kind).setGroupId(groupId).setTimestamp(timeStamp);
        prepare.invoke((Object)builder);
        Common.Event event = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"build(...)");
        return event;
    }

    @JvmStatic
    @NotNull
    public static final Common.Event makeEndedEvent(long groupId, long timeStamp, @NotNull Common.Event.Kind kind, @NotNull Function1<? super Common.Event.Builder, Unit> prepare) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(prepare, (String)"prepare");
        Common.Event.Builder builder = Common.Event.newBuilder().setKind(kind).setGroupId(groupId).setTimestamp(timeStamp).setIsEnded(true);
        prepare.invoke((Object)builder);
        Common.Event event = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"build(...)");
        return event;
    }

    private final void withFileImportedOnce(SessionsManager sessionsManager, File file, Function3<? super Long, ? super Long, ? super Long, Unit> handle) {
        long startTimestampEpochNs = System.currentTimeMillis();
        com.intellij.openapi.util.Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        Long sessionStartTimeNs = (Long)timestampsNs.first;
        Long sessionEndTimeNs = (Long)timestampsNs.second;
        StudioProfilers studioProfilers = sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        StudioProfilers profilers = studioProfilers;
        if (sessionsManager.getSessionIdToSessionItems().containsKey(sessionStartTimeNs)) {
            if (profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                SessionItem sessionItem = sessionsManager.getSessionIdToSessionItems().get(sessionStartTimeNs);
                Intrinsics.checkNotNull((Object)sessionItem);
                SessionItem session = sessionItem;
                profilers.getPastRecordingsTabModel().getRecordingListModel().openRecording(session);
            } else {
                Intrinsics.checkNotNull((Object)sessionStartTimeNs);
                sessionsManager.setSessionById(sessionStartTimeNs);
            }
        } else {
            Long l = startTimestampEpochNs;
            Intrinsics.checkNotNull((Object)sessionStartTimeNs);
            Intrinsics.checkNotNull((Object)sessionEndTimeNs);
            handle.invoke((Object)l, (Object)sessionStartTimeNs, (Object)sessionEndTimeNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void importEventBasedArtifact(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType, @NotNull Common.SessionMetaData.SessionType metaDataSessionType, @Nullable Function2<? super Long, ? super Long, ? extends List<Common.Event>> makeArtifactEvents) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        Intrinsics.checkNotNullParameter((Object)metaDataSessionType, (String)"metaDataSessionType");
        Pair pair = INSTANCE.getTimestampRangeFromDbFile$intellij_android_profilers(file);
        if (pair == null) {
            pair = TuplesKt.to((Object)0L, (Object)0L);
        }
        Pair pair2 = pair;
        long sessionStartTimeNs = ((Number)pair2.component1()).longValue();
        long sessionEndTimeNs = ((Number)pair2.component2()).longValue();
        if (sessionStartTimeNs == 0L || sessionEndTimeNs == 0L) {
            INSTANCE.getLogger().warn("Could not determine timestamp range from " + file.getName() + ", aborting import.");
            return;
        }
        if (sessionsManager.getSessionIdToSessionItems().containsKey(sessionStartTimeNs)) {
            sessionsManager.setSessionById(sessionStartTimeNs);
            return;
        }
        long startTimestampEpochMs = System.currentTimeMillis();
        File file2 = FileUtil.createTempFile((String)("imported-" + FilesKt.getNameWithoutExtension((File)file)), (String)("." + FilesKt.getExtension((File)file)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File copiedFile = file2;
        try {
            long streamId = sessionsManager.createImportedSessionStream(startTimestampEpochMs);
            if (streamId == 0L) {
                return;
            }
            EventStreamServer eventStreamServer = sessionsManager.getEventStreamServer(streamId);
            if (eventStreamServer == null) {
                return;
            }
            EventStreamServer streamServer = eventStreamServer;
            FileUtil.copy((File)file, (File)copiedFile);
            AutoCloseable autoCloseable = INSTANCE.getDbConnectionFromFile$intellij_android_profilers(copiedFile);
            Throwable throwable = null;
            try {
                Object object;
                boolean jvmtiEnabled;
                Common.SessionData exposureLevel;
                block18: {
                    block17: {
                        Connection connection = (Connection)autoCloseable;
                        boolean bl = false;
                        Common.SessionData sessionData = INSTANCE.getSessionInfoFromDb$intellij_android_profilers(connection);
                        Common.SessionData sessionData2 = sessionData;
                        if (sessionData2 == null || (sessionData2 = sessionData2.getSessionStarted()) == null || (sessionData2 = sessionData2.getExposureLevel()) == null) {
                            sessionData2 = Common.Process.ExposureLevel.UNKNOWN;
                        }
                        exposureLevel = sessionData2;
                        Common.SessionData sessionData3 = sessionData;
                        jvmtiEnabled = sessionData3 != null && (sessionData3 = sessionData3.getSessionStarted()) != null ? sessionData3.getJvmtiEnabled() : false;
                        object = makeArtifactEvents;
                        if (makeArtifactEvents == null || (object = (List)object.invoke((Object)sessionStartTimeNs, (Object)sessionEndTimeNs)) == null) break block17;
                        Collection $this$toTypedArray$iv = (Collection)object;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        object = thisCollection$iv.toArray(new Common.Event[0]);
                        if (object != null) break block18;
                    }
                    object = new Common.Event[]{};
                }
                Common.Event[] events = object;
                sessionsManager.populateImportedSession(sessionStartTimeNs, sessionEndTimeNs, startTimestampEpochMs, streamId, streamServer, file.getName(), sessionType, MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf(sessionStartTimeNs), (Object)copiedFile.getAbsolutePath())), jvmtiEnabled, (Common.Process.ExposureLevel)exposureLevel, Arrays.copyOf(events, events.length));
                sessionsManager.getStudioProfilers().getIdeServices().getFeatureTracker().trackCreateSession(metaDataSessionType, SessionsManager.SessionCreationSource.MANUAL);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            INSTANCE.getLogger().error("Failed to import artifact from database: " + file.getPath(), (Throwable)e);
        }
    }

    public static /* synthetic */ void importEventBasedArtifact$default(SessionsManager sessionsManager, File file, Common.SessionData.SessionStarted.SessionType sessionType, Common.SessionMetaData.SessionType sessionType2, Function2 function2, int n, Object object) {
        if ((n & 0x10) != 0) {
            function2 = null;
        }
        ImportedSessionUtils.importEventBasedArtifact(sessionsManager, file, sessionType, sessionType2, (Function2<? super Long, ? super Long, ? extends List<Common.Event>>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Common.SessionData getSessionInfoFromDb$intellij_android_profilers(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.prepareStatement("SELECT Data FROM UnifiedEventsTable WHERE Kind = ? AND IsEnded = 0 LIMIT 1");
        Throwable throwable = null;
        try {
            PreparedStatement stmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            stmt.setInt(1, 101);
            AutoCloseable autoCloseable2 = stmt.executeQuery();
            Throwable throwable2 = null;
            try {
                byte[] data;
                Common.Event event;
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (rs.next() && (event = Common.Event.parseFrom((byte[])(data = rs.getBytes("Data")))).hasSession()) {
                    Common.SessionData sessionData = event.getSession();
                    Common.SessionData sessionData2 = sessionData;
                    return sessionData2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, String> getDbMetadata$intellij_android_profilers(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map metadata = new LinkedHashMap();
        try {
            AutoCloseable autoCloseable = this.getDbConnectionFromFile$intellij_android_profilers(file);
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement stmt = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable3 = stmt.executeQuery("SELECT key, value FROM _metadata");
                    Throwable throwable3 = null;
                    try {
                        ResultSet rs = (ResultSet)autoCloseable3;
                        boolean bl3 = false;
                        while (rs.next()) {
                            String key = rs.getString("key");
                            String value = rs.getString("value");
                            if (key == null || value == null) continue;
                            metadata.put(key, value);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to read metadata from database: " + file.getPath(), (Throwable)e);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<Long, Long> getTimestampRangeFromDbFile$intellij_android_profilers(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            AutoCloseable autoCloseable = this.getDbConnectionFromFile$intellij_android_profilers(file);
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                Pair<Long, Long> pair = INSTANCE.getTimestampRangeFromDbConn(connection);
                return pair;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to read timestamp range from database: " + file.getPath(), (Throwable)e);
            Pair<Long, Long> pair = null;
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Long, Long> getTimestampRangeFromDbConn(Connection connection) {
        Pair pair;
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Pair pair2;
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = stmt.executeQuery("SELECT MIN(timestamp), MAX(timestamp) FROM UnifiedEventsTable");
            Throwable throwable2 = null;
            try {
                Pair pair3;
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (rs.next() && rs.getLong(1) != 0L) {
                    pair3 = new Pair((Object)rs.getLong(1), (Object)rs.getLong(2));
                } else {
                    INSTANCE.getLogger().warn("Imported event database contains no events");
                    pair3 = null;
                }
                pair2 = pair3;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            pair = pair2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return pair;
    }

    @NotNull
    public final Connection getDbConnectionFromFile$intellij_android_profilers(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Properties properties = new Properties();
        properties.setProperty("open_mode", "1");
        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + file.getAbsolutePath(), properties);
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    @JvmStatic
    public static final void importAsdbTask(@NotNull StudioProfilers profilers, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, String> metadata = INSTANCE.getDbMetadata$intellij_android_profilers(file);
        String string = metadata.get("task_type");
        if (Intrinsics.areEqual((Object)string, (Object)Common.ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS.toString())) {
            MemoryProfiler.Companion.importAllocations(profilers, file);
        } else if (Intrinsics.areEqual((Object)string, (Object)Common.ProfilerTaskType.LIVE_VIEW.toString())) {
            INSTANCE.importLiveTask(profilers, file);
        } else if (Intrinsics.areEqual((Object)string, (Object)Common.ProfilerTaskType.LEAKCANARY.toString())) {
            INSTANCE.importLeakCanaryTask(profilers, file);
        } else {
            INSTANCE.getLogger().error("Imported .asdb file is not a recognized task type or is missing metadata: " + file.getPath());
        }
    }

    private final void importLeakCanaryTask(StudioProfilers profilers, File file) {
        SessionsManager sessionsManager = profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"getSessionsManager(...)");
        ImportedSessionUtils.importEventBasedArtifact(sessionsManager, file, Common.SessionData.SessionStarted.SessionType.FULL, Common.SessionMetaData.SessionType.FULL, (Function2<? super Long, ? super Long, ? extends List<Common.Event>>)((Function2)ImportedSessionUtils::importLeakCanaryTask$lambda$0));
    }

    private final void importLiveTask(StudioProfilers profilers, File file) {
        SessionsManager sessionsManager = profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"getSessionsManager(...)");
        ImportedSessionUtils.importEventBasedArtifact(sessionsManager, file, Common.SessionData.SessionStarted.SessionType.FULL, Common.SessionMetaData.SessionType.FULL, (Function2<? super Long, ? super Long, ? extends List<Common.Event>>)((Function2)ImportedSessionUtils::importLiveTask$lambda$0));
    }

    private static final Unit importFileWithArtifactEvent$lambda$0(File $file, SessionsManager $sessionsManager, Common.SessionData.SessionStarted.SessionType $sessionType, Function2 $makeEvent, long startTimestampsEpochMs, long startTime, long endTime) {
        File copiedFile = INSTANCE.copyToTemp($file);
        Common.Event[] eventArray = new Common.Event[]{$makeEvent.invoke((Object)startTime, (Object)endTime)};
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)copiedFile.getAbsolutePath())), eventArray);
        return Unit.INSTANCE;
    }

    private static final Unit importFile$lambda$0(File $file, SessionsManager $sessionsManager, Common.SessionData.SessionStarted.SessionType $sessionType, long startTimestampsEpochMs, long startTime, long endTime) {
        File copiedFile = INSTANCE.copyToTemp($file);
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)copiedFile.getAbsolutePath())), new Common.Event[0]);
        return Unit.INSTANCE;
    }

    private static final List importLeakCanaryTask$lambda$0(long start, long end) {
        Object[] objectArray = new Common.Event[]{ImportedSessionUtils.makeStartedEvent(start, start, Common.Event.Kind.LEAKCANARY_ANALYSIS_STATUS, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> ImportedSessionUtils.importLeakCanaryTask$lambda$0$0(start, arg_0))), ImportedSessionUtils.makeEndedEvent(start, end, Common.Event.Kind.LEAKCANARY_ANALYSIS_STATUS, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> ImportedSessionUtils.importLeakCanaryTask$lambda$0$1(start, end, arg_0)))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit importLeakCanaryTask$lambda$0$0(long $start, Common.Event.Builder $this$makeStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeStartedEvent, (String)"$this$makeStartedEvent");
        $this$makeStartedEvent.setLeakCanaryAnalysisStatus(LeakCanary.LeakCanaryAnalysisStatus.newBuilder().setAnalysisEnded(LeakCanary.LeakCanaryAnalysisEnded.newBuilder().setStartTimestamp($start)));
        return Unit.INSTANCE;
    }

    private static final Unit importLeakCanaryTask$lambda$0$1(long $start, long $end, Common.Event.Builder $this$makeEndedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeEndedEvent, (String)"$this$makeEndedEvent");
        $this$makeEndedEvent.setLeakCanaryAnalysisStatus(LeakCanary.LeakCanaryAnalysisStatus.newBuilder().setAnalysisEnded(LeakCanary.LeakCanaryAnalysisEnded.newBuilder().setStartTimestamp($start).setEndTimestamp($end)));
        return Unit.INSTANCE;
    }

    private static final List importLiveTask$lambda$0(long start, long l) {
        return CollectionsKt.listOf((Object)ImportedSessionUtils.makeStartedEvent(start, start, Common.Event.Kind.LIVE_VIEW_STATUS, (Function1<? super Common.Event.Builder, Unit>)((Function1)ImportedSessionUtils::importLiveTask$lambda$0$0)));
    }

    private static final Unit importLiveTask$lambda$0$0(Common.Event.Builder $this$makeStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeStartedEvent, (String)"$this$makeStartedEvent");
        return Unit.INSTANCE;
    }
}

