/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventsDataPoller
implements Runnable,
DataStoreTable.DataStoreTableErrorCallback {
    private final long myStreamId;
    @NotNull
    private final Consumer<Common.Event> myEventsHandler;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myEventPollingService;
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final CountDownLatch myRunningLatch;
    @NotNull
    private final AtomicBoolean myIsRunning = new AtomicBoolean(false);

    public UnifiedEventsDataPoller(long streamId, @NotNull Consumer<Common.Event> eventsHandler, @NotNull TransportServiceGrpc.TransportServiceBlockingStub pollingService, @NotNull DataStoreService dataStoreService) {
        this.myEventPollingService = pollingService;
        this.myDataStoreService = dataStoreService;
        this.myStreamId = streamId;
        this.myEventsHandler = eventsHandler;
        this.myRunningLatch = new CountDownLatch(1);
    }

    @Override
    public void onDataStoreError(Throwable t) {
        this.myDataStoreService.disconnect(this.myStreamId);
    }

    public void stop() {
        try {
            if (this.myIsRunning.get()) {
                this.myRunningLatch.await();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.myIsRunning.set(true);
        try {
            Iterator events = this.myEventPollingService.getEvents(Transport.GetEventsRequest.getDefaultInstance());
            while (events.hasNext()) {
                Common.Event event = (Common.Event)events.next();
                if (event == null) continue;
                this.myEventsHandler.accept(event);
            }
        }
        catch (StatusRuntimeException statusRuntimeException) {
            // empty catch block
        }
        this.myRunningLatch.countDown();
    }
}

