/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExplicitSpecifier;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCUDLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCElementFactory {
    private static final Logger LOG = Logger.getInstance(OCElementFactory.class);

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context);
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(0);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe @Nullable String modifier, String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(modifier, name, type, null, null, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(1);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe @Nullable String modifier, @NlsSafe String name, OCType type, @Nullable OCExpression initializer, @Nullable OCCompoundInitializer initializerList, @Nullable OCArgumentList argumentList, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(2);
        }
        Object declText = OCElementFactory.declarationText(ContainerUtil.createMaybeSingletonList((Object)modifier), name, type, initializer != null ? "0" : null, context, null, false);
        if (initializer == null) {
            if (initializerList != null) {
                declText = (String)declText + "{}";
            } else if (argumentList != null) {
                declText = (String)declText + "(0)";
            }
        }
        OCDeclarationStatement statement = (OCDeclarationStatement)OCElementFactory.statementFromText((String)declText, context, true);
        OCDeclarator declarator = statement.getDeclaration().getDeclarators().get(0);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializer(), initializer);
        } else if (initializerList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializerList(), initializerList);
        } else if (argumentList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getArgumentList(), argumentList);
        }
        OCDeclarationStatement oCDeclarationStatement = statement;
        if (oCDeclarationStatement == null) {
            OCElementFactory.$$$reportNull$$$0(3);
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(4);
        }
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(5);
        }
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(6);
        }
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, false);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, String typeNameHint, @Nullable String initializerText, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(7);
        }
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, initializerText, context, typeNameHint, false);
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(@NlsSafe String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(name, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(8);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(@NlsSafe String text, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(9);
        }
        OCParameterDeclaration oCParameterDeclaration = ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(10);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(@NlsSafe String name, OCType type, @Nullable OCExpression defaultValue, PsiElement context) {
        String typeNameHint = null;
        if (type instanceof OCAutoType) {
            OCAutoType autoType = (OCAutoType)type;
            OCType incompleteType = autoType.getIncompleteType();
            typeNameHint = incompleteType != null ? incompleteType.getName() : autoType.getName();
        }
        OCParameterDeclaration paramDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(Collections.emptyList(), name, type, defaultValue != null ? "0" : null, context, typeNameHint, false), context);
        if (defaultValue != null) {
            OCChangeUtil.replaceHandlingMacros(paramDeclaration.getDeclarator().getInitializer(), defaultValue);
        }
        OCParameterDeclaration oCParameterDeclaration = paramDeclaration;
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(11);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context) {
        return OCElementFactory.propertyDeclaration(name, type, context, null, false);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, readonly, null);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class);
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        ArrayList<@NlsSafe String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        @NlsSafe StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (!attributesText.isEmpty()) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + String.valueOf(attributesText) + OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, true) + "; @end";
        OCProperty oCProperty = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(12);
        }
        return oCProperty;
    }

    @NotNull
    public static OCDeclaration enumConst(@NlsSafe String name, PsiElement context) {
        OCDeclaration oCDeclaration = ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context).getFirstChild()).getFields().get(0);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(13);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, @NotNull OCResolveContext context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(14);
        }
        String constant = OCIntType.getAppropriateBool(context.isObjc()).getValue(value, context);
        OCExpression oCExpression = (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(constant, context.getProject(), context.getElement(), false, false), OCExpression.class);
        if (oCExpression == null) {
            OCElementFactory.$$$reportNull$$$0(15);
        }
        return oCExpression;
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<@NlsSafe String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        OCSendMessageExpression oCSendMessageExpression = (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCSendMessageExpression == null) {
            OCElementFactory.$$$reportNull$$$0(16);
        }
        return oCSendMessageExpression;
    }

    @NotNull
    public static OCCompoundInitializer braceInitializer(@NotNull @NlsSafe String typeName, @NotNull List<OCExpression> args, @NotNull PsiElement context) {
        if (typeName == null) {
            OCElementFactory.$$$reportNull$$$0(17);
        }
        if (args == null) {
            OCElementFactory.$$$reportNull$$$0(18);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(19);
        }
        String argList = StringUtil.join(args, PsiElement::getText, (String)",");
        OCDeclaration declaration = OCElementFactory.declarationFromText(typeName + " tmp{" + argList + "};", context);
        OCDeclarator declarator = declaration.getDeclarators().get(0);
        OCCompoundInitializer oCCompoundInitializer = (OCCompoundInitializer)PsiTreeUtil.getChildOfType((PsiElement)declarator, OCCompoundInitializer.class);
        if (oCCompoundInitializer == null) {
            OCElementFactory.$$$reportNull$$$0(20);
        }
        return oCCompoundInitializer;
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable @NlsSafe String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        OCCallExpression oCCallExpression = (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCCallExpression == null) {
            OCElementFactory.$$$reportNull$$$0(21);
        }
        return oCCallExpression;
    }

    @NotNull
    public static OCInterface interfaceByName(@NlsSafe String name, PsiElement context) {
        return (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context, true);
    }

    @NotNull
    public static OCMethod methodFromText(@NlsSafe String text, PsiElement context, boolean reformat) {
        OCMethod oCMethod = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
        if (oCMethod == null) {
            OCElementFactory.$$$reportNull$$$0(22);
        }
        return oCMethod;
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(@NlsSafe String name, @NlsSafe String defaultValue, PsiFile file) {
        return (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file);
    }

    @NotNull
    public static OCMethod methodFromSignature(@NlsSafe @NotNull String signature2, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings;
        if (signature2 == null) {
            OCElementFactory.$$$reportNull$$$0(23);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(24);
        }
        String semicolon = (settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class)) != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        return OCElementFactory.methodFromText(signature2 + (String)(needBody ? semicolon + "{\n}" : ";"), context, reformat);
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        OCUnaryExpression oCUnaryExpression = expression;
        if (oCUnaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(25);
        }
        return oCUnaryExpression;
    }

    @NotNull
    public static PsiElement createUDLSuffix(@NlsSafe String name, PsiElement context) {
        OCUDLiteralExpressionImpl expression = (OCUDLiteralExpressionImpl)OCElementFactory.expressionFromText("\"\"" + name, context, false);
        PsiElement psiElement = expression.getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(26);
        }
        return psiElement;
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        OCBinaryExpression oCBinaryExpression = expression;
        if (oCBinaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(27);
        }
        return oCBinaryExpression;
    }

    @NotNull
    public static OCExplicitSpecifier explicitSpecifier(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(28);
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)OCElementFactory.constructorFromText("explicit Foo();", "Foo", context);
        OCExplicitSpecifier oCExplicitSpecifier = function.getExplicitSpecifier();
        if (oCExplicitSpecifier == null) {
            OCElementFactory.$$$reportNull$$$0(29);
        }
        return oCExplicitSpecifier;
    }

    @NotNull
    public static OCNoexceptSpecifier noexceptSpecifier(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(30);
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)OCElementFactory.topLevelDeclarationFromText("void foo() noexcept;", context);
        OCNoexceptSpecifier oCNoexceptSpecifier = function.getNoexceptSpecifier();
        if (oCNoexceptSpecifier == null) {
            OCElementFactory.$$$reportNull$$$0(31);
        }
        return oCNoexceptSpecifier;
    }

    @NotNull
    public static OCConditionalExpression conditionalExpression(@NotNull OCExpression condition, @NotNull OCExpression thenExpression, @NotNull OCExpression elseExpression) {
        if (condition == null) {
            OCElementFactory.$$$reportNull$$$0(32);
        }
        if (thenExpression == null) {
            OCElementFactory.$$$reportNull$$$0(33);
        }
        if (elseExpression == null) {
            OCElementFactory.$$$reportNull$$$0(34);
        }
        OCConditionalExpression conditionalExpression = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getCondition(), condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getPositiveExpression(false), thenExpression);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getNegativeExpression(), elseExpression);
        OCConditionalExpression oCConditionalExpression = conditionalExpression;
        if (oCConditionalExpression == null) {
            OCElementFactory.$$$reportNull$$$0(35);
        }
        return oCConditionalExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(@NlsSafe String operator, PsiElement context) {
        PsiElement psiElement = ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    @NotNull
    public static ASTNode typeModifierFromText(@NlsSafe String modifier, PsiElement context) {
        ASTNode aSTNode = OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(37);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + String.valueOf((Object)scope) + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            PsiElement psiElement = kid;
            if (psiElement == null) {
                OCElementFactory.$$$reportNull$$$0(38);
            }
            return psiElement;
        }
        if (null == null) {
            OCElementFactory.$$$reportNull$$$0(39);
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        OCInstanceVariablesList oCInstanceVariablesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
        if (oCInstanceVariablesList == null) {
            OCElementFactory.$$$reportNull$$$0(40);
        }
        return oCInstanceVariablesList;
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe @NotNull String text, @NlsSafe @NotNull String ctorName, PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(41);
        }
        if (ctorName == null) {
            OCElementFactory.$$$reportNull$$$0(42);
        }
        return OCElementFactory.constructorFromText(text, ctorName, context, false);
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe @NotNull String text, @NlsSafe @NotNull String ctorName, PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(43);
        }
        if (ctorName == null) {
            OCElementFactory.$$$reportNull$$$0(44);
        }
        String classText = "struct " + ctorName + " { " + text + "; };";
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull(classText, context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        OCDeclaration oCDeclaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCDeclaration.class);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(45);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", "XXX", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        OCConstructorInitializationList oCConstructorInitializationList = list;
        if (oCConstructorInitializationList == null) {
            OCElementFactory.$$$reportNull$$$0(46);
        }
        return oCConstructorInitializationList;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(@NlsSafe String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", "XXX", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCConstructorFieldInitializer oCConstructorFieldInitializer = list.getInitializers().get(0);
        if (oCConstructorFieldInitializer == null) {
            OCElementFactory.$$$reportNull$$$0(47);
        }
        return oCConstructorFieldInitializer;
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @NlsSafe @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (String)(value != null ? "=" + value : "") + ") int x; @end";
        OCPropertyAttributesList oCPropertyAttributesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
        if (oCPropertyAttributesList == null) {
            OCElementFactory.$$$reportNull$$$0(48);
        }
        return oCPropertyAttributesList;
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(@NlsSafe String myKeyword, @NlsSafe String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizePropertiesList oCSynthesizePropertiesList = (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
        if (oCSynthesizePropertiesList == null) {
            OCElementFactory.$$$reportNull$$$0(49);
        }
        return oCSynthesizePropertiesList;
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(@NlsSafe String property, @NlsSafe @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizeProperty oCSynthesizeProperty = ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
        if (oCSynthesizeProperty == null) {
            OCElementFactory.$$$reportNull$$$0(50);
        }
        return oCSynthesizeProperty;
    }

    @NotNull
    private static String declaratorText(@NlsSafe String name, OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(51);
        }
        if ("<unnamed>".equals(name)) {
            name = "";
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type.getAliasName() == null) {
            if (OCElementFactory.isDeclaratorParenthesesRequired(type)) {
                return OCElementFactory.declaratorTextWithParentheses((String)name, type, context, eraseARCAttributes);
            }
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                return OCElementFactory.arrayDeclaratorText((String)name, arrayType, context, eraseARCAttributes);
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + (String)name;
                }
                String string = (String)(!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText((String)name, pointerType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(52);
                }
                return string;
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(resolveContext));
                b.append(' ');
                if (((String)name).startsWith("(")) {
                    b.append((String)name);
                } else {
                    b.append("(").append((String)name).append(")");
                }
                b.append(OCTypeNameVisitor.getFunctionSignature(resolveContext, funType, "", false, null));
                String string = b.toString();
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(53);
                }
                return string;
            }
        }
        String string = type.getBestNameInContext(resolveContext) + " " + (String)name;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private static String declaratorTextWithParentheses(@NlsSafe String name, @NotNull OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(55);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(56);
        }
        boolean isVariadic = false;
        if (type instanceof OCVariadicType) {
            OCVariadicType variadicType = (OCVariadicType)type;
            type = variadicType.getUnderlyingType();
            isVariadic = true;
        }
        StringBuilder pointerOrRefBuilder = new StringBuilder();
        while (type instanceof OCCppReferenceType || type.getClass().equals(OCPointerType.class)) {
            StringBuilder builder = new StringBuilder();
            if (type instanceof OCCppReferenceType) {
                OCCppReferenceType refType = (OCCppReferenceType)type;
                builder.append(refType.isRvalueRef() ? "&&" : "&");
                type.getCVQualifiers().appendCVQualifiers(builder);
                type = refType.getRefType();
            } else {
                builder.append("*");
                type.getCVQualifiers().appendCVQualifiers(builder);
                type = ((OCPointerType)type).getRefType();
            }
            pointerOrRefBuilder.insert(0, builder);
        }
        return OCElementFactory.declaratorText("(" + String.valueOf(pointerOrRefBuilder) + (isVariadic ? "..." : "") + name + ")", type, context, eraseARCAttributes);
    }

    @NotNull
    private static String arrayDeclaratorText(@NlsSafe String name, @NotNull OCArrayType arrayType, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if (arrayType == null) {
            OCElementFactory.$$$reportNull$$$0(57);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(58);
        }
        return OCElementFactory.declaratorText(name + " [" + OCElementFactory.getArrayLength(arrayType, context) + "]", arrayType.getRefType(), context, eraseARCAttributes);
    }

    @NlsSafe
    private static String getArrayLength(@NotNull OCArrayType arrayType, @NotNull PsiElement context) {
        String name;
        if (arrayType == null) {
            OCElementFactory.$$$reportNull$$$0(59);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(60);
        }
        if (!arrayType.hasLength()) {
            return "";
        }
        int length = arrayType.getLength(OCResolveContext.forPsi(context));
        if (length != -1) {
            return Integer.toString(length);
        }
        OCExpressionSymbol arrayLengthSymbol = arrayType.getLengthSymbol();
        if (arrayLengthSymbol instanceof OCReferenceExpressionSymbol && !"<unnamed>".equals(name = arrayLengthSymbol.getName()) && StringUtil.isNotEmpty((String)name)) {
            return name;
        }
        return "";
    }

    @NotNull
    public static String declarationText(@NotNull List<@NlsSafe String> modifiers, @NlsSafe String name, OCType type, @NlsSafe @Nullable String initializerText, @NotNull PsiElement context, @NlsSafe @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (modifiers == null) {
            OCElementFactory.$$$reportNull$$$0(61);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(62);
        }
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name) || name.isEmpty();
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (OCElementFactory.isDeclaratorParenthesesRequired(type) || type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                b.append(resolveContext.isObjc() ? "id" : "int");
            } else {
                b.append(type.getBestNameInContext(resolveContext, typeNameHint));
            }
            if (!isUnnamed) {
                b.append(' ').append(name);
            }
        }
        Object declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, resolveContext)) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name;
        }
        if (initializerText != null) {
            String string = (String)declarationText + "=" + initializerText;
            if (string == null) {
                OCElementFactory.$$$reportNull$$$0(63);
            }
            return string;
        }
        String string = declarationText;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(64);
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(@NlsSafe @NotNull String name, @NotNull PsiElement context) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(65);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(66);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("int " + name, context.getProject(), context, false, false)), OCDeclaration.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        PsiElement psiElement = declarators.get(0).getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(67);
        }
        return psiElement;
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NlsSafe @NotNull String name, @NotNull OCMacroForeignLeafElement sample) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(68);
        }
        if (sample == null) {
            OCElementFactory.$$$reportNull$$$0(69);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false)), OCDeclaration.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        OCMacroForeignLeafElement oCMacroForeignLeafElement = identifier;
        if (oCMacroForeignLeafElement == null) {
            OCElementFactory.$$$reportNull$$$0(70);
        }
        return oCMacroForeignLeafElement;
    }

    @Nullable
    public static OCCppNamespaceQualifier createNamespaceQualifier(OCQualifiedName name, PsiElement context) {
        String nameText = name.getFullName(OCResolveContext.forPsi(context));
        if (!nameText.isEmpty()) {
            OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + nameText + "::XXXX {}", context, true).getTypeElement().getFirstChild();
            return struct.getNamespaceQualifier();
        }
        return null;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        ASTNode aSTNode = struct.getNode().findChildByType((IElementType)OCLexerTokenTypes.COLON2X);
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(71);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(72);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(73);
        }
        return OCElementFactory.topLevelDeclarationFromText(text, context, false);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(74);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(75);
        }
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        PsiElement psiElement = child;
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(76);
        }
        return psiElement;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        OCTypeElement typeElement;
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(77);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(78);
        }
        return (typeElement = OCElementFactory.typeElementFromTextOrNull(text, context, true)) != null ? typeElement : new OCEmptyTypeElement(context);
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(79);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(80);
        }
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NlsSafe @NotNull String name, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(81);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(82);
        }
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(83);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(84);
        }
        return OCElementFactory.expressionFromText(text, context, false);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(85);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(86);
        }
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(87);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(88);
        }
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(89);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(90);
        }
        text = "void _______dummy(){" + (String)text + ";}";
        OCCodeFragment element = OCElementFactory.codeFragment((String)text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NonNls @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(91);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(92);
        }
        return OCElementFactory.codeFragment(text, project, context, OCTokenTypes.OC_FILE, physical, reformat);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(93);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(94);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(95);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(96);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(97);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(98);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(99);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(100);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(101);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(102);
        }
        return OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(103);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(104);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment qualifiedIdCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(105);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(106);
        }
        return OCElementFactory.codeFragment(text, context.getProject(), context, OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT, true, false);
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(@NlsSafe String text, @NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(107);
        }
        return (OCCodeFragment)WriteCommandAction.writeCommandAction((Project)project).compute(() -> OCElementFactory.typeCodeFragment(text, project, context, true, true));
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(108);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(109);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(110);
        }
        return OCElementFactory.codeFragment(text, project, context, type, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCLanguageKind getLanguageKindFromContext(@Nullable PsiElement context) {
        PsiFile file;
        if (context != null && (file = context.getContainingFile()) instanceof OCFile) {
            OCFile ocFile = (OCFile)file;
            OCLanguageKind kind = ocFile.getKind();
            OCLanguageKind oCLanguageKind = CLanguageKind.find((boolean)kind.isObjC(), (boolean)kind.isCpp(), (boolean)kind.isCuda());
            if (oCLanguageKind == null) {
                OCElementFactory.$$$reportNull$$$0(111);
            }
            return oCLanguageKind;
        }
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage();
        if (cLanguageKind == null) {
            OCElementFactory.$$$reportNull$$$0(112);
        }
        return cLanguageKind;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(113);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(114);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(115);
        }
        if (kind == null) {
            OCElementFactory.$$$reportNull$$$0(116);
        }
        if (context == null && formatToCodestyle) {
            OCLog.LOG.warn("Formatting of code fragment without context is deprecated!");
        }
        OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project, kind, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed() || !physical) {
                PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fragment));
            } else {
                LOG.error("Write access is required");
            }
        }
        OCCodeFragmentImpl oCCodeFragmentImpl = fragment;
        if (oCCodeFragmentImpl == null) {
            OCElementFactory.$$$reportNull$$$0(117);
        }
        return oCCodeFragmentImpl;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(118);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(119);
        }
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(120);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(121);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1 CIDR_RULE_ZZZ2", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(122);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement commentFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(123);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(124);
        }
        PsiElement psiElement = OCElementFactory.codeFragment(text, context.getProject(), context, false, false).getFirstChild();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(125);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(126);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1\nCIDR_RULE_ZZZ2", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(127);
        }
        return psiElement;
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        if (oldElement == null) {
            OCElementFactory.$$$reportNull$$$0(128);
        }
        if (newElement == null) {
            OCElementFactory.$$$reportNull$$$0(129);
        }
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newElement.getNode()), (int)IndentHelper.getInstance().getIndent(context, oldElement.getNode()));
    }

    @NotNull
    public static OCBlockStatement surroundByBraces(@NotNull PsiElement element) {
        if (element == null) {
            OCElementFactory.$$$reportNull$$$0(130);
        }
        if (element instanceof OCBlockStatement) {
            OCBlockStatement blockStmt;
            OCBlockStatement oCBlockStatement = blockStmt = (OCBlockStatement)element;
            if (oCBlockStatement == null) {
                OCElementFactory.$$$reportNull$$$0(131);
            }
            return oCBlockStatement;
        }
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", element);
        OCChangeUtil.addAfter(blockStatement, element, blockStatement.getOpeningBrace());
        OCBlockStatement oCBlockStatement = blockStatement;
        if (oCBlockStatement == null) {
            OCElementFactory.$$$reportNull$$$0(132);
        }
        return oCBlockStatement;
    }

    @NotNull
    public static PsiElement createLeaf(@NotNull PsiManager manager, @NotNull OCElementType type) {
        if (manager == null) {
            OCElementFactory.$$$reportNull$$$0(133);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(134);
        }
        PsiElement psiElement = Factory.createSingleLeafElement((IElementType)type, (CharSequence)type.getName(), (int)0, (int)type.getName().length(), null, (PsiManager)manager).getPsi();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(135);
        }
        return psiElement;
    }

    private static boolean isDeclaratorParenthesesRequired(@NotNull OCType type) {
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(136);
        }
        if (type instanceof OCVariadicType) {
            OCVariadicType variadicType = (OCVariadicType)type;
            type = variadicType.getUnderlyingType();
        }
        OCType pointeeType = type;
        while (pointeeType instanceof OCCppReferenceType || pointeeType.getClass().equals(OCPointerType.class)) {
            if (pointeeType instanceof OCCppReferenceType) {
                OCCppReferenceType refType = (OCCppReferenceType)pointeeType;
                pointeeType = refType.getRefType();
                continue;
            }
            pointeeType = ((OCPointerType)pointeeType).getRefType();
        }
        return !(!type.getClass().equals(OCPointerType.class) && !(type instanceof OCCppReferenceType) || !(pointeeType instanceof OCArrayType) && !(pointeeType instanceof OCFunctionType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7, 9, 14, 17, 18, 19, 23, 24, 28, 30, 32, 33, 34, 41, 42, 43, 44, 51, 55, 56, 57, 58, 59, 60, 61, 62, 65, 66, 68, 69, 72, 73, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 113, 114, 115, 116, 118, 119, 121, 123, 124, 126, 128, 129, 130, 133, 134, 136 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 19: 
            case 24: 
            case 28: 
            case 30: 
            case 51: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 66: 
            case 73: 
            case 75: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 90: 
            case 102: 
            case 106: 
            case 119: 
            case 121: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 41: 
            case 43: 
            case 72: 
            case 74: 
            case 77: 
            case 79: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 108: 
            case 113: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctorName";
                break;
            }
            case 55: 
            case 110: 
            case 115: 
            case 118: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 65: 
            case 68: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 104: 
            case 107: 
            case 109: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "declaration";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 133: 
            case 134: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationByNameAndType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationFromText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationByNameAndType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyDeclaration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "enumConst";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanConstant";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sendMessageExpression";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "braceInitializer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "callExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "methodFromText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unaryExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createUDLSuffix";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryExpression";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "explicitSpecifier";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "noexceptSpecifier";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "conditionalExpression";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryOperatorFromText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "typeModifierFromText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "ivarScopeSpecifier";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceVariableList";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFromText";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorInitializationList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFieldInitializerFromText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyAttributeList";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesizeList";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesize";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "declaratorText";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationText";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createMacroForeignIdentifier";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createColon2x";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "topLevelDeclarationFromText";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKindFromContext";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "codeFragment";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceFromText";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "commentFromText";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "newlineFromText";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundByBraces";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "declarationFromText";
                break;
            }
            case 6: 
            case 7: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "declarationText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paramDeclarationFromText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "booleanConstant";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "braceInitializer";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "methodFromSignature";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "explicitSpecifier";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "noexceptSpecifier";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "conditionalExpression";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "constructorFromText";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "declaratorText";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "declaratorTextWithParentheses";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "arrayDeclaratorText";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getArrayLength";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createMacroForeignIdentifier";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "topLevelDeclarationFromText";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromText";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromTextOrNull";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "referenceElementFromText";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "expressionFromText";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "statementFromText";
                break;
            }
            case 91: 
            case 92: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "codeFragment";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragment";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragmentCpp";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "expressionOrStatementsCodeFragment";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "typeCodeFragment";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdCodeFragment";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCodeFragmentInWriteAction";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "spaceFromText";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "commentFromText";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "newlineFromText";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "initIndentFromContext";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "surroundByBraces";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaratorParenthesesRequired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7, 9, 14, 17, 18, 19, 23, 24, 28, 30, 32, 33, 34, 41, 42, 43, 44, 51, 55, 56, 57, 58, 59, 60, 61, 62, 65, 66, 68, 69, 72, 73, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 113, 114, 115, 116, 118, 119, 121, 123, 124, 126, 128, 129, 130, 133, 134, 136 -> new IllegalArgumentException(string);
        };
    }

    private static class OCEmptyTypeElement
    implements OCTypeElement {
        @NotNull
        final PsiElement myContext;

        private OCEmptyTypeElement(@NotNull PsiElement context) {
            if (context == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(0);
            }
            this.myContext = context;
        }

        @Override
        @NotNull
        public OCType getType() {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(1);
            }
            return oCUnknownType;
        }

        @Override
        @NotNull
        public OCType getRawType() {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(2);
            }
            return oCUnknownType;
        }

        @Override
        @NotNull
        public OCType getRawType(boolean assumeNonNull) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(3);
            }
            return oCUnknownType;
        }

        @Override
        public int getArrayLengths() {
            return 0;
        }

        @Override
        public boolean isEmptyType() {
            return true;
        }

        @Override
        public OCFile getContainingOCFile() {
            return null;
        }

        @Override
        public String getTextWithMacros() {
            return null;
        }

        @Override
        public TextRange getRangeWithMacros() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public long getComplexOffset() {
            return 0L;
        }

        @NotNull
        public Project getProject() throws PsiInvalidElementAccessException {
            Project project = this.myContext.getProject();
            if (project == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(4);
            }
            return project;
        }

        @NotNull
        public Language getLanguage() {
            Language language = Language.ANY;
            if (language == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(5);
            }
            return language;
        }

        public PsiManager getManager() {
            return null;
        }

        public PsiElement @NotNull [] getChildren() {
            if (PsiElement.EMPTY_ARRAY == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }

        public PsiElement getParent() {
            return null;
        }

        public PsiElement getFirstChild() {
            return null;
        }

        public PsiElement getLastChild() {
            return null;
        }

        public PsiElement getNextSibling() {
            return null;
        }

        public PsiElement getPrevSibling() {
            return null;
        }

        public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
            return null;
        }

        public TextRange getTextRange() {
            return null;
        }

        public int getStartOffsetInParent() {
            return 0;
        }

        public int getTextLength() {
            return 0;
        }

        @Nullable
        public PsiElement findElementAt(int offset) {
            return null;
        }

        @Nullable
        public PsiReference findReferenceAt(int offset) {
            return null;
        }

        public String getText() {
            return null;
        }

        public char @NotNull [] textToCharArray() {
            return new char[0];
        }

        public PsiElement getNavigationElement() {
            return null;
        }

        public PsiElement getOriginalElement() {
            return null;
        }

        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(7);
            }
            return false;
        }

        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(8);
            }
            return false;
        }

        public boolean textContains(char c) {
            return false;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(9);
            }
        }

        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(10);
            }
        }

        public PsiElement copy() {
            return null;
        }

        public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(11);
            }
            return null;
        }

        public PsiElement addBefore(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
            if (element == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(12);
            }
            return null;
        }

        public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
            if (element == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(13);
            }
            return null;
        }

        public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(14);
            }
        }

        public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
            return null;
        }

        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
            if (first == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(15);
            }
            if (last == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(16);
            }
            return null;
        }

        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
            return null;
        }

        public void delete() throws IncorrectOperationException {
        }

        public void checkDelete() throws IncorrectOperationException {
        }

        public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        }

        public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
            if (newElement == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(17);
            }
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public boolean isWritable() {
            return false;
        }

        @Nullable
        public PsiReference getReference() {
            return null;
        }

        public PsiReference @NotNull [] getReferences() {
            if (PsiReference.EMPTY_ARRAY == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(18);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Nullable
        public <T> T getCopyableUserData(@NotNull Key<T> key) {
            if (key == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(19);
            }
            return null;
        }

        public <T> void putCopyableUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(20);
            }
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            if (processor2 == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(21);
            }
            if (state == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(22);
            }
            if (place == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(23);
            }
            return false;
        }

        @Nullable
        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isPhysical() {
            return false;
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            if (null == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(24);
            }
            return null;
        }

        @NotNull
        public SearchScope getUseScope() {
            if (null == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(25);
            }
            return null;
        }

        public ASTNode getNode() {
            return null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            return false;
        }

        public Icon getIcon(int flags) {
            return null;
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(26);
            }
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                OCEmptyTypeElement.$$$reportNull$$$0(27);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 18, 24, 25 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 18: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/util/OCElementFactory$OCEmptyTypeElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 19: 
                case 20: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/util/OCElementFactory$OCEmptyTypeElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveScope";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUseScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 18: 
                case 24: 
                case 25: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "textMatches";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addBefore";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addAfter";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "checkAdd";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addRangeBefore";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getCopyableUserData";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "putCopyableUserData";
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 18, 24, 25 -> new IllegalStateException(string);
            };
        }
    }
}

