/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCObjectType
extends OCType {
    @Nullable
    private OCInterfaceSymbol myInterface;
    @Nullable
    private OCImplementationSymbol myImplementation;
    private List<OCProtocolSymbol> myAugmentedProtocols;
    private List<OCProtocolSymbol> myAllProtocols;
    private List<OCInterfaceSymbol> myCategoryInterfaces;
    private List<OCImplementationSymbol> myCategoryImplementations;
    @Nullable
    private OCObjectType mySuperType;
    private boolean myIsKindof = false;

    public OCObjectType() {
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCImplementationSymbol implementation, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, List<OCInterfaceSymbol> categoryInterfaces, List<OCImplementationSymbol> categoryImplementations, @Nullable OCObjectType superType, boolean isConst, boolean isVolatile, boolean isKindof) {
        super(isConst, isVolatile);
        this.myInterface = anInterface;
        this.myImplementation = implementation;
        this.myAllProtocols = allProtocols;
        this.myAugmentedProtocols = augmentedProtocols;
        this.myCategoryInterfaces = categoryInterfaces;
        this.myCategoryImplementations = categoryImplementations;
        this.mySuperType = superType;
        this.myIsKindof = isKindof;
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, boolean isConst, boolean isVolatile) {
        this(anInterface, null, allProtocols, augmentedProtocols, Collections.emptyList(), Collections.emptyList(), null, isConst, isVolatile, false);
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCObjectType superType) {
        this(anInterface, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), superType, false, false, false);
    }

    @Nullable
    public OCClassSymbol getClassSymbol() {
        return this.myInterface != null ? this.myInterface : this.myImplementation;
    }

    @Nullable
    public OCInterfaceSymbol getInterface() {
        return this.myInterface;
    }

    @Nullable
    public OCImplementationSymbol getImplementation() {
        return this.myImplementation;
    }

    public List<OCInterfaceSymbol> getCategoryInterfaces() {
        return this.myCategoryInterfaces;
    }

    public List<OCImplementationSymbol> getCategoryImplementations() {
        return this.myCategoryImplementations;
    }

    @NotNull
    public List<OCProtocolSymbol> getAllProtocols() {
        List<OCProtocolSymbol> list = this.myAllProtocols;
        if (list == null) {
            OCObjectType.$$$reportNull$$$0(0);
        }
        return list;
    }

    public List<OCProtocolSymbol> getAugmentedProtocols() {
        return this.myAugmentedProtocols;
    }

    @Nullable
    public OCObjectType getSuperType() {
        return this.mySuperType;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitObjectType(this);
    }

    @Nullable
    public <T extends OCMemberSymbol> T findMember(@NlsSafe String name, Class<T> memberClass) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processMembers(name, memberClass, (Processor<? super T>)processor2);
        return (T)((OCMemberSymbol)processor2.getFoundValue());
    }

    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String symbolName, Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(this.myInterface, symbolName, memberClass, processor2, true, true);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String name, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        return this.processMembers(this.myInterface, name, memberClass, processor2, processIntf, processImpl);
    }

    public <T extends OCMemberSymbol> boolean processMembers(OCClassSymbol intfSymbol, @Nullable String symbolName, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        if (processIntf && intfSymbol != null && !OCObjectType.doProcessMembers(symbolName, memberClass, Collections.singletonList(intfSymbol), processor2)) {
            return false;
        }
        if (processImpl && this.myImplementation != null && !OCObjectType.doProcessMembers(symbolName, memberClass, Collections.singletonList(this.myImplementation), processor2)) {
            return false;
        }
        if (processIntf) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(symbolName, memberClass, this.myCategoryInterfaces, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(symbolName, memberClass, processor2, true, false)) {
                return false;
            }
            if (!OCObjectType.doProcessMembers(symbolName, memberClass, this.myAllProtocols, processor2)) {
                return false;
            }
        }
        if (processImpl) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(symbolName, memberClass, this.myCategoryImplementations, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(symbolName, memberClass, processor2, false, true)) {
                return false;
            }
        }
        return true;
    }

    private static <T extends OCMemberSymbol> boolean doProcessMembers(@Nullable String symbolName, Class<T> memberClass, List<? extends OCClassSymbol> classes, Processor<? super T> processor2) {
        for (OCClassSymbol oCClassSymbol : classes) {
            if (oCClassSymbol.processMembers(symbolName, memberClass, processor2)) continue;
            return false;
        }
        return true;
    }

    public boolean processInterfaceMethods(OCClassSymbol intfSymbol, @Nullable String method, Processor<OCMethodSymbol> processor2, PsiElement context, boolean processBaseProtocols) {
        HashSet<String> baseProtocols = new HashSet<String>();
        LinkedHashSet<OCProtocolSymbol> baseProtocolSymbols = new LinkedHashSet<OCProtocolSymbol>();
        if (intfSymbol == null) {
            return true;
        }
        for (OCObjectType type = this.mySuperType; type != null; type = type.getSuperType()) {
            for (OCProtocolSymbol protocol : type.getAllProtocols()) {
                baseProtocols.add(protocol.getName());
                baseProtocolSymbols.add(protocol);
            }
        }
        if (!intfSymbol.processAllMethods(method, processor2, baseProtocols, context)) {
            return false;
        }
        if (intfSymbol.getCategoryName() != null) {
            return true;
        }
        for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
            if (!"".equals(category.getCategoryName()) || category.processAllMethods(method, processor2, baseProtocols, context)) continue;
            return false;
        }
        if (processBaseProtocols) {
            for (OCProtocolSymbol protocol : baseProtocolSymbols) {
                if (protocol.processAllMethods(method, processor2, baseProtocols, context)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getClassName() {
        String string = OCSymbolBase.getSymbolName(this.getClassSymbol());
        if (string == null) {
            OCObjectType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + (this.myInterface == null ? 0 : this.myInterface.hashCode());
        result = 31 * result + (this.myImplementation == null ? 0 : this.myImplementation.hashCode());
        result = 31 * result + this.myAllProtocols.hashCode();
        result = 31 * result + Boolean.valueOf(this.myIsKindof).hashCode();
        return result;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCObjectType.$$$reportNull$$$0(2);
        }
        if (first == null) {
            OCObjectType.$$$reportNull$$$0(3);
        }
        if (second == null) {
            OCObjectType.$$$reportNull$$$0(4);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCObjectType f = (OCObjectType)first;
        OCObjectType s = (OCObjectType)second;
        if (f.isKindof() != s.isKindof()) {
            return false;
        }
        if (!c.equalLists(f.myAllProtocols, s.myAllProtocols)) {
            return false;
        }
        if (!c.equalLists(f.myAugmentedProtocols, s.myAugmentedProtocols)) {
            return false;
        }
        if (!c.equalLists(f.myCategoryImplementations, s.myCategoryImplementations)) {
            return false;
        }
        if (!c.equalLists(f.myCategoryInterfaces, s.myCategoryInterfaces)) {
            return false;
        }
        if (!c.equalObjects(f.myImplementation, s.myImplementation)) {
            return false;
        }
        if (!c.equalObjects(f.myInterface, s.myInterface)) {
            return false;
        }
        return c.equalObjects(f.mySuperType, s.mySuperType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCObjectType.$$$reportNull$$$0(5);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCObjectType.$$$reportNull$$$0(6);
            }
            return oCUnknownType;
        }
        if (type instanceof OCObjectType) {
            if (this instanceof OCIdType && this.getAllProtocols().isEmpty()) {
                OCType oCType = type;
                if (oCType == null) {
                    OCObjectType.$$$reportNull$$$0(7);
                }
                return oCType;
            }
            if (type instanceof OCIdType && ((OCIdType)type).getAllProtocols().isEmpty()) {
                OCObjectType oCObjectType = this;
                if (oCObjectType == null) {
                    OCObjectType.$$$reportNull$$$0(8);
                }
                return oCObjectType;
            }
            if (this.checkCompatible(type, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK) {
                OCObjectType oCObjectType = this;
                if (oCObjectType == null) {
                    OCObjectType.$$$reportNull$$$0(9);
                }
                return oCObjectType;
            }
            if (type.checkCompatible(this, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK) {
                OCType oCType = type;
                if (oCType == null) {
                    OCObjectType.$$$reportNull$$$0(10);
                }
                return oCType;
            }
            if (this.mySuperType != null) {
                OCType result = this.mySuperType.getLeastCommonType(type, context);
                if (result instanceof OCObjectType) {
                    for (OCProtocolSymbol protocol : this.myAllProtocols) {
                        if (!((OCObjectType)type).implementsProtocol(protocol)) continue;
                        result = ((OCObjectType)result).augmentWithProtocol(protocol);
                    }
                }
                OCType oCType = result;
                if (oCType == null) {
                    OCObjectType.$$$reportNull$$$0(11);
                }
                return oCType;
            }
            OCClassSymbol classSymbol = ((OCObjectType)type).getClassSymbol();
            Project project = classSymbol != null ? context.getProject() : null;
            OCType oCType = project != null ? OCIdType.pointerToID().getRefType() : OCUnknownType.INSTANCE;
            if (oCType == null) {
                OCObjectType.$$$reportNull$$$0(12);
            }
            return oCType;
        }
        if (type.isPointerCompatible(context)) {
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                OCObjectType.$$$reportNull$$$0(13);
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCObjectType.$$$reportNull$$$0(14);
        }
        return oCUnknownType;
    }

    public boolean isAncestorOf(@Nullable OCObjectType type) {
        if (this instanceof OCIdType) {
            return true;
        }
        OCClassSymbol classSymbol = this.getClassSymbol();
        if (classSymbol == null) {
            return false;
        }
        while (!(type == null || type.getClassSymbol() != null && classSymbol.isSameClass(type.getClassSymbol()))) {
            type = type.mySuperType;
        }
        return type != null;
    }

    public boolean implementsProtocol(@Nullable OCProtocolSymbol protocol) {
        return this.myAllProtocols.contains(protocol) || this.mySuperType != null && this.mySuperType.implementsProtocol(protocol);
    }

    public OCObjectType augmentWithProtocol(@NotNull OCProtocolSymbol protocolSymbol) {
        if (protocolSymbol == null) {
            OCObjectType.$$$reportNull$$$0(15);
        }
        if (this.implementsProtocol(protocolSymbol)) {
            return this;
        }
        OCObjectType copy2 = (OCObjectType)this.getShallowCopy();
        copy2.myAugmentedProtocols = OCObjectType.cloneWithAddedProtocol(copy2.myAugmentedProtocols, protocolSymbol);
        copy2.myAllProtocols = OCObjectType.cloneWithAddedProtocol(copy2.myAllProtocols, protocolSymbol);
        return copy2;
    }

    @NotNull
    private static List<OCProtocolSymbol> cloneWithAddedProtocol(@NotNull List<OCProtocolSymbol> protocols, @NotNull OCProtocolSymbol protocolSymbol) {
        if (protocols == null) {
            OCObjectType.$$$reportNull$$$0(16);
        }
        if (protocolSymbol == null) {
            OCObjectType.$$$reportNull$$$0(17);
        }
        ArrayList<OCProtocolSymbol> newProtocols = new ArrayList<OCProtocolSymbol>(protocols.size() + 1);
        newProtocols.addAll(protocols);
        newProtocols.add(protocolSymbol);
        ArrayList<OCProtocolSymbol> arrayList = newProtocols;
        if (arrayList == null) {
            OCObjectType.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    @Override
    public String getFormatString() {
        return "%@";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCObjectType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolSymbol";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProtocols";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCObjectType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithAddedProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "augmentWithProtocol";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithAddedProtocol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

