/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ResettableLazy;
import com.intellij.util.ResettableLazyKt;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializerProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/FileSymbolTableSerializationVersion;", "", "<init>", "()V", "SERIALIZATION_INDEX_VERSION", "", "getVersion", "indicesVersion", "Lcom/intellij/util/ResettableLazy;", "", "invalidateCaches", "", "getGlobalIndicesVersion", "getStorageMarker", "Ljava/io/File;", "intellij.c.core"})
public final class FileSymbolTableSerializationVersion {
    @NotNull
    public static final FileSymbolTableSerializationVersion INSTANCE = new FileSymbolTableSerializationVersion();
    private static final int SERIALIZATION_INDEX_VERSION = 227;
    @NotNull
    private static final ResettableLazy<Long> indicesVersion = ResettableLazyKt.resettableLazy(FileSymbolTableSerializationVersion::indicesVersion$lambda$0);

    private FileSymbolTableSerializationVersion() {
    }

    public final int getVersion() {
        int result = 227;
        for (SerializerProvider provider2 : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            result *= 10;
            result += provider2.getClass().getName().hashCode();
            result += provider2.getVersion();
        }
        result = result * 10 + 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateCaches() {
        FileSymbolTableSerializationVersion fileSymbolTableSerializationVersion = this;
        synchronized (fileSymbolTableSerializationVersion) {
            boolean bl = false;
            FileUtil.delete((File)INSTANCE.getStorageMarker());
            indicesVersion.reset();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final long getGlobalIndicesVersion() throws IOException {
        return ((Number)indicesVersion.getValue()).longValue();
    }

    private final File getStorageMarker() {
        return new File(FileUtil.toCanonicalPath((String)PathManager.getSystemPath()), "symbol.cache.marker");
    }

    private static final long indicesVersion$lambda$0() {
        File file = INSTANCE.getStorageMarker();
        if (!file.exists()) {
            file.createNewFile();
        }
        BasicFileAttributeView view = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
        FileTime time = view.readAttributes().creationTime();
        return time.toMillis();
    }
}

