/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.project.Project;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapDeserializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapSerializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolBuildingTask;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import io.opentelemetry.api.trace.SpanBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class OCModuleMapBuildingActivity {
    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCModuleMapBuildingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCModuleMapBuildingActivity.$$$reportNull$$$0(1);
        }
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        if (userData.getProject().isDisposed()) {
            return;
        }
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "buildRemaining", null);){
            IJTracer tracer = TelemetryManager.getInstance().getTracer(new Scope("moduleMaps"));
            TraceKt.use((SpanBuilder)tracer.spanBuilder("OCModuleMapBuildingActivity"), __ -> {
                new ModuleMapBuildingActivity(userData.getProject(), indicator).buildModuleMaps();
                return null;
            });
        }
    }

    @TestOnly
    public static void rebuildModuleMaps(@NotNull Project project) {
        if (project == null) {
            OCModuleMapBuildingActivity.$$$reportNull$$$0(2);
        }
        OCInitialBuildingInfo info = new OCInitialBuildingInfo(project, OCSymbolTablesBuildingMode.FAST);
        OCModuleMapBuildingActivity.rebuildModuleMaps(info);
    }

    @TestOnly
    public static void rebuildModuleMaps(@NotNull OCInitialBuildingInfo info) {
        if (info == null) {
            OCModuleMapBuildingActivity.$$$reportNull$$$0(3);
        }
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        Project project = info.getProject();
        SymbolBuildingTask.scheduleSymbolActivity("rebuildModuleMaps", project, indicator -> {
            ModuleMapCache.getInstance(project).reset();
            ModuleMapManager.getInstance(project).clearCache();
            indicator.setIndeterminate(false);
            OCModuleMapDeserializationActivity.build(indicator, info);
            OCModuleMapBuildingActivity.build(indicator, info);
            OCModuleMapSerializationActivity.build(indicator, info);
        });
    }

    public static void buildModuleMapsFromScratch(@NotNull Project project) {
        if (project == null) {
            OCModuleMapBuildingActivity.$$$reportNull$$$0(4);
        }
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        OCInitialBuildingInfo info = new OCInitialBuildingInfo(project, OCSymbolTablesBuildingMode.FAST);
        info.putUserData(OCModuleMapDeserializationActivity.DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY, true);
        OCModuleMapBuildingActivity.rebuildModuleMaps(info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCModuleMapBuildingActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildModuleMaps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModuleMapsFromScratch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

