/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnaryExpressionSymbolBase
extends OCExpressionSymbol {
    protected OCElementType myOperator;
    protected OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbolBase() {
    }

    /*
     * WARNING - void declaration
     */
    public OCUnaryExpressionSymbolBase(@Nullable VirtualFile file, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol oCExpressionSymbol) {
        void operand;
        if (operator == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(0);
        }
        if (oCExpressionSymbol == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(1);
        }
        super(file, offset);
        this.myOperator = operator;
        this.myOperand = operand;
    }

    @NotNull
    public abstract OCOperatorReference.OperatorPlacement getOperatorPlacement();

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(2);
        }
        if (first == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(3);
        }
        if (second == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(4);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbolBase firstSymbol = (OCUnaryExpressionSymbolBase)first;
        OCUnaryExpressionSymbolBase secondSymbol = (OCUnaryExpressionSymbolBase)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(5);
        }
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    protected abstract OCType getResolvedType(OCType var1, @NotNull OCResolveContext var2);

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType opType;
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(6);
        }
        if ((opType = this.myOperand.getResolvedType(context)) instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if ((symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context)) != null) {
            OCType oCType = symbol.getType().getReturnType().resolve(context);
            if (oCType == null) {
                OCUnaryExpressionSymbolBase.$$$reportNull$$$0(7);
            }
            return oCType;
        }
        OCType oCType = this.getResolvedType(opType, context);
        if (oCType == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(9);
        }
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(10);
        }
        OCType opType = this.myOperand.getResolvedType(context);
        OCType customReturnType = null;
        OCFunctionSymbol symbol = this.tryResolveOperator(context, opType);
        if (symbol != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        return new Info(opType, customReturnType);
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(11);
        }
        OCType opType = this.myOperand.getResolvedType(context);
        return this.tryResolveOperator(context, opType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context, @Nullable OCType opType) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(12);
        }
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if (opType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context);
        }
        return null;
    }

    public OCElementType getOperator() {
        return this.myOperator;
    }

    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myOperator.getName() + this.myOperand.getPresentableName();
        if (string == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbolBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbolBase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomReturnType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveOperator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 13 -> new IllegalStateException(string);
        };
    }

    private static final class Info {
        @Nullable
        public final OCType opType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType opType, @Nullable OCType customReturnType) {
            this.opType = opType;
            this.customReturnType = customReturnType;
        }
    }
}

