/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.stats;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/stats/CodeInsightCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "STATUS", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/jetbrains/cidr/lang/stats/CodeInsightCollector$CodeInsightStatus;", "", "getGroup", "CodeInsightStatus", "Listener", "intellij.c.core"})
public final class CodeInsightCollector
extends CounterUsagesCollector {
    @NotNull
    public static final CodeInsightCollector INSTANCE = new CodeInsightCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.codeInsight", 4, null, 4, null);
    @JvmField
    @NotNull
    public static final EventId2<CodeInsightStatus, String> STATUS = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"status", (EventField)((EventField)EventFields.Enum$default((String)"status", CodeInsightStatus.class, null, (int)4, null)), (EventField)((EventField)EventFields.AnonymizedPath), null, (int)8, null);

    private CodeInsightCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/stats/CodeInsightCollector$CodeInsightStatus;", "", "<init>", "(Ljava/lang/String;I)V", "OK", "TOO_LARGE", "NOT_IN_SOURCES", "intellij.c.core"})
    public static final class CodeInsightStatus
    extends Enum<CodeInsightStatus> {
        public static final /* enum */ CodeInsightStatus OK = new CodeInsightStatus();
        public static final /* enum */ CodeInsightStatus TOO_LARGE = new CodeInsightStatus();
        public static final /* enum */ CodeInsightStatus NOT_IN_SOURCES = new CodeInsightStatus();
        private static final /* synthetic */ CodeInsightStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CodeInsightStatus[] values() {
            return (CodeInsightStatus[])$VALUES.clone();
        }

        public static CodeInsightStatus valueOf(String value) {
            return Enum.valueOf(CodeInsightStatus.class, value);
        }

        @NotNull
        public static EnumEntries<CodeInsightStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = codeInsightStatusArray = new CodeInsightStatus[]{CodeInsightStatus.OK, CodeInsightStatus.TOO_LARGE, CodeInsightStatus.NOT_IN_SOURCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/stats/CodeInsightCollector$Listener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "logStatus", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c.core"})
    public static final class Listener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getNewFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile newFile = virtualFile;
            ApplicationManager.getApplication().executeOnPooledThread(() -> Listener.selectionChanged$lambda$1(newFile, this, event));
        }

        private final void logStatus(VirtualFile file, Project project) {
            Pair pair = (Pair)ActionsKt.runReadAction(() -> Listener.logStatus$lambda$2(file, project));
            CodeInsightStatus status = (CodeInsightStatus)((Object)pair.component1());
            Object object = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
            String path = (String)object;
            STATUS.log((Object)status, (Object)path);
        }

        private static final Unit selectionChanged$lambda$1$lambda$0(VirtualFile $newFile, Listener this$0, FileEditorManagerEvent $event) {
            if (LanguageUtils.Companion.getInstance().isSupportedFile($newFile)) {
                Project project = $event.getManager().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                this$0.logStatus($newFile, project);
            }
            return Unit.INSTANCE;
        }

        private static final void selectionChanged$lambda$1(VirtualFile $newFile, Listener this$0, FileEditorManagerEvent $event) {
            ActionsKt.runReadAction(() -> Listener.selectionChanged$lambda$1$lambda$0($newFile, this$0, $event));
        }

        private static final Pair logStatus$lambda$2(VirtualFile $file, Project $project) {
            CodeInsightStatus status = !OCCodeInsightUtil.isCodeInsightAvailable($file, $project) ? CodeInsightStatus.TOO_LARGE : (!OCSearchScope.isInProjectSourcesOrLibraries($project, $file) && !ScratchUtil.isScratch((VirtualFile)$file) ? CodeInsightStatus.NOT_IN_SOURCES : CodeInsightStatus.OK);
            return TuplesKt.to((Object)((Object)status), (Object)$file.getPath());
        }
    }
}

