/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCUniqueNameGenerator {
    private static final Logger LOG = Logger.getInstance(OCUniqueNameGenerator.class);

    private OCUniqueNameGenerator() {
    }

    public static String suggestUniqueName(@NotNull OCSymbol symbol, @Nullable PsiElement scope, @NotNull Project project) {
        if (symbol == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(1);
        }
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
        return OCUniqueNameGenerator.suggestUniqueName(symbol.getKind(), symbol, context, symbol.getName(), scope, Collections.emptyList(), project);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, @NotNull Project project) {
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(2);
        }
        return OCUniqueNameGenerator.suggestUniqueName(symbolKind, baseName, scope, Collections.emptyList(), project);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull Project project) {
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(3);
        }
        OCResolveContext context = scope != null ? OCResolveContext.forPsi(scope) : null;
        return OCUniqueNameGenerator.suggestUniqueName(symbolKind, null, context, baseName, scope, forbiddenNames, project);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext resolveContext, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull Project project) {
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(4);
        }
        List scopes = ContainerUtil.createMaybeSingletonList((Object)scope);
        return OCUniqueNameGenerator.suggestUniqueName(symbolKind, symbol, baseName, scopes, forbiddenNames, resolveContext, project);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, String baseName, @NotNull List<PsiElement> scopes, @NotNull Collection<String> forbiddenNames, @Nullable OCResolveContext context, @NotNull Project project) {
        if (scopes == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(5);
        }
        if (forbiddenNames == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(7);
        }
        int count = 0;
        int MAX_ITERATIONS = 5000;
        do {
            String candidate = count > 0 ? baseName + count : baseName;
            candidate = OCNamingConventionUtil.applyNamingConvention(candidate, symbolKind, symbol, context, project);
            boolean isUnique = true;
            if (forbiddenNames.contains(candidate)) {
                isUnique = false;
            }
            for (PsiElement scope : scopes) {
                if (scope == null || OCCodeInsightUtil.isUniqueInScope(symbolKind, candidate, scope, scope.getProject())) continue;
                isUnique = false;
                break;
            }
            if (!isUnique) continue;
            return candidate;
        } while (++count < 5000);
        LOG.warn("Cannot suggest unique name for " + StringUtil.wrapWithDoubleQuote((String)baseName));
        return baseName;
    }

    public static Collection<String> convertToUniqueNames(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @NotNull Collection<String> candidates, @Nullable PsiElement scope, @NotNull Collection<String> forbiddenNames, @Nullable OCResolveContext context, @NotNull Project project) {
        if (candidates == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(8);
        }
        if (forbiddenNames == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OCUniqueNameGenerator.$$$reportNull$$$0(10);
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        LinkedHashSet<String> augmented = new LinkedHashSet<String>();
        List scopes = ContainerUtil.createMaybeSingletonList((Object)scope);
        for (String candidate : candidates) {
            String unique = OCUniqueNameGenerator.suggestUniqueName(symbolKind, symbol, candidate, scopes, forbiddenNames, context, project);
            if (Objects.equals(unique, candidate)) {
                answer.add(unique);
                continue;
            }
            augmented.add(unique);
        }
        answer.addAll(augmented);
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbiddenNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCUniqueNameGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestUniqueName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToUniqueNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

