/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationButInitializerIntentionAction
extends OCRemoveDeclarationIntentionAction
implements HighPriorityAction {
    public OCRemoveDeclarationButInitializerIntentionAction(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbol, project);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(1);
        }
        super(whatToRemove, symbol, project);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(2);
        }
        super(whatToRemove, element, project);
    }

    @Override
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intention.name.leave.initializer", (Object[])new Object[]{super.getText()});
        if (string == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intention.family.name.leave.initializer", (Object[])new Object[]{super.getFamilyName()});
        if (string == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        PsiElement element = this.getValidElementOrNull();
        if (element == null) {
            return false;
        }
        if (this.mySymbol != null && this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return false;
        }
        return OCRemoveDeclarationButInitializerIntentionAction.canLeaveInitializer(element) && OCRemoveDeclarationButInitializerIntentionAction.canTransformElement(element);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiElement myElement;
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement psiElement = myElement = this.mySymbol != null ? this.mySymbol.locateDefinition(project) : this.myElementPtr.getElement();
        if (myElement == null || !FileModificationService.getInstance().prepareFileForWrite(myElement.getContainingFile())) {
            return;
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getContextOfType((PsiElement)myElement, OCStatement.class, (boolean)false);
        PsiElement initializerStatement = OCRemoveDeclarationButInitializerIntentionAction.getInitializerStatement(myElement, project);
        if (parentStatement == null) {
            return;
        }
        OCRemoveDeclarationButInitializerIntentionAction.deleteUsages(myElement);
        if (!(parentStatement instanceof OCDeclarationStatement) || ((OCDeclarationStatement)parentStatement).getDeclaration().getDeclarators().size() == 1) {
            OCChangeUtil.replaceHandlingMacros(parentStatement, initializerStatement);
        } else {
            parentStatement.getParent().addAfter(initializerStatement, (PsiElement)parentStatement);
            OCChangeUtil.delete((PsiElement)(myElement instanceof OCDeclarator ? myElement : parentStatement));
        }
    }

    @NotNull
    private static PsiElement getInitializerStatement(@NotNull PsiElement element, @NotNull Project project) {
        OCExpressionStatement initializer;
        if (element == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(7);
        }
        if (element instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            initializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(element);
            OCChangeUtil.replaceHandlingMacros(initializer.getExpression(), assignmentExpression.getSourceExpression());
        } else if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
            OCType declaratorType = declarator.getType().resolve(resolveContext);
            initializer = declaratorType instanceof OCStructType ? OCRemoveDeclarationButInitializerIntentionAction.buildStructTypeInitializer(declarator, project) : OCRemoveDeclarationButInitializerIntentionAction.buildBuiltinTypeInitializer(declarator);
        } else if (element instanceof OCStructuredBindingDeclaration) {
            initializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(element);
            OCChangeUtil.replaceHandlingMacros(initializer.getExpression(), ((OCStructuredBindingDeclaration)element).getBindingDeclarator().getInitializer());
        } else {
            initializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(element);
        }
        OCElement oCElement = OCCodeInsightUtil.insideLoopHeader(element) || OCCodeInsightUtil.insideConditionalHeader(element) ? initializer.getExpression() : initializer;
        if (oCElement == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(8);
        }
        return oCElement;
    }

    @NotNull
    private static OCExpressionStatement buildStructTypeInitializer(@NotNull OCDeclarator declarator, @NotNull Project project) {
        OCExpression initializer;
        if (declarator == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(10);
        }
        if ((initializer = declarator.getInitializer()) == null) {
            initializer = declarator.getInitializerList();
        }
        if (initializer instanceof OCCompoundInitializer) {
            String declaratorTypeName = OCRemoveDeclarationButInitializerIntentionAction.getTypeName(declarator, project);
            String initializerText = declaratorTypeName + initializer.getText();
            OCExpressionStatement oCExpressionStatement = (OCExpressionStatement)OCElementFactory.statementFromText(initializerText, declarator);
            if (oCExpressionStatement == null) {
                OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(11);
            }
            return oCExpressionStatement;
        }
        if (initializer != null) {
            OCExpressionStatement resultInitializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(declarator);
            OCChangeUtil.replaceHandlingMacros(resultInitializer.getExpression(), initializer);
            OCExpressionStatement oCExpressionStatement = resultInitializer;
            if (oCExpressionStatement == null) {
                OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(12);
            }
            return oCExpressionStatement;
        }
        String declaratorTypeName = OCRemoveDeclarationButInitializerIntentionAction.getTypeName(declarator, project);
        OCArgumentList argumentList = declarator.getArgumentList();
        String ctorCallText = argumentList == null ? declaratorTypeName + "()" : "(" + declaratorTypeName + argumentList.getText() + ")";
        OCExpressionStatement oCExpressionStatement = (OCExpressionStatement)OCElementFactory.statementFromText(ctorCallText, declarator);
        if (oCExpressionStatement == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(13);
        }
        return oCExpressionStatement;
    }

    @NotNull
    private static OCExpressionStatement buildBuiltinTypeInitializer(@NotNull OCDeclarator declarator) {
        List<OCExpression> initializers;
        OCExpression initializer;
        if (declarator == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(14);
        }
        if ((initializer = (initializers = declarator.getInitializers()).get(0)) instanceof OCCompoundInitializer) {
            initializer = ((OCCompoundInitializer)initializer).getInitializerExpressions().get(0);
        }
        OCExpressionStatement result = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(declarator);
        OCChangeUtil.replaceHandlingMacros(result.getExpression(), initializer);
        OCExpressionStatement oCExpressionStatement = result;
        if (oCExpressionStatement == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(15);
        }
        return oCExpressionStatement;
    }

    @NotNull
    private static OCExpressionStatement getDefaultInitializer(@NotNull PsiElement context) {
        if (context == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(16);
        }
        OCExpressionStatement oCExpressionStatement = (OCExpressionStatement)OCElementFactory.statementFromText("1", context);
        if (oCExpressionStatement == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(17);
        }
        return oCExpressionStatement;
    }

    private static boolean canLeaveInitializer(@NotNull PsiElement element) {
        if (element == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(18);
        }
        if (element instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            OCExpression sourceExpression = assignmentExpression.getSourceExpression();
            return sourceExpression != null && OCCodeInsightUtil.hasSideEffects(sourceExpression);
        }
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
            OCType declaratorType = declarator.getType().resolve(resolveContext);
            if (declaratorType.isUnknown() || declaratorType instanceof OCArrayType) {
                return false;
            }
            List<OCExpression> initializers = declarator.getInitializers();
            if (declaratorType instanceof OCStructType) {
                if (!initializers.isEmpty()) {
                    return true;
                }
                OCFunctionSymbol ctorSymbol = OCResolveUtil.resolveCtorCall(initializers, (OCStructType)declaratorType, resolveContext, element);
                return ctorSymbol != null && !ctorSymbol.isDefault() && !(ctorSymbol instanceof OCCompilerGeneratedConstructorSymbol);
            }
            if (initializers.size() != 1) {
                return false;
            }
            OCExpression initializer = initializers.get(0);
            if (!OCCodeInsightUtil.hasSideEffects(initializer)) {
                return false;
            }
            if (!(initializer instanceof OCCompoundInitializer)) {
                return true;
            }
            OCCompoundInitializer compoundInitializer = (OCCompoundInitializer)initializer;
            return compoundInitializer.getInitializerExpressions().size() == 1;
        }
        if (element instanceof OCStructuredBindingDeclaration) {
            OCElement initializer = ((OCStructuredBindingDeclaration)element).getBindingDeclarator().getInitializer();
            return initializer instanceof OCExpression && OCCodeInsightUtil.hasSideEffects(initializer);
        }
        return false;
    }

    private static boolean canTransformElement(@NotNull PsiElement element) {
        if (element == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(19);
        }
        if (element instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            return !OCElementUtil.isPartOfMacroSubstitution(assignmentExpression);
        }
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCExpression initializer = declarator.getInitializerList();
            if (initializer == null) {
                initializer = declarator.getInitializer();
            }
            if (initializer instanceof OCCompoundInitializer) {
                return !OCElementUtil.isPartOfMacroSubstitution(initializer) && !OCElementUtil.isPartOfMacroSubstitution(initializer.getFirstChild());
            }
            OCArgumentList argumentList = declarator.getArgumentList();
            if (argumentList != null && OCElementUtil.isPartOfMacroSubstitution(argumentList)) {
                return false;
            }
            return !OCElementUtil.isPartOfMacroSubstitution(declarator);
        }
        if (element instanceof OCStructuredBindingDeclaration) {
            return !OCElementUtil.isPartOfMacroSubstitution(element);
        }
        return false;
    }

    private static String getTypeName(@NotNull OCDeclarator declarator, @NotNull Project project) {
        if (declarator == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(20);
        }
        if (project == null) {
            OCRemoveDeclarationButInitializerIntentionAction.$$$reportNull$$$0(21);
        }
        return declarator.getType().cloneWithoutCVQualifiers(project).getBestNameInContext(declarator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 11, 12, 13, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveDeclarationButInitializerIntentionAction";
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveDeclarationButInitializerIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializerStatement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStructTypeInitializer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBuiltinTypeInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerStatement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildStructTypeInitializer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildBuiltinTypeInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitializer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canLeaveInitializer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canTransformElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 11, 12, 13, 15, 17 -> new IllegalStateException(string);
        };
    }
}

