/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionTextEscaper;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCFloatLiteral;
import com.jetbrains.cidr.lang.util.OCIntegerLiteral;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringCodec;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionImpl
extends OCExpressionWithReferenceBase
implements OCLiteralExpression,
ContributedReferenceHost {
    private static final Logger LOG = Logger.getInstance(OCLiteralExpressionImpl.class);
    private static final String CIDR_INJECTION_HANDLER_CLASS_NAME = "com.jetbrains.cidr.lang.OCMultiLiteralTempInjector";
    private static final String TEMPORARY_INJECTOR_CLASS_NAME = "org.intellij.plugins.intelliLang.inject.TemporaryPlacesInjector";

    private boolean isCidrInjectionPluginEnabled() {
        for (MultiHostInjector injector : MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getPoint((AreaInstance)this.getProject()).getExtensionList()) {
            String className = injector.getClass().getName();
            if (className.equals(CIDR_INJECTION_HANDLER_CLASS_NAME)) {
                return true;
            }
            if (!className.equals(TEMPORARY_INJECTOR_CLASS_NAME)) continue;
            return false;
        }
        return false;
    }

    public boolean isValidHost() {
        if (!this.isValid()) {
            return false;
        }
        if (!this.isCidrInjectionPluginEnabled()) {
            return false;
        }
        ASTNode[] children = this.getNode().getChildren(OCLexerTokenTypes.ALL_STRINGS);
        if (children.length == 0) {
            return false;
        }
        for (ASTNode l : children) {
            if (!(l instanceof OCMacroForeignLeafElement)) continue;
            return false;
        }
        return true;
    }

    public OCLiteralExpression updateText(@NotNull String text) {
        if (text == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return (OCLiteralExpression)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new OCLiteralExpressionTextEscaper(this);
    }

    @NotNull
    public CidrStringCodec<OCStringLiteral> getStringCodec() {
        OCStringCodec oCStringCodec = OCStringCodec.STRING_CODEC;
        if (oCStringCodec == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCStringCodec;
    }

    @NotNull
    private String getLiteralText(@NotNull LiteralPresentation presentation) {
        ASTNode firstChild;
        IElementType tt;
        OCLiteral literal;
        if (presentation == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        if ((literal = OCLiteralExpressionImpl.getLiteral(tt = (firstChild = this.getNode().getFirstChildNode()).getElementType(), this.getRawLiteralTextElements())) instanceof OCStringLiteral) {
            OCStringLiteral stringLiteral = (OCStringLiteral)literal;
            String string = stringLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (literal instanceof OCCharLiteral) {
            OCCharLiteral charLiteral = (OCCharLiteral)literal;
            String string = charLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.getRawLiteralText();
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static OCLiteral getLiteral(@NotNull IElementType tt, @NotNull List<String> childTextElements) {
        if (tt == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if (childTextElements == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        if (tt == OCLexerTokenTypes.AT || OCLexerTokenTypes.ALL_STRINGS.contains(tt)) {
            if (childTextElements.isEmpty()) {
                return OCStringLiteral.BAD_LITERAL;
            }
            if (childTextElements.size() == 1) {
                return OCStringLiteralUtil.parseStringLiteral(childTextElements.get(0));
            }
            int elementsSize = childTextElements.size();
            OCStringLiteral[] stringLiterals = new OCStringLiteral[elementsSize];
            for (int i = 0; i < elementsSize; ++i) {
                stringLiterals[i] = OCStringLiteralUtil.parseStringLiteral(childTextElements.get(i));
            }
            return OCStringLiteralUtil.concatStrings(stringLiterals);
        }
        String childText = StringUtil.join(childTextElements, (String)"");
        if (tt == OCLexerTokenTypes.CHARACTER_LITERAL) {
            return OCStringLiteralUtil.parseCharLiteral(childText);
        }
        if (tt == OCLexerTokenTypes.INTEGER_LITERAL) {
            return new OCIntegerLiteral(childText);
        }
        if (tt == OCLexerTokenTypes.FLOAT_LITERAL) {
            return new OCFloatLiteral(childText);
        }
        return null;
    }

    public OCLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        visitor.visitLiteralExpression(this);
    }

    @Override
    @NotNull
    public String getUnescapedLiteralText() {
        return this.getLiteralText(LiteralPresentation.TEXT_UNESCAPED);
    }

    @Override
    @NotNull
    public String getEscapedLiteralText() {
        return this.getLiteralText(LiteralPresentation.TEXT_ESCAPED);
    }

    @Override
    @NotNull
    public String getRawLiteralText() {
        String string = StringUtil.join(this.getRawLiteralTextElements(), (String)"");
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getContentRangeInElement() {
        int prefixLength;
        List<ASTNode> nodes = this.findStringLiteralNodes();
        PsiElement literal = nodes.isEmpty() ? null : nodes.get(0).getPsi();
        int n = prefixLength = literal instanceof OCStringLiteral ? ((OCStringLiteral)literal).prefix.prefix.length() : 1;
        if (literal != null && literal.getTextLength() >= prefixLength + 1) {
            int start = literal.getStartOffsetInParent();
            return new TextRange(start + prefixLength, start + literal.getTextLength() - 1);
        }
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public void setContent(@NotNull String newContent) {
        if (newContent == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        FileSymbolTablesCache.getInstance(this.getProject()).scheduleReparseFile((OCFile)this.getContainingFile());
        String escaped = EscapeUtil.escapeStringExceptUnicode((String)newContent);
        PsiElement newElement = Objects.requireNonNull(OCElementFactory.expressionFromText("@\"" + escaped + "\"", this)).getLastChild();
        OCChangeUtil.replaceHandlingMacros(this.getLastChild(), newElement);
    }

    @NotNull
    public List<ASTNode> findStringLiteralNodes() {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCLexerTokenTypes.ALL_STRINGS.contains(child.getElementType())) continue;
            nodes.add(child);
        }
        ArrayList<ASTNode> arrayList = nodes;
        if (arrayList == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private List<String> getRawLiteralTextElements() {
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        if (tt == OCLexerTokenTypes.AT || OCLexerTokenTypes.ALL_STRINGS.contains(tt)) {
            List list = ContainerUtil.map(this.findStringLiteralNodes(), node -> node.getText());
            if (list == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<String> list = Collections.singletonList(firstChild.getText());
        if (list == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReferenceService service = PsiReferenceService.getService();
        PsiReference[] ret = null;
        if (service != null) {
            ret = service.getContributedReferences((PsiElement)this);
        }
        if (ret == null) {
            ret = PsiReference.EMPTY_ARRAY;
            LOG.assertTrue(ret.length == 0);
        }
        if (ret == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(15);
        }
        return ret;
    }

    @Nullable
    public PsiReference createReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCMacroRange macroRange;
        if (context == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(16);
        }
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        String literalText = this.getRawLiteralText();
        if (tt == OCLexerTokenTypes.INTEGER_LITERAL && ("0".equals(literalText) || "1".equals(literalText)) && (macroRange = OCElementUtil.getRangeInMacroCall(this)) != null) {
            String macroText = macroRange.getMacroCall().getText();
            if (macroText.equals("TRUE") || macroText.equals("FALSE") || macroText.equals("YES") || macroText.equals("NO")) {
                OCIntType oCIntType = OCIntType.BOOL;
                if (oCIntType == null) {
                    OCLiteralExpressionImpl.$$$reportNull$$$0(17);
                }
                return oCIntType;
            }
            if (macroText.equals("true") || macroText.equals("false")) {
                OCIntType oCIntType = OCIntType.BOOL_NATIVE;
                if (oCIntType == null) {
                    OCLiteralExpressionImpl.$$$reportNull$$$0(18);
                }
                return oCIntType;
            }
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSArray"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(19);
            }
            return oCPointerType;
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSDictionary"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(20);
            }
            return oCPointerType;
        }
        if (this.isNSNumberLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSNumber"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(21);
            }
            return oCPointerType;
        }
        if (this.isNSStringLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSString"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(22);
            }
            return oCPointerType;
        }
        OCType oCType = OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, this.getContainingFile(), OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements()), this.getProject());
        if (oCType == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(23);
        }
        return oCType;
    }

    public static OCType getLiteralType(IElementType tt, List<String> childTextElements, @NotNull PsiFile file) {
        if (file == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(24);
        }
        return OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, file, OCLiteralExpressionImpl.getLiteral(tt, childTextElements), file.getProject());
    }

    private static OCType getLiteralTypeFromTT(IElementType tt, @Nullable PsiFile file, @Nullable OCLiteral literal, @NotNull Project project) {
        if (project == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(25);
        }
        if (tt == OCLexerTokenTypes.TRUE_CPP_KEYWORD || tt == OCLexerTokenTypes.FALSE_CPP_KEYWORD) {
            return OCIntType.BOOL_NATIVE;
        }
        if (tt == OCLexerTokenTypes.NULL_CPP_KEYWORD) {
            return OCPointerType.NULLPTR_T;
        }
        if (literal != null) {
            return literal.getType(file, OCCodeInsightUtil.isInPlainOldC((PsiElement)file), project);
        }
        if (tt == OCLexerTokenTypes.WRONG_INTEGER_LITERAL) {
            return OCIntType.INT;
        }
        if (tt == OCLexerTokenTypes.WRONG_FLOAT_LITERAL) {
            return OCRealType.FLOAT;
        }
        if (tt == OCLexerTokenTypes.TEMPLATE_START_MARK) {
            return OCUnknownType.INSTANCE;
        }
        if (tt == OCLexerTokenTypes.FAKE_FALSE || tt == OCLexerTokenTypes.FAKE_TRUE) {
            return OCIntType.INT;
        }
        if (tt == OCLexerTokenTypes.__NULL_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isNSNumberLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCLexerTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCLexerTokenTypes.INTEGER_LITERAL || type == OCLexerTokenTypes.FLOAT_LITERAL || type == OCLexerTokenTypes.CHARACTER_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isNSStringLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCLexerTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCLexerTokenTypes.STRING_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return !this.findStringLiteralNodes().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 10, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTextElements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringCodec";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawLiteralText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findStringLiteralNodes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawLiteralTextElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLiteral";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralTypeFromTT";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 10, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static enum LiteralPresentation {
        TEXT_ESCAPED,
        TEXT_UNESCAPED;

    }
}

