/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapInitialSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPackBuilder;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationStorage;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleSeriailzationUtilKt;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.BrokenModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapPackImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationSession;", "", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;Lcom/intellij/openapi/project/Project;)V", "buildSerializationPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack$ProjectPack;", "buildInitialSerializationPacks", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialSerializationPack;", "cachedPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "cleanupBrokenModuleMaps", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPack;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nModuleMapSerializationSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapSerializationSession.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n2746#2,3:53\n774#2:56\n865#2,2:57\n*S KotlinDebug\n*F\n+ 1 ModuleMapSerializationSession.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationSession\n*L\n45#1:53,3\n47#1:56\n47#1:57,2\n*E\n"})
public final class ModuleMapSerializationSession {
    @NotNull
    private final ModuleMapSerializationService serializationService;
    @NotNull
    private final Project project;

    public ModuleMapSerializationSession(@NotNull ModuleMapSerializationService serializationService, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)serializationService, (String)"serializationService");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.serializationService = serializationService;
        this.project = project;
    }

    @NotNull
    public final List<ModuleMapSerializationPack.ProjectPack> buildSerializationPacks() {
        Collection<ModuleMapPackWithRoot> cachedPacks = ModuleMapCache.Companion.getInstance(this.project).getAll();
        ModuleMapLog.LOG.info("Saved " + ModuleSeriailzationUtilKt.flatSize(cachedPacks) + " module maps in " + cachedPacks.size() + " packs");
        List<ModuleMapInitialSerializationPack> initialSerializationPacks = this.buildInitialSerializationPacks(cachedPacks);
        List<ModuleMapSerializationPack.ProjectPack> serializationPacks = new ModuleMapSerializationPackBuilder().buildSerializationPacks(initialSerializationPacks);
        return serializationPacks;
    }

    private final List<ModuleMapInitialSerializationPack> buildInitialSerializationPacks(Collection<ModuleMapPackWithRoot> cachedPacks) {
        return (List)ActionsKt.runReadAction(() -> ModuleMapSerializationSession.buildInitialSerializationPacks$lambda$3(cachedPacks, this));
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleMapPack cleanupBrokenModuleMaps(ModuleMapPack $this$cleanupBrokenModuleMaps) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List<ModuleMap> projectModulesMaps;
        block5: {
            projectModulesMaps = $this$cleanupBrokenModuleMaps.getProjectModuleMapsUnsafe();
            Iterable $this$none$iv = projectModulesMaps;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    ModuleMap it = (ModuleMap)element$iv2;
                    boolean bl2 = false;
                    if (!(it instanceof BrokenModuleMap)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return $this$cleanupBrokenModuleMaps;
        }
        Iterable $this$filter$iv = projectModulesMaps;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleMap it = (ModuleMap)element$iv$iv;
            boolean bl3 = false;
            if (!(!(it instanceof BrokenModuleMap))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        return new ModuleMapPackImpl($this$cleanupBrokenModuleMaps.getGlobalMap(), $this$cleanupBrokenModuleMaps.getBundledModuleMapsUnsafe(), filtered);
    }

    private static final boolean buildInitialSerializationPacks$lambda$3$lambda$0(ModuleMapPackWithRoot pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        return pack.getModuleMapRoot().getRoot().isValid();
    }

    private static final ModuleMapInitialSerializationPack buildInitialSerializationPacks$lambda$3$lambda$1(ModuleMapSerializationSession this$0, ModuleMapPackWithRoot pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        ModuleMapSerializationInfo info = this$0.serializationService.createSerializationInfo(pack.getModuleMapRoot());
        ModuleMapPack moduleMapPack = this$0.cleanupBrokenModuleMaps(pack.getModuleMapPack());
        return new ModuleMapInitialSerializationPack(moduleMapPack, info);
    }

    private static final boolean buildInitialSerializationPacks$lambda$3$lambda$2(ModuleMapInitialSerializationPack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getInfo().getStorage(), (Object)ModuleMapSerializationStorage.None.INSTANCE);
    }

    private static final List buildInitialSerializationPacks$lambda$3(Collection $cachedPacks, ModuleMapSerializationSession this$0) {
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$cachedPacks), ModuleMapSerializationSession::buildInitialSerializationPacks$lambda$3$lambda$0), arg_0 -> ModuleMapSerializationSession.buildInitialSerializationPacks$lambda$3$lambda$1(this$0, arg_0)), ModuleMapSerializationSession::buildInitialSerializationPacks$lambda$3$lambda$2));
    }
}

