/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludeImportVisitor;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/Visitor;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/IncludeImportVisitor;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "configCache", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "importMap", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "", "result", "", "", "getResult", "()Ljava/util/Map;", "visitInclude", "", "include", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol;", "visitImport", "import", "Lcom/jetbrains/cidr/lang/symbols/objc/OCModuleImportSymbol;", "processModule", "targetModule", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nModuleMapDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapDependencies.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/Visitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,62:1\n382#2,7:63\n*S KotlinDebug\n*F\n+ 1 ModuleMapDependencies.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/Visitor\n*L\n58#1:63,7\n*E\n"})
final class Visitor
implements IncludeImportVisitor {
    @NotNull
    private final OCResolveConfiguration configuration;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final ModuleMapManager.Cache configCache;
    @NotNull
    private final Map<ModuleMapSymbol, Set<ModuleMapSymbol>> importMap;

    public Visitor(@NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        Project project = this.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.moduleMapManager = ModuleMapManager.Companion.getInstance(project);
        this.configCache = this.moduleMapManager.cacheFor(this.configuration);
        this.importMap = new LinkedHashMap();
    }

    @NotNull
    public final Map<ModuleMapSymbol, Set<ModuleMapSymbol>> getResult() {
        return this.importMap;
    }

    @Override
    public void visitInclude(@NotNull OCIncludeSymbol include) {
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        VirtualFile virtualFile = include.getTargetFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile targetFile = virtualFile;
        ModuleMapSymbol moduleMapSymbol = this.moduleMapManager.findModule(targetFile, this.configuration);
        if (moduleMapSymbol == null) {
            return;
        }
        ModuleMapSymbol importedModule = moduleMapSymbol;
        this.processModule(importedModule, include);
    }

    @Override
    public void visitImport(@NotNull OCModuleImportSymbol oCModuleImportSymbol) {
        Intrinsics.checkNotNullParameter((Object)oCModuleImportSymbol, (String)"import");
        QualifiedName qualifiedName = oCModuleImportSymbol.getModuleName();
        if (qualifiedName == null) {
            return;
        }
        QualifiedName moduleName = qualifiedName;
        ModuleMapSymbol moduleMapSymbol = this.configCache.findModule(moduleName);
        if (moduleMapSymbol == null) {
            return;
        }
        ModuleMapSymbol importedModule = moduleMapSymbol;
        this.processModule(importedModule, oCModuleImportSymbol);
    }

    /*
     * WARNING - void declaration
     */
    private final void processModule(ModuleMapSymbol targetModule, OCSymbol symbol) {
        Object object;
        void $this$getOrPut$iv;
        VirtualFile virtualFile = symbol.getContainingFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        ProgressManager.checkCanceled();
        ModuleMapSymbol moduleMapSymbol = this.moduleMapManager.findModule(file, this.configuration);
        if (moduleMapSymbol == null) {
            return;
        }
        ModuleMapSymbol sourceModule = moduleMapSymbol;
        Map<ModuleMapSymbol, Set<ModuleMapSymbol>> map2 = this.importMap;
        ModuleMapSymbol key$iv = sourceModule;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set importsForModule = (Set)object;
        importsForModule.add(targetModule);
    }
}

