/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.light.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.jetbrains.cidr.lang.LanguageUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLightFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider {
    private static final Set<Language> ourLanguages = Set.of(LanguageUtils.getInstance().getLightLanguage(), LanguageUtils.getInstance().getSlowLanguage());

    public OCLightFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = ourLanguages;
        if (set == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = LanguageUtils.getInstance().getLightLanguage();
        if (language == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language language) {
        if (language == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(4);
        }
        FileType type = this.getFileType();
        return (PsiFileImpl)this.createFile(this.getVirtualFile(), type, language);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(5);
        }
        if (!this.hasLanguage(lang)) {
            return null;
        }
        Project project = this.getManager().getProject();
        LanguageUtils languageUtils = LanguageUtils.getInstance();
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiPlainTextFileImpl((FileViewProvider)this);
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parser == null) {
            return null;
        }
        return parser.createFile((FileViewProvider)this);
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return OCLightFileViewProvider.findElementAt((PsiElement)this.getPsi(LanguageUtils.getInstance().getLightLanguage()), (int)offset);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(6);
        }
        return new OCLightFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/light/psi/OCLightFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/light/psi/OCLightFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFileImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

