/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCHeaderGuardDetector {
    private static final Key<Info> CACHE = Key.create((String)"OCHeaderGuardDetector cache");

    @Nullable
    public static String getHeaderGuard(@NotNull Project project, @NotNull VirtualFile file) {
        Info result;
        if (project == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(1);
        }
        if ((result = (Info)CACHE.get((UserDataHolder)file)) == null || !result.stamp.isUpToDate(project, file)) {
            FileContentSnapshot snapshot = FileContentSnapshot.get(file, project);
            CharSequence text = snapshot.getText();
            String guard = OCHeaderGuardDetector.detectHeaderGuard(text);
            result = new Info(guard, snapshot.getStamp());
            CACHE.set((UserDataHolder)file, (Object)result);
        }
        return result.guard;
    }

    @Nullable
    public static String detectHeaderGuard(@NotNull CharSequence text) {
        if (text == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(2);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(text);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType it = lexer.getTokenType();
        if (OCTokenTypes.IFNDEF_DIRECTIVE != it) {
            return null;
        }
        lexer.advance();
        IElementType ct = lexer.getTokenType();
        if (OCTokenTypes.DIRECTIVE_CONTENT != ct) {
            return null;
        }
        String content = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        String headerGuard = OCHeaderGuardDetector.readHeaderGuard(content, OCLexerSettings.forPreprocessor().build());
        if (headerGuard == null) {
            return null;
        }
        int directiveDepth = 1;
        while (directiveDepth > 0) {
            IElementType tt = lexer.getTokenType();
            if (tt == null) {
                return null;
            }
            if (OCTokenTypes.IF_DIRECTIVES.contains(tt)) {
                ++directiveDepth;
            } else if (OCTokenTypes.ENDIF_DIRECTIVE == tt) {
                --directiveDepth;
            } else if (OCTokenTypes.END_IF_DIRECTIVES.contains(tt) && directiveDepth == 1) {
                return null;
            }
            lexer.advance();
        }
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() == null ? headerGuard : null;
    }

    private static void skipWhitespacesAndDirectiveBodies(OCLexer lexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType()) || OCParsing.isEndOfDirective(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    @Nullable
    private static String readHeaderGuard(String content, CidrLexerSettings settings) {
        OCLexer lexer = new OCLexer(settings);
        lexer.start((CharSequence)content);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType tt = lexer.getTokenType();
        if (OCTokenTypes.IDENTIFIER != tt) {
            return null;
        }
        String headerGuard = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() != null ? null : headerGuard;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/lexer/OCHeaderGuardDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeaderGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectHeaderGuard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Info {
        @Nullable
        final String guard;
        final FileContentSnapshot.Stamp stamp;

        Info(@Nullable String guard, @NotNull FileContentSnapshot.Stamp stamp) {
            if (stamp == null) {
                Info.$$$reportNull$$$0(0);
            }
            this.guard = guard;
            this.stamp = stamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamp", "com/jetbrains/cidr/lang/lexer/OCHeaderGuardDetector$Info", "<init>"));
        }
    }
}

