/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u000bH\u0014J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0094\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionQuickFix;", "Lcom/jetbrains/cidr/lang/quickfixes/OCSymbolQuickFix;", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "symbol", "inline", "", "context", "Lcom/jetbrains/cidr/lang/symbols/OCCompilationContext;", "<init>", "(Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;ZLcom/jetbrains/cidr/lang/symbols/OCCompilationContext;)V", "myText", "", "getTextInternal", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "getFamilyName", "intellij.c.core"})
public final class OCGenerateDefinitionQuickFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean inline;
    @IntentionName
    @NotNull
    private final String myText;

    public OCGenerateDefinitionQuickFix(@NotNull OCFunctionSymbol symbol, boolean inline, @NotNull OCCompilationContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context.getProject(), (OCSymbol)symbol);
        this.inline = inline;
        if (this.inline) {
            Object[] objectArray = new Object[]{((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context)};
            String string2 = OCBundle.message("generate.definitions.quickfix.inlineText", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context)};
            String string3 = OCBundle.message("generate.definitions.quickfix.outsideText", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        this.myText = string;
    }

    @Override
    @NotNull
    protected String getTextInternal() {
        return this.myText;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        OCFunctionDeclaration oCFunctionDeclaration = ((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project);
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = oCFunctionDeclaration != null ? (OCSymbolWithQualifiedName)oCFunctionDeclaration.getSymbol() : null;
        OCFunctionSymbol oCFunctionSymbol = oCSymbolWithQualifiedName instanceof OCFunctionSymbol ? (OCFunctionSymbol)oCSymbolWithQualifiedName : null;
        if (oCFunctionSymbol == null) {
            return;
        }
        OCFunctionSymbol symbol = oCFunctionSymbol;
        PsiFile psiFile = symbol.getContainingPsiFile(project);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        OCCppDefinitionsUtil.InlinePolicy policy = OCCppDefinitionsUtil.InlinePolicy.get(this.inline);
        Intrinsics.checkNotNull((Object)((Object)policy));
        new OCGenerateDefinitionActionHandler(project, file, symbol, policy, false).invoke();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

