/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.PlainTextLineSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class OCSelectorWordSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(0);
        }
        return OCSelectorWordSelectioner.isCustomSelectionContext(e);
    }

    public static boolean isCustomSelectionContext(PsiElement e) {
        IElementType type = OCElementUtil.getElementType(e);
        return OCSelectorWordSelectioner.selector(e) != null || type == OCLexerTokenTypes.HEADER_PATH_LITERAL || type == OCLexerTokenTypes.EOL_ESCAPE || type == OCLexerTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT || OCSelectorWordSelectioner.isDirective(e);
    }

    private static boolean isDirective(PsiElement e) {
        return OCElementTypes.DIRECTIVES.contains(OCElementUtil.getElementType(e));
    }

    @Contract(value="null -> null")
    private static OCSelectorExpression selector(PsiElement e) {
        return (OCSelectorExpression)PsiTreeUtil.getParentOfType((PsiElement)e, OCSelectorExpression.class);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        OCSelectorExpression selector;
        if (e == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(3);
        }
        if ((selector = OCSelectorWordSelectioner.selector(e)) != null) {
            return Collections.singletonList(selector.getSelectorRange().shiftRight(selector.getTextRange().getStartOffset()));
        }
        if (OCElementUtil.getElementType(e) == OCLexerTokenTypes.HEADER_PATH_LITERAL) {
            String text = e.getText();
            int nonws = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            text = text.substring(nonws);
            ArrayList<TextRange> answer = new ArrayList<TextRange>();
            TextRange baseRange = TextRange.from((int)(e.getTextRange().getStartOffset() + nonws), (int)(e.getTextLength() - nonws));
            answer.add(baseRange);
            SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, answer);
            if (baseRange.getLength() > 1 && text.startsWith("\"") && text.endsWith("\"") || text.startsWith("<") && text.endsWith(">")) {
                answer.add(baseRange.shiftRight(1).grown(-2));
            }
            return answer;
        }
        if (OCSelectorWordSelectioner.isDirective(e)) {
            PsiElement directive = e;
            PsiElement directiveId = null;
            OCMacroParameterList directiveParams = null;
            if (directive instanceof PsiNameIdentifierOwner) {
                directiveId = ((PsiNameIdentifierOwner)directive).getNameIdentifier();
            }
            if (directive instanceof OCDefineDirective) {
                directiveParams = ((OCDefineDirective)directive).getMacroParameters();
            }
            TextRange directiveRange = directive.getTextRange();
            List<TextRange> ranges = OCElementUtil.getElementType(e) != OCElementTypes.DEFINED_DIRECTIVE ? OCSelectorWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)directiveRange, (boolean)false) : new ArrayList();
            int start = directiveRange.getStartOffset();
            int end = CharArrayUtil.shiftForward((CharSequence)editorText, (int)directiveRange.getEndOffset(), (String)" \t");
            ranges.add(TextRange.create((int)start, (int)end));
            if (directiveId != null) {
                int startId = directiveId.getTextRange().getStartOffset();
                ranges.add(TextRange.create((int)startId, (int)directiveId.getTextRange().getEndOffset()));
                ranges.add(TextRange.create((int)startId, (int)end));
                if (directiveParams != null) {
                    ranges.add(TextRange.create((int)startId, (int)directiveParams.getTextRange().getEndOffset()));
                    int paramEnd = CharArrayUtil.shiftForward((CharSequence)editorText, (int)directiveParams.getTextRange().getEndOffset(), (String)" \t");
                    ranges.add(TextRange.create((int)paramEnd, (int)end));
                }
            }
            SelectWordUtil.addWordOrLexemeSelection((boolean)editor.getSettings().isCamelWords(), (Editor)editor, (int)cursorOffset, ranges);
            return ranges;
        }
        if (OCElementUtil.getElementType(e) == OCLexerTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            return PlainTextLineSelectioner.selectPlainTextLine((PsiElement)e, (CharSequence)editorText, (int)cursorOffset);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/selectWord/OCSelectorWordSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

