/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.TemplateParameterTraversalPolicy;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTemplateParameterTraversalPolicy
implements TemplateParameterTraversalPolicy {
    private static final int TEMPLATE_SEARCH_INTERVAL = 1024;

    @NotNull
    private static List<TextRange> calcNavigationRanges(Editor editor, PsiFile file, boolean commitDocumentIfNeeded) {
        if (LookupManager.getActiveLookup((Editor)editor) != null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(1);
            }
            return list;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        TextRange rangeToFindTemplatesIn = TextRange.create((int)Math.max(0, offset - 1024), (int)Math.min(document.getTextLength(), offset + 1024));
        List<TextRange> templateRanges = OCTemplateParameterTraversalPolicy.calcTemplateRanges(editor, rangeToFindTemplatesIn);
        if (!templateRanges.isEmpty()) {
            List<TextRange> list = templateRanges;
            if (list == null) {
                OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (OCLanguageKindCalculator.looksLikeObjC(virtualFile)) {
            int linefeed;
            PsiElement node;
            if (commitDocumentIfNeeded) {
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            }
            if ((node = file.findElementAt(offset)) == null) {
                List<TextRange> list = Collections.emptyList();
                if (list == null) {
                    OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (node instanceof PsiWhiteSpace && (linefeed = node.getText().indexOf(10)) >= 0 && offset > node.getTextRange().getStartOffset() + linefeed) {
                List<TextRange> list = Collections.emptyList();
                if (list == null) {
                    OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(4);
                }
                return list;
            }
            return OCTemplateParameterTraversalPolicy.calcSendMessageRanges(offset, node);
        }
        List<TextRange> list = Collections.emptyList();
        if (list == null) {
            OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<TextRange> calcSendMessageRanges(int offset, PsiElement node) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        OCSendMessageExpression call = OCTemplateParameterTraversalPolicy.findSendMessageParentAtOffset(offset, node);
        while (call != null) {
            answer.addAll(OCTemplateParameterTraversalPolicy.calcSendMessageRanges(call));
            call = OCTemplateParameterTraversalPolicy.findSendMessageParentAtOffset(offset, call);
        }
        answer.sort(Comparator.comparingInt(TextRange::getStartOffset));
        ArrayList<TextRange> arrayList = answer;
        if (arrayList == null) {
            OCTemplateParameterTraversalPolicy.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static List<TextRange> calcTemplateRanges(Editor editor, TextRange inRange) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(inRange.getStartOffset());
        int start = -1;
        while (!iterator2.atEnd() && iterator2.getStart() < inRange.getEndOffset()) {
            IElementType tt = iterator2.getTokenType();
            if (tt == OCLexerTokenTypes.TEMPLATE_START_MARK) {
                start = iterator2.getStart();
            }
            if (tt == OCLexerTokenTypes.TEMPLATE_STOP_MARK && start >= 0) {
                answer.add(TextRange.create((int)start, (int)iterator2.getEnd()));
                start = -1;
            }
            iterator2.advance();
        }
        return answer;
    }

    private static List<TextRange> calcSendMessageRanges(OCSendMessageExpression expr) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        for (OCMessageArgument argument : expr.getArguments()) {
            OCArgumentSelector selector = argument.getArgumentSelector();
            OCExpression param = argument.getArgumentExpression();
            if (param == null) continue;
            if (param instanceof OCLiteralExpression && "<#".equals(param.getFirstChild().getText())) {
                answer.add(param.getRangeWithMacros());
                continue;
            }
            answer.add(new TextRange(selector.getTextRange().getEndOffset(), param.getRangeWithMacros().getEndOffset()));
        }
        return answer;
    }

    @Nullable
    private static OCSendMessageExpression findSendMessageParentAtOffset(int offset, PsiElement leaf) {
        PsiElement last;
        OCSendMessageExpression expr = (OCSendMessageExpression)PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCSendMessageExpression.class});
        if (expr == null) {
            return null;
        }
        List<OCMessageArgument> args = expr.getArguments();
        PsiElement psiElement = last = !args.isEmpty() ? (PsiElement)args.get(args.size() - 1) : null;
        if (last != null && offset >= last.getTextRange().getEndOffset()) {
            return OCTemplateParameterTraversalPolicy.findSendMessageParentAtOffset(offset, expr);
        }
        if (offset == expr.getTextRange().getStartOffset()) {
            return OCTemplateParameterTraversalPolicy.findSendMessageParentAtOffset(offset, expr);
        }
        return expr;
    }

    public boolean isValidForFile(Editor editor, PsiFile file) {
        return file instanceof OCFile && !OCTemplateParameterTraversalPolicy.calcNavigationRanges(editor, file, false).isEmpty();
    }

    private static TextRange chooseRange(int offset, List<TextRange> ranges, boolean next) {
        if (next) {
            for (TextRange range : ranges) {
                if (range.getStartOffset() <= offset) continue;
                return range;
            }
        } else {
            Collections.reverse(ranges);
            for (TextRange range : ranges) {
                if (range.getEndOffset() >= offset) continue;
                return range;
            }
        }
        return ranges.get(0);
    }

    public void invoke(Editor editor, PsiFile file, boolean next) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        List<TextRange> ranges = OCTemplateParameterTraversalPolicy.calcNavigationRanges(editor, file, true);
        if (ranges.isEmpty()) {
            return;
        }
        TextRange range = OCTemplateParameterTraversalPolicy.chooseRange(editor.getCaretModel().getOffset(), ranges, next);
        int end = range.getEndOffset();
        int start = range.getStartOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        start = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (String)" \t\n");
        end = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(end - 1), (String)" \t\n") + 1;
        editor.getCaretModel().moveToOffset(end);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getCaretModel().moveToOffset(start);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (chars.charAt(start) == '<' && chars.charAt(start + 1) == '#') {
            editor.getSelectionModel().setSelection(start, end);
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/lang/editor/completion/OCTemplateParameterTraversalPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNavigationRanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSendMessageRanges";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

