/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.hmap.OCHeaderMap;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefaultAutoImportHelper
implements OCAutoImportHelper {
    @Override
    public boolean supports(@NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        if (rootAndConfiguration == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean processPathSpecificationToInclude(@NotNull Project project, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull OCResolveRootAndConfiguration rootAndConfig, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        VirtualFile targetFileParent;
        if (project == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(1);
        }
        if (fileToImport == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(2);
        }
        if (rootAndConfig == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = targetFileParent = targetFile != null ? targetFile.getParent() : null;
        if (targetFileParent != null && targetFileParent.equals(fileToImport.getParent()) && !processor2.process((Object)new OCAutoImportHelper.ImportSpecification(fileToImport.getName(), OCAutoImportHelper.ImportSpecification.Kind.PROJECT_HEADER))) {
            return false;
        }
        boolean isUnderSearchPaths = false;
        OCResolveConfiguration config = rootAndConfig.getConfiguration();
        HeadersSearchRoots searchRoots = config != null ? config.getCompilerSettings(rootAndConfig.getKind(), rootAndConfig.getRootFile()).getHeadersSearchRoots() : HeadersSearchRoots.EMPTY;
        for (HeadersSearchRoot root : searchRoots.getAllRoots()) {
            VirtualFile rootBase = root.getVirtualFile();
            if (root instanceof HeaderMapRoot) {
                if (OCDefaultAutoImportHelper.processHeaderMapRoot(project, fileToImport, (HeaderMapRoot)root, rootAndConfig, processor2)) continue;
                return false;
            }
            if (!(root instanceof SurrogateSearchRoot)) {
                if (rootBase == null || !VfsUtilCore.isAncestor((VirtualFile)rootBase, (VirtualFile)fileToImport, (boolean)true)) continue;
                isUnderSearchPaths = true;
                if (root instanceof IncludedHeadersRoot) {
                    boolean recursive = ((IncludedHeadersRoot)root).isRecursive();
                    boolean preferQuotes = ((IncludedHeadersRoot)root).preferQuotes();
                    if (OCDefaultAutoImportHelper.processIncludedHeadersRoot(fileToImport, root.getVirtualFile(), recursive, root.getKind(), preferQuotes, processor2)) continue;
                    return false;
                }
            }
            if (!(root instanceof FrameworksSearchRoot)) continue;
            FrameworksSearchRoot frameworksRoot = (FrameworksSearchRoot)root;
            Ref found = new Ref();
            frameworksRoot.processChildren(element -> {
                if (!(element instanceof AppleFramework)) {
                    return true;
                }
                if (((AppleFramework)element).containsHeader(fileToImport)) {
                    found.set((Object)((AppleFramework)element));
                    return false;
                }
                return true;
            });
            AppleFramework framework = (AppleFramework)found.get();
            if (framework == null) continue;
            VirtualFile frameworkHeader = ModuleMapUtil.getMainFile(framework);
            if (frameworkHeader == null) {
                frameworkHeader = fileToImport;
            }
            if (OCDefaultAutoImportHelper.processImportSpecification(framework.getName() + "/" + frameworkHeader.getName(), HeadersSearchPath.Kind.FRAMEWORK, processor2)) continue;
            return false;
        }
        if (!isUnderSearchPaths) {
            String relativePath;
            String string = relativePath = targetFileParent != null ? FileUtil.getRelativePath((String)targetFileParent.getPath(), (String)fileToImport.getPath(), (char)'/') : null;
            if (relativePath != null && !processor2.process((Object)new OCAutoImportHelper.ImportSpecification(relativePath, OCAutoImportHelper.ImportSpecification.Kind.fromHeaderSearchPathKind(HeadersSearchPath.Kind.USER), false, false))) {
                return false;
            }
        }
        return true;
    }

    public static boolean processHeaderMapRoot(@NotNull Project project, @NotNull VirtualFile fileToImport, @NotNull HeaderMapRoot root, @NotNull OCResolveRootAndConfiguration rootAndConfig, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor2) {
        OCHeaderMap headerMap;
        if (project == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(5);
        }
        if (fileToImport == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(6);
        }
        if (root == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(7);
        }
        if (rootAndConfig == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(9);
        }
        if ((headerMap = OCHeaderMapManager.getInstance(project).getHeaderMap(root)) == null) {
            return true;
        }
        for (Map.Entry mapping : headerMap.entrySet()) {
            if (!FileUtil.namesEqual((String)fileToImport.getName(), (String)PathUtil.getFileName((String)((String)mapping.getValue())))) continue;
            OCIncludeSymbol.IncludePath includePath = new OCIncludeSymbol.IncludePath((String)mapping.getKey(), root.getKind().isSystem());
            VirtualFile mappedFile = OCIncludeHelpers.resolveIncludedFile(rootAndConfig, rootAndConfig.getRootFile(), includePath, project);
            if (!Objects.equals(mappedFile, fileToImport) || OCDefaultAutoImportHelper.processImportSpecification((String)mapping.getKey(), root.getKind(), processor2)) continue;
            return false;
        }
        return true;
    }

    public static boolean processIncludedHeadersRoot(@NotNull VirtualFile fileToImport, @NotNull VirtualFile rootBase, boolean recursive, @NotNull HeadersSearchPath.Kind kind, boolean preferQuotes, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor2) {
        String path;
        if (fileToImport == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(10);
        }
        if (rootBase == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(11);
        }
        if (kind == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(13);
        }
        String string = path = recursive ? fileToImport.getName() : VfsUtilCore.getRelativePath((VirtualFile)fileToImport, (VirtualFile)rootBase);
        if (path == null) {
            OCLog.LOG.error("Cannot calculate relative path: \n\tbase: " + String.valueOf(rootBase) + "\n\tchild: " + String.valueOf(fileToImport));
        }
        if (preferQuotes && kind == HeadersSearchPath.Kind.SYSTEM && OCCodeInsightSettings.getInstance().LOCAL_FILES_WITH_QUOTES) {
            kind = HeadersSearchPath.Kind.USER;
        }
        return OCDefaultAutoImportHelper.processImportSpecification(Objects.requireNonNull(path), kind, processor2);
    }

    public static boolean processImportSpecification(@NotNull String path, @NotNull HeadersSearchPath.Kind kind, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor2) {
        if (path == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(15);
        }
        if (processor2 == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(16);
        }
        return processor2.process((Object)new OCAutoImportHelper.ImportSpecification(path, OCAutoImportHelper.ImportSpecification.Kind.fromHeaderSearchPathKind(kind)));
    }

    @Override
    public void addHeaderSearchPath(@NotNull Project project, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport) {
        if (project == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(17);
        }
        if (fileToImport == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(18);
        }
    }

    @Override
    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull String fileNameToImport) {
        if (project == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(19);
        }
        if (targetFile == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(20);
        }
        if (fileNameToImport == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(21);
        }
        List<IntentionAction> list = Collections.emptyList();
        if (list == null) {
            OCDefaultAutoImportHelper.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndConfiguration";
                break;
            }
            case 1: 
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndConfig";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBase";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameToImport";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddHeaderSearchPathFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processPathSpecificationToInclude";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processHeaderMapRoot";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processIncludedHeadersRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processImportSpecification";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderSearchPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAddHeaderSearchPathFixes";
                break;
            }
            case 22: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22 -> new IllegalStateException(string);
        };
    }
}

