/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandler;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0015\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup;", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSListener;", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;Lcom/intellij/openapi/actionSystem/DataContext;)V", "lock", "", "Lkotlin/Unit;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/Nullable;", "balloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "Lorg/jetbrains/annotations/NotNull;", "items", "", "Lcom/intellij/psi/PsiFile;", "ui", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup$UI;", "onComputationStarted", "onComputationFinished", "onItemAdded", "item", "Lcom/intellij/openapi/vfs/VirtualFile;", "createUIIfNeeded", "createPopupAndUpdater", "gotoFile", "target", "closePopup", "showNotFoundBalloon", "updateUI", "UI", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nOCSwitchHSPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCSwitchHSPopup.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class OCSwitchHSPopup
implements OCSwitchHSListener {
    @NotNull
    private final Project project;
    @NotNull
    private final OCSwitchHSHandler handler;
    @NotNull
    private final Unit lock;
    @Nullable
    private final Editor editor;
    @NotNull
    private final RelativePoint balloonPosition;
    @NotNull
    private final List<PsiFile> items;
    @Nullable
    private UI ui;

    public OCSwitchHSPopup(@NotNull Project project, @NotNull OCSwitchHSHandler handler, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.project = project;
        this.handler = handler;
        this.lock = Unit.INSTANCE;
        this.editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        this.balloonPosition = relativePoint;
        this.items = new ArrayList();
    }

    @Override
    public void onComputationStarted() {
        ActionsKt.invokeLater$default(null, () -> OCSwitchHSPopup.onComputationStarted$lambda$0(this), (int)1, null);
    }

    @Override
    public void onComputationFinished() {
        ActionsKt.invokeLater$default(null, () -> OCSwitchHSPopup.onComputationFinished$lambda$2(this), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onItemAdded(@NotNull VirtualFile item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> OCSwitchHSPopup.onItemAdded$lambda$3(this, item));
        if (psiFile != null) {
            Unit unit = this.lock;
            synchronized (unit) {
                Unit unit2;
                boolean bl = false;
                this.items.add(psiFile);
                UI uI = this.ui;
                if (uI != null && (uI = uI.getAlarm()) != null) {
                    UI it = uI;
                    boolean bl2 = false;
                    it.cancelAllRequests();
                    it.addRequest(this::updateUI, 50);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Unit unit3 = unit2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createUIIfNeeded() {
        Unit unit = this.lock;
        synchronized (unit) {
            boolean bl = false;
            if (this.ui == null) {
                this.ui = this.createPopupAndUpdater();
            }
            this.updateUI();
            Unit unit2 = Unit.INSTANCE;
        }
    }

    private final UI createPopupAndUpdater() {
        Object object = WindowManagerEx.getInstanceEx().getFrame(this.project);
        int maxWidth = object != null && (object = object.getSize()) != null ? object.width : 500;
        GotoFileCellRenderer renderer = new GotoFileCellRenderer(maxWidth);
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(this.items).setTitle(OCBundle.message("switch.header.source.popup.title", new Object[0])).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer((ListCellRenderer)renderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(arg_0 -> OCSwitchHSPopup.createPopupAndUpdater$lambda$8(arg_0 -> OCSwitchHSPopup.createPopupAndUpdater$lambda$7(this, arg_0), arg_0)).setCancelCallback(() -> OCSwitchHSPopup.createPopupAndUpdater$lambda$9(this));
        renderer.installSpeedSearch(builder);
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        GenericListComponentUpdater genericListComponentUpdater = builder.getBackgroundUpdater();
        Intrinsics.checkNotNullExpressionValue((Object)genericListComponentUpdater, (String)"getBackgroundUpdater(...)");
        UI ui = new UI(jBPopup, (GenericListComponentUpdater<PsiFile>)genericListComponentUpdater);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)ui.getPopup()));
        if (this.editor != null) {
            ui.getPopup().showInBestPositionFor(this.editor);
        } else {
            ui.getPopup().showInFocusCenter();
        }
        return ui;
    }

    private final void gotoFile(VirtualFile target) {
        this.handler.cancel();
        if (target != null) {
            FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, target), true);
            this.handler.notifyTargetChosen(target);
        }
    }

    private final void closePopup() {
        block0: {
            this.handler.cancel();
            UI uI = this.ui;
            if (uI == null) break block0;
            UI it = uI;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getPopup()));
        }
    }

    private final void showNotFoundBalloon() {
        JComponent jComponent = HintUtil.createErrorLabel((String)OCBundle.message("switch.header.source.no.results", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createErrorLabel(...)");
        JComponent label = jComponent;
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(this.balloonPosition, Balloon.Position.above);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateUI() {
        Unit unit = this.lock;
        synchronized (unit) {
            Unit unit2;
            boolean bl = false;
            UI uI = this.ui;
            if (uI != null) {
                UI it = uI;
                boolean bl2 = false;
                it.getPopupUpdater().paintBusy(!this.handler.future().isDone());
                it.getPopupUpdater().replaceModel(this.items);
                it.getPopup().pack(true, true);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            Unit unit3 = unit2;
        }
    }

    private static final Unit onComputationStarted$lambda$0(OCSwitchHSPopup this$0) {
        try {
            this$0.handler.future().get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this$0.createUIIfNeeded();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit onComputationFinished$lambda$2(OCSwitchHSPopup this$0) {
        Unit unit = this$0.lock;
        synchronized (unit) {
            boolean bl = false;
            switch (this$0.items.size()) {
                case 0: {
                    this$0.closePopup();
                    this$0.showNotFoundBalloon();
                    break;
                }
                case 1: {
                    this$0.gotoFile(((PsiFile)CollectionsKt.single(this$0.items)).getVirtualFile());
                    break;
                }
                default: {
                    this$0.createUIIfNeeded();
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final PsiFile onItemAdded$lambda$3(OCSwitchHSPopup this$0, VirtualFile $item) {
        return PsiManager.getInstance((Project)this$0.project).findFile($item);
    }

    private static final Unit createPopupAndUpdater$lambda$7(OCSwitchHSPopup this$0, Set it) {
        Intrinsics.checkNotNull((Object)it);
        PsiFile psiFile = (PsiFile)CollectionsKt.firstOrNull((Iterable)it);
        this$0.gotoFile((VirtualFile)(psiFile != null ? psiFile.getVirtualFile() : null));
        return Unit.INSTANCE;
    }

    private static final void createPopupAndUpdater$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean createPopupAndUpdater$lambda$9(OCSwitchHSPopup this$0) {
        this$0.handler.cancel();
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup$UI;", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popupUpdater", "Lcom/intellij/openapi/ui/GenericListComponentUpdater;", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/ui/popup/JBPopup;Lcom/intellij/openapi/ui/GenericListComponentUpdater;)V", "getPopup", "()Lcom/intellij/openapi/ui/popup/JBPopup;", "getPopupUpdater", "()Lcom/intellij/openapi/ui/GenericListComponentUpdater;", "alarm", "Lcom/intellij/util/Alarm;", "getAlarm", "()Lcom/intellij/util/Alarm;", "intellij.c.core"})
    private static final class UI {
        @NotNull
        private final JBPopup popup;
        @NotNull
        private final GenericListComponentUpdater<PsiFile> popupUpdater;
        @NotNull
        private final Alarm alarm;

        public UI(@NotNull JBPopup popup, @NotNull GenericListComponentUpdater<PsiFile> popupUpdater) {
            Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
            Intrinsics.checkNotNullParameter(popupUpdater, (String)"popupUpdater");
            this.popup = popup;
            this.popupUpdater = popupUpdater;
            this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.popup);
        }

        @NotNull
        public final JBPopup getPopup() {
            return this.popup;
        }

        @NotNull
        public final GenericListComponentUpdater<PsiFile> getPopupUpdater() {
            return this.popupUpdater;
        }

        @NotNull
        public final Alarm getAlarm() {
            return this.alarm;
        }
    }
}

