/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview.classloading;

import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.StudioResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.rendering.classloading.loaders.DelegatingClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.classloading.LibraryResourceClassLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoader;", "Ljava/lang/ClassLoader;", "parent", "module", "Lcom/intellij/openapi/module/Module;", "childLoader", "Lcom/android/tools/rendering/classloading/loaders/DelegatingClassLoader$Loader;", "<init>", "(Ljava/lang/ClassLoader;Lcom/intellij/openapi/module/Module;Lcom/android/tools/rendering/classloading/loaders/DelegatingClassLoader$Loader;)V", "moduleRef", "Ljava/lang/ref/WeakReference;", "getModule", "findResourceClass", "Ljava/lang/Class;", "name", "", "findClass", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLibraryResourceClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryResourceClassLoader.kt\norg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class LibraryResourceClassLoader
extends ClassLoader {
    @NotNull
    private final DelegatingClassLoader.Loader childLoader;
    @NotNull
    private final WeakReference<Module> moduleRef;

    public LibraryResourceClassLoader(@Nullable ClassLoader parent, @Nullable Module module, @NotNull DelegatingClassLoader.Loader childLoader) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)childLoader, (String)"childLoader");
            super(parent);
            this.childLoader = childLoader;
            this.moduleRef = new WeakReference<Module>(module);
            Module module2 = this.getModule();
            if (module2 == null) break block0;
            Module it = module2;
            boolean bl = false;
            LibraryResourceClassLoaderKt.access$registerResources(it);
        }
    }

    private final Module getModule() {
        Module module = (Module)this.moduleRef.get();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (module2.isDisposed()) {
            return null;
        }
        return module2;
    }

    private final Class<?> findResourceClass(String name2) {
        Module module = this.getModule();
        if (module == null) {
            throw new ClassNotFoundException(name2);
        }
        Module module2 = module;
        if (!LibraryResourceClassLoaderKt.access$isResourceClassName(name2)) {
            throw new ClassNotFoundException(name2);
        }
        if (StudioResourceIdManager.Companion.get(module2).getFinalIdsUsed() && this.childLoader.loadClass(name2) != null) {
            throw new ClassNotFoundException(name2);
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            throw new ClassNotFoundException(name2);
        }
        AndroidFacet facet = androidFacet;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(facet);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(...)");
        StudioResourceRepositoryManager repositoryManager = studioResourceRepositoryManager;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        byte[] byArray = ResourceClassRegistry.Companion.get(project).findClassDefinition(name2, repositoryManager);
        if (byArray == null) {
            throw new ClassNotFoundException(name2);
        }
        byte[] data2 = byArray;
        Logger.getInstance(LibraryResourceClassLoader.class).debug("  Defining class from AAR registry");
        Class<?> clazz2 = this.defineClass(name2, data2, 0, data2.length);
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"defineClass(...)");
        return clazz2;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) {
        Class<?> clazz2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        try {
            clazz2 = super.findClass(name2);
            Intrinsics.checkNotNull(clazz2);
        }
        catch (ClassNotFoundException e) {
            clazz2 = this.findResourceClass(name2);
        }
        return clazz2;
    }
}

