/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.rendering.classloading.ClassTransform;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.uipreview.Clutch;
import org.jetbrains.android.uipreview.Request;
import org.jetbrains.android.uipreview.Stats;
import org.jetbrains.android.uipreview.StudioModuleClassLoader;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderCreationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/android/uipreview/ModuleClassLoaderHatchery;", "", "capacity", "", "copies", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(IILcom/intellij/openapi/Disposable;)V", "requests", "", "Lorg/jetbrains/android/uipreview/Request;", "storage", "Ljava/util/LinkedList;", "Lorg/jetbrains/android/uipreview/Clutch;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "requestClassLoader", "Lorg/jetbrains/android/uipreview/StudioModuleClassLoader;", "parent", "Ljava/lang/ClassLoader;", "projectTransformations", "Lcom/android/tools/rendering/classloading/ClassTransform;", "nonProjectTransformations", "incubateIfNeeded", "", "donor", "Lorg/jetbrains/android/uipreview/StudioModuleClassLoaderCreationContext;", "cloner", "Lkotlin/Function1;", "getStats", "", "Lorg/jetbrains/android/uipreview/Stats;", "destroy", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nModuleClassLoaderHatchery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleClassLoaderHatchery.kt\norg/jetbrains/android/uipreview/ModuleClassLoaderHatchery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1#2:243\n1563#3:244\n1634#3,3:245\n1869#3,2:248\n*S KotlinDebug\n*F\n+ 1 ModuleClassLoaderHatchery.kt\norg/jetbrains/android/uipreview/ModuleClassLoaderHatchery\n*L\n223#1:244\n223#1:245,3\n229#1:248,2\n*E\n"})
public final class ModuleClassLoaderHatchery {
    private final int capacity;
    private final int copies;
    @NotNull
    private final Set<Request> requests;
    @NotNull
    private final LinkedList<Clutch> storage;
    @NotNull
    private final AtomicBoolean isDisposed;

    public ModuleClassLoaderHatchery(int capacity, int copies, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.capacity = capacity;
        this.copies = copies;
        this.requests = new LinkedHashSet();
        this.storage = new LinkedList();
        this.isDisposed = new AtomicBoolean(false);
        Disposer.register((Disposable)parentDisposable, () -> ModuleClassLoaderHatchery._init_$lambda$0(this));
    }

    public /* synthetic */ ModuleClassLoaderHatchery(int n, int n2, Disposable disposable, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(n, n2, disposable);
    }

    @Nullable
    public final synchronized StudioModuleClassLoader requestClassLoader(@Nullable ClassLoader parent, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)projectTransformations, (String)"projectTransformations");
            Intrinsics.checkNotNullParameter((Object)nonProjectTransformations, (String)"nonProjectTransformations");
            if (this.isDisposed.get()) {
                return null;
            }
            Iterable iterable = this.storage;
            for (Object t : iterable) {
                Clutch it = (Clutch)t;
                boolean bl = false;
                if (!it.isCompatible(parent, projectTransformations, nonProjectTransformations)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Clutch clutch = v0;
        if (clutch != null) {
            Clutch clutch2 = clutch;
            boolean bl = false;
            return clutch2.retrieve();
        }
        this.requests.add(new Request(parent, projectTransformations, nonProjectTransformations));
        return null;
    }

    public final synchronized boolean incubateIfNeeded(@NotNull StudioModuleClassLoaderCreationContext donor, @NotNull Function1<? super StudioModuleClassLoaderCreationContext, StudioModuleClassLoader> cloner) {
        boolean hasCompatibleDonor;
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)donor, (String)"donor");
            Intrinsics.checkNotNullParameter(cloner, (String)"cloner");
            if (this.isDisposed.get()) {
                return false;
            }
            Iterable iterable = this.storage;
            for (Object t : iterable) {
                Clutch it = (Clutch)t;
                boolean bl = false;
                if (!it.isCompatible(donor.getParent(), donor.getProjectTransform(), donor.getNonProjectTransformation())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        boolean bl = hasCompatibleDonor = v0 != null;
        if (hasCompatibleDonor) {
            return false;
        }
        Request request = new Request(donor.getParent(), donor.getProjectTransform(), donor.getNonProjectTransformation());
        if (this.requests.contains(request)) {
            this.requests.remove(request);
            if (this.storage.size() == this.capacity) {
                this.storage.poll().destroy();
            }
            this.storage.add(new Clutch(cloner, donor, this.copies));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<Stats> getStats() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.storage;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Clutch clutch = (Clutch)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getStats());
        }
        return (List)destination$iv$iv;
    }

    public final synchronized void destroy() {
        this.requests.clear();
        Iterable $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Clutch it = (Clutch)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.storage.clear();
    }

    private static final void _init_$lambda$0(ModuleClassLoaderHatchery this$0) {
        this$0.isDisposed.set(true);
        this$0.destroy();
    }
}

