/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.utils.SdkUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.spellchecker.GroovySpellcheckingStrategy;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class AndroidGradleSpellcheckingStrategy
extends GroovySpellcheckingStrategy {
    public boolean isMyContext(@NotNull PsiElement element) {
        return AndroidGradleSpellcheckingStrategy.isInGradleFile(element);
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (TokenSets.STRING_LITERAL_SET.contains(element.getNode().getElementType()) && !AndroidGradleSpellcheckingStrategy.isPrint(element)) {
            return EMPTY_TOKENIZER;
        }
        return super.getTokenizer(element);
    }

    private static boolean isPrint(PsiElement element) {
        GrExpression invokedExpression;
        PsiElement parent0 = element.getParent();
        if (parent0 == null) {
            return false;
        }
        PsiElement parent1 = parent0.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (parent2 == null) {
            return false;
        }
        if (parent2 instanceof GrCommandArgumentList) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof GrApplicationStatement) {
            GrApplicationStatement call = (GrApplicationStatement)parent2;
            invokedExpression = call.getInvokedExpression();
        } else if (parent2 instanceof GrMethodCallExpression) {
            GrMethodCallExpression call = (GrMethodCallExpression)parent2;
            invokedExpression = call.getInvokedExpression();
        } else {
            return false;
        }
        if (invokedExpression instanceof GrReferenceExpression) {
            GrReferenceExpression propertyRef = (GrReferenceExpression)invokedExpression;
            String property2 = propertyRef.getReferenceName();
            return "print".equals(property2) || "println".equals(property2);
        }
        return false;
    }

    private static boolean isInGradleFile(PsiElement element) {
        String name2;
        PsiFile file = element.getContainingFile();
        return file != null && SdkUtils.endsWithIgnoreCase((String)(name2 = file.getName()), (String)".gradle");
    }
}

