/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.EmbeddedRenderTarget;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/android/sdk/StudioEmbeddedRenderTarget;", "", "<init>", "()V", "Companion", "intellij.android.core"})
public final class StudioEmbeddedRenderTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    private static boolean ourDisableEmbeddedTargetForTesting;
    @Nullable
    private static final String ourEmbeddedLayoutlibPath;

    @JvmStatic
    @VisibleForTesting
    public static final void setDisableEmbeddedTarget(boolean value2) {
        Companion.setDisableEmbeddedTarget(value2);
    }

    @JvmStatic
    @NotNull
    public static final CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target2) {
        return Companion.getCompatibilityTarget(target2);
    }

    static {
        Logger logger = Logger.getInstance(StudioEmbeddedRenderTarget.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ourEmbeddedLayoutlibPath = StudioEmbeddedRenderTarget.Companion.getEmbeddedLayoutLibPath();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/android/sdk/StudioEmbeddedRenderTarget$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ourDisableEmbeddedTargetForTesting", "", "ourEmbeddedLayoutlibPath", "", "getOurEmbeddedLayoutlibPath", "()Ljava/lang/String;", "setDisableEmbeddedTarget", "", "value", "getCompatibilityTarget", "Lcom/android/tools/sdk/CompatibilityRenderTarget;", "target", "Lcom/android/sdklib/IAndroidTarget;", "getEmbeddedLayoutLibPath", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getOurEmbeddedLayoutlibPath() {
            return ourEmbeddedLayoutlibPath;
        }

        @JvmStatic
        @VisibleForTesting
        public final void setDisableEmbeddedTarget(boolean value2) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ourDisableEmbeddedTargetForTesting = value2;
        }

        @JvmStatic
        @NotNull
        public final CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            if (ourDisableEmbeddedTargetForTesting) {
                return new CompatibilityRenderTarget(target2, target2.getVersion().getApiLevel(), target2);
            }
            CompatibilityRenderTarget compatibilityRenderTarget = EmbeddedRenderTarget.getCompatibilityTarget(target2, Companion::getCompatibilityTarget$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)compatibilityRenderTarget, (String)"getCompatibilityTarget(...)");
            return compatibilityRenderTarget;
        }

        private final String getEmbeddedLayoutLibPath() {
            VirtualFile root;
            String string = FileUtil.toSystemIndependentName((String)PluginPathManager.getPluginHomePath((String)"design-tools"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String homePath = string;
            String[] stringArray = new String[]{homePath, "/resources/layoutlib/"};
            String string2 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            String path = string2;
            if (StudioPathManager.isRunningFromSources()) {
                path = ((Object)StudioPathManager.resolvePathFromSourcesRoot((String)"prebuilts/studio/layoutlib/")).toString();
            }
            if ((root = VirtualFileManager.getInstance().getFileSystem("file").findFileByPath(FileUtil.toSystemIndependentName((String)path))) != null) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                File rootFile = file;
                if (rootFile.exists() && rootFile.isDirectory()) {
                    LOG.debug("Embedded layoutlib found at " + path);
                    return rootFile.getAbsolutePath() + File.separator;
                }
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Unable to find embedded layoutlib in path: " + path);
            }
            return null;
        }

        private static final String getCompatibilityTarget$lambda$0() {
            return Companion.getOurEmbeddedLayoutlibPath();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

