/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.AttributeDefinitionsImpl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private final AndroidFacet myFacet;
    private volatile CachedValue<AttributeDefinitions> myAttrDefs;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)element);
        return facet != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        super(facet.getModule().getProject());
        this.myFacet = facet;
        this.myAttrDefs = LocalResourceManager.createAttributeDefinitions(this.myFacet, this.myProject);
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        for (VirtualFile resDir : ResourceFolderManager.getInstance(this.myFacet).getFolders()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile resDir : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        return (AttributeDefinitions)this.myAttrDefs.getValue();
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = LocalResourceManager.createAttributeDefinitions(this.myFacet, this.myProject);
    }

    private static CachedValue<AttributeDefinitions> createAttributeDefinitions(AndroidFacet facet, Project project) {
        return CachedValuesManager.getManager((Project)project).createCachedValue((UserDataHolder)facet, () -> {
            FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
            AttributeDefinitions frameworkAttributes = frameworkResourceManager == null ? null : ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
            LocalResourceRepository<VirtualFile> resourceRepository = StudioResourceRepositoryManager.getAppResources(facet);
            AttributeDefinitions attrDefs = AttributeDefinitionsImpl.create(frameworkAttributes, resourceRepository);
            ModificationTracker resourceRepositoryTracker = resourceRepository::getModificationCount;
            return new CachedValueProvider.Result((Object)attrDefs, new Object[]{resourceRepositoryTracker});
        }, false);
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType) {
        return this.findResourceFiles(namespace, resourceFolderType, null, true, true);
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, boolean withDependencies) {
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        LocalResourceRepository<VirtualFile> repository2 = withDependencies ? StudioResourceRepositoryManager.getAppResources(this.myFacet) : StudioResourceRepositoryManager.getModuleResources(this.myFacet);
        Collection repositories = repository2.getLeafResourceRepositories();
        if (resourceFolderType == ResourceFolderType.VALUES) {
            for (ResourceType resourceType : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType)) {
                this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
            }
        } else {
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)resourceFolderType);
            this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
        }
        return result2;
    }

    private void findResourceFiles(@NotNull Collection<SingleNamespaceResourceRepository> repositories, @NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, @NotNull Set<PsiFile> result2) {
        for (ResourceRepository resourceRepository : repositories) {
            Collection items = nameToLookFor == null ? resourceRepository.getResources(namespace, resourceType).values() : (distinguishDelimitersInName ? resourceRepository.getResources(namespace, resourceType, nameToLookFor) : resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equalIgnoringDelimiters(nameToLookFor, item.getName())));
            for (ResourceItem item2 : items) {
                PsiFile file;
                VirtualFile resFile = IdeResourcesUtil.getSourceAsVirtualFile(item2);
                if (resFile == null || ResourceFolderType.getFolderType((String)resFile.getParent().getName()) != resourceFolderType || (file = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)resFile)) == null) continue;
                result2.add(file);
            }
        }
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        return StudioResourceRepositoryManager.getAppResources(this.myFacet).getLeafResourceRepositories();
    }
}

