/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesProcessor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0097\u0002J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0097\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "intellij.android.projectSystem.gradle"})
public final class MigrateToNonTransitiveRClassesHandler
implements RefactoringActionHandler {
    @UiThread
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.invoke(project);
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.invoke(project);
    }

    private final void invoke(Project project) {
        AndroidPluginInfo pluginVersion;
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(project);
        AndroidPluginInfo androidPluginInfo = pluginInfo;
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            androidPluginInfo = new AgpVersion(7, 0, 0);
        }
        if (!(pluginVersion = androidPluginInfo).isAtLeast(4, 2, 0, "alpha", 0, true)) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.error.old.agp.message", new Object[0]), (String)AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.error.old.agp.title", new Object[0]));
            return;
        }
        MigrateToNonTransitiveRClassesProcessor processor = MigrateToNonTransitiveRClassesProcessor.Companion.forEntireProject(project, (AgpVersion)pluginVersion);
        processor.setPreviewUsages(true);
        processor.run();
    }
}

