/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.IncludingLayout;
import com.android.utils.SdkUtils;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidExtractAsIncludeActionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u001a\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction;", "Lorg/jetbrains/android/refactoring/AndroidBaseLayoutRefactoringAction;", "testConfig", "Lorg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$TestConfig;", "<init>", "(Lorg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$TestConfig;)V", "doRefactorForTags", "", "project", "Lcom/intellij/openapi/project/Project;", "tags", "", "Lcom/intellij/psi/xml/XmlTag;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/xml/XmlTag;)V", "isEnabledForTags", "", "([Lcom/intellij/psi/xml/XmlTag;)Z", "doRefactorForPsiRange", "file", "Lcom/intellij/psi/PsiFile;", "from", "Lcom/intellij/psi/PsiElement;", "to", "isEnabledForPsiRange", "TestConfig", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidExtractAsIncludeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidExtractAsIncludeAction.kt\norg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,233:1\n16821#2,14:234\n13849#2,14:248\n1740#3,3:262\n1#4:265\n37#5:266\n36#5,3:267\n*S KotlinDebug\n*F\n+ 1 AndroidExtractAsIncludeAction.kt\norg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction\n*L\n85#1:234,14\n86#1:248,14\n99#1:262,3\n117#1:266\n117#1:267,3\n*E\n"})
public final class AndroidExtractAsIncludeAction
extends AndroidBaseLayoutRefactoringAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TestConfig testConfig;
    @NotNull
    public static final String ACTION_ID = "AndroidExtractAsIncludeAction";

    public AndroidExtractAsIncludeAction(@Nullable TestConfig testConfig) {
        this.testConfig = testConfig;
    }

    public /* synthetic */ AndroidExtractAsIncludeAction(TestConfig testConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            testConfig = null;
        }
        this(testConfig);
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        XmlTag xmlTag;
        XmlTag xmlTag2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        if (tags.length == 0) {
            return;
        }
        Object[] $this$minBy$iv = tags;
        boolean $i$f$minByOrThrow = false;
        if ($this$minBy$iv.length == 0) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = $this$minBy$iv[0];
        int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minBy$iv);
        if (lastIndex$iv == 0) {
            xmlTag2 = minElem$iv;
        } else {
            XmlTag it = minElem$iv;
            boolean bl = false;
            int minValue$iv = FixersUtilKt.getRange((PsiElement)((PsiElement)it)).getStartOffset();
            int i$iv = 1;
            if (i$iv <= lastIndex$iv) {
                while (true) {
                    Object e$iv;
                    Object it2 = e$iv = $this$minBy$iv[i$iv];
                    $i$a$-minByOrThrow-AndroidExtractAsIncludeAction$doRefactorForTags$startTag$1 = false;
                    int v$iv = FixersUtilKt.getRange((PsiElement)((PsiElement)it2)).getStartOffset();
                    if (minValue$iv > v$iv) {
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    }
                    if (i$iv == lastIndex$iv) break;
                    ++i$iv;
                }
            }
            xmlTag2 = minElem$iv;
        }
        XmlTag startTag = xmlTag2;
        Object[] $this$maxBy$iv = tags;
        boolean $i$f$maxByOrThrow = false;
        if ($this$maxBy$iv.length == 0) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = $this$maxBy$iv[0];
        int lastIndex$iv2 = ArraysKt.getLastIndex((Object[])$this$maxBy$iv);
        if (lastIndex$iv2 == 0) {
            xmlTag = maxElem$iv;
        } else {
            XmlTag it = maxElem$iv;
            boolean bl = false;
            int maxValue$iv = FixersUtilKt.getRange((PsiElement)((PsiElement)it)).getEndOffset();
            int i$iv = 1;
            if (i$iv <= lastIndex$iv2) {
                while (true) {
                    Object e$iv;
                    Object it3 = e$iv = $this$maxBy$iv[i$iv];
                    $i$a$-maxByOrThrow-AndroidExtractAsIncludeAction$doRefactorForTags$endTag$1 = false;
                    int v$iv = FixersUtilKt.getRange((PsiElement)((PsiElement)it3)).getEndOffset();
                    if (maxValue$iv < v$iv) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == lastIndex$iv2) break;
                    ++i$iv;
                }
            }
            xmlTag = maxElem$iv;
        }
        XmlTag endTag = xmlTag;
        PsiFile psiFile = tags[0].getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        this.doRefactorForPsiRange(project, file, (PsiElement)startTag, (PsiElement)endTag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        if (tags.length == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) {
            return false;
        }
        Sequence sequence = ArraysKt.asSequence((Object[])tags);
        Project project = ((XmlTag)ArraysKt.first((Object[])tags)).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!AndroidExtractAsIncludeActionKt.access$allSuitableAndContainsViewElement(sequence, project)) {
            return false;
        }
        PsiElement parent = tags[0].getParent();
        if (!(parent instanceof XmlTag)) return false;
        if (((XmlTag)parent).getContainingFile() == null) return false;
        Iterable $this$all$iv = ArraysKt.drop((Object[])tags, (int)1);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            XmlTag it = (XmlTag)element$iv;
            boolean bl3 = false;
            if (it.getParent() != parent) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement from2, @NotNull PsiElement to) {
        FolderConfiguration folderConfiguration;
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory dir = psiDirectory;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)from2);
        if (androidFacet == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        AndroidFacet facet = androidFacet;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)from2, XmlTag.class);
        if (psiElement == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        XmlTag parentTag = (XmlTag)psiElement;
        int numTags = SequencesKt.count((Sequence)AndroidExtractAsIncludeActionKt.access$xmlTagSiblingsBetween(from2, to, true));
        boolean bl2 = bl = numTags > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string4 = "there is no tag inside the range";
            throw new AssertionError((Object)string4);
        }
        String string5 = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        String p0 = string = string5;
        boolean bl4 = false;
        String string6 = ((CharSequence)p0).length() > 0 ? string : null;
        if (string6 != null) {
            void $this$toTypedArray$iv;
            String it = string6;
            boolean bl5 = false;
            Object object = it;
            Regex regex = new Regex("-");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            folderConfiguration = FolderConfiguration.getConfig((String[])thisCollection$iv.toArray(new String[0]));
        } else {
            folderConfiguration = null;
        }
        FolderConfiguration config = folderConfiguration;
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> AndroidExtractAsIncludeAction.doRefactorForPsiRange$lambda$3(arg_0 -> AndroidExtractAsIncludeAction.doRefactorForPsiRange$lambda$2(project, facet, this, config, file, from2, to, parentTag, numTags, arg_0), arg_0));
    }

    @Override
    protected boolean isEnabledForPsiRange(@NotNull PsiElement from2, @Nullable PsiElement to) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Sequence sequence = AndroidExtractAsIncludeActionKt.xmlTagSiblingsBetween$default(from2, to, false, 4, null);
        Project project = from2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return AndroidExtractAsIncludeActionKt.access$allSuitableAndContainsViewElement(sequence, project);
    }

    private static final Unit doRefactorForPsiRange$lambda$2(Project $project, AndroidFacet $facet, AndroidExtractAsIncludeAction this$0, FolderConfiguration $config, PsiFile $file, PsiElement $from, PsiElement $to, XmlTag $parentTag, int $numTags, DataContext dataContext) {
        CommandProcessor.getInstance().executeCommand($project, () -> AndroidExtractAsIncludeAction.doRefactorForPsiRange$lambda$2$0($facet, this$0, $config, dataContext, $file, $from, $to, $parentTag, $numTags), "Extract Android Layout", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return Unit.INSTANCE;
    }

    private static final void doRefactorForPsiRange$lambda$2$0(AndroidFacet $facet, AndroidExtractAsIncludeAction this$0, FolderConfiguration $config, DataContext $dataContext, PsiFile $file, PsiElement $from, PsiElement $to, XmlTag $parentTag, int $numTags) {
        TestConfig testConfig = this$0.testConfig;
        XmlFile newFile = CreateResourceFileAction.createFileResource($facet, ResourceFolderType.LAYOUT, testConfig != null ? testConfig.getLayoutFileName() : null, "temp_root", $config, true, "Extract Android Layout", null, $dataContext);
        if (newFile != null) {
            ApplicationKt.getApplication().runWriteAction(() -> AndroidExtractAsIncludeAction.doRefactorForPsiRange$lambda$2$0$0($facet, $file, newFile, $from, $to, $parentTag, $numTags));
        }
    }

    private static final void doRefactorForPsiRange$lambda$2$0$0(AndroidFacet $facet, PsiFile $file, XmlFile $newFile, PsiElement $from, PsiElement $to, XmlTag $parentTag, int $numTags) {
        AndroidExtractAsIncludeAction.Companion.doRefactor($facet, $file, $newFile, $from, $to, $parentTag, $numTags > 1);
    }

    private static final void doRefactorForPsiRange$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public AndroidExtractAsIncludeAction() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$Companion;", "", "<init>", "()V", "ACTION_ID", "", "Lorg/jetbrains/annotations/NonNls;", "doRefactor", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "file", "Lcom/intellij/psi/PsiFile;", "newFile", "Lcom/intellij/psi/xml/XmlFile;", "from", "Lcom/intellij/psi/PsiElement;", "to", "parentTag", "Lcom/intellij/psi/xml/XmlTag;", "wrapWithMerge", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void doRefactor(AndroidFacet facet, PsiFile file, XmlFile newFile, PsiElement from2, PsiElement to, XmlTag parentTag, boolean wrapWithMerge) {
            Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            String string = file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = from2.getTextRange().getStartOffset();
            int n2 = to.getTextRange().getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String textToExtract = string3;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            Document document = documentManager.getDocument((PsiFile)newFile);
            if (document == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            Document document2 = document;
            document2.setText((CharSequence)("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (String)(wrapWithMerge ? "<merge>\n" + textToExtract + "\n</merge>" : textToExtract)));
            documentManager.commitDocument(document2);
            Set unknownPrefixes = new LinkedHashSet();
            newFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(unknownPrefixes){
                final /* synthetic */ Set<String> $unknownPrefixes;
                {
                    this.$unknownPrefixes = $unknownPrefixes;
                }

                public void visitXmlTag(XmlTag tag) {
                    Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                    super.visitXmlTag(tag);
                    String string = tag.getNamespacePrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespacePrefix(...)");
                    String prefix = string;
                    if (!this.$unknownPrefixes.contains(prefix)) {
                        String string2 = tag.getNamespace();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespace(...)");
                        if (((CharSequence)string2).length() == 0) {
                            this.$unknownPrefixes.add(prefix);
                        }
                    }
                }

                public void visitXmlAttribute(XmlAttribute attribute2) {
                    Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
                    String string = attribute2.getNamespacePrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespacePrefix(...)");
                    String prefix = string;
                    if (!this.$unknownPrefixes.contains(prefix)) {
                        String string2 = attribute2.getNamespace();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespace(...)");
                        if (((CharSequence)string2).length() == 0) {
                            this.$unknownPrefixes.add(prefix);
                        }
                    }
                }
            });
            XmlTag xmlTag = newFile.getRootTag();
            if (xmlTag == null) {
                String string5 = "Required value was null.";
                throw new IllegalStateException(string5.toString());
            }
            XmlTag rootTag = xmlTag;
            XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project2);
            Object[] objectArray = rootTag.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAttributes(...)");
            Object[] attributes = objectArray;
            XmlAttribute firstAttribute = (XmlAttribute)ArraysKt.firstOrNull((Object[])attributes);
            for (String prefix : unknownPrefixes) {
                XmlAttribute xmlnsAttr;
                String namespace;
                Intrinsics.checkNotNullExpressionValue((Object)parentTag.getNamespaceByPrefix(prefix), (String)"getNamespaceByPrefix(...)");
                String xmlNsAttrName = "xmlns:" + prefix;
                if (!(((CharSequence)namespace).length() > 0) || rootTag.getAttribute(xmlNsAttrName) != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)elementFactory.createXmlAttribute(xmlNsAttrName, namespace), (String)"createXmlAttribute(...)");
                PsiElement psiElement = firstAttribute == null ? rootTag.add((PsiElement)xmlnsAttr) : rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
            }
            String includingLayout = "@layout/" + SdkUtils.fileNameToResourceName((String)file.getName());
            IncludingLayout.setIncludingLayout(newFile, includingLayout);
            String resourceName = SdkUtils.fileNameToResourceName((String)newFile.getName());
            XmlTag xmlTag2 = elementFactory.createTagFromText((CharSequence)("<include layout=\"@layout/" + resourceName + "\"/>"));
            Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"createTagFromText(...)");
            XmlTag includeTag = xmlTag2;
            parentTag.addAfter((PsiElement)includeTag, to);
            parentTag.deleteChildRange(from2, to);
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)newFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$TestConfig;", "", "layoutFileName", "", "<init>", "(Ljava/lang/String;)V", "getLayoutFileName", "()Ljava/lang/String;", "intellij.android.core"})
    public static final class TestConfig {
        @NotNull
        private final String layoutFileName;

        public TestConfig(@NotNull String layoutFileName) {
            Intrinsics.checkNotNullParameter((Object)layoutFileName, (String)"layoutFileName");
            this.layoutFileName = layoutFileName;
        }

        @NotNull
        public final String getLayoutFileName() {
            return this.layoutFileName;
        }
    }
}

