/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.VariableOfTypeMacro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("add.string.resource.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return false;
        }
        if (!ProjectSystemService.getInstance(project).getProjectSystem().getModuleSystem(facet.getModule()).getSupportsAndroidResources()) {
            return false;
        }
        PsiElement element = AndroidAddStringResourceAction.getPsiElement(file, editor);
        return element != null && AndroidAddStringResourceAction.getStringLiteralValue(project, element, file, this.getType()) != null;
    }

    protected ResourceType getType() {
        return ResourceType.STRING;
    }

    @Nullable
    protected static String getStringLiteralValue(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiFile file, ResourceType resourceType) {
        ResourceValue value2;
        Converter converter;
        GenericAttributeValue domAttribute;
        XmlAttribute attribute2;
        if (file instanceof PsiJavaFile && element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object value3 = literalExpression.getValue();
            if (resourceType == ResourceType.STRING && value3 instanceof String) {
                return (String)value3;
            }
            if (resourceType == ResourceType.DIMEN && (value3 instanceof Integer || value3 instanceof Float)) {
                return value3.toString();
            }
        } else if (file instanceof XmlFile && element instanceof XmlAttributeValue && (attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null && (domAttribute = DomManager.getDomManager((Project)project).getDomElement(attribute2)) != null && (converter = domAttribute.getConverter()) instanceof ResourceReferenceConverter && (value2 = (ResourceValue)domAttribute.getValue()) != null && !value2.isReference()) {
            Set<ResourceType> types = ((ResourceReferenceConverter)converter).getResourceTypes((DomElement)domAttribute);
            for (ResourceType type : types) {
                if (resourceType != type) continue;
                String attributeText = ((XmlAttributeValue)element).getValue();
                if (attributeText != null) {
                    return ValueXmlHelper.unescapeResourceString((String)attributeText, (boolean)true, (boolean)true);
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getContainingInheritorOf(@NotNull PsiElement element, String ... baseClassNames) {
        PsiClass c = null;
        do {
            c = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(c == null ? element : c), PsiClass.class);
            for (String name2 : baseClassNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)c, (String)name2)) continue;
                return c;
            }
        } while (c != null);
        return null;
    }

    @Nullable
    protected static PsiElement getPsiElement(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? element.getParent() : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        AndroidAddStringResourceAction.doInvoke(project, editor, file, null, this.getType());
    }

    static void doInvoke(Project project, Editor editor, PsiFile file, @Nullable String resName, ResourceType type) {
        PsiElement element = AndroidAddStringResourceAction.getPsiElement(file, editor);
        assert (element != null);
        AndroidAddStringResourceAction.doInvoke(project, editor, file, resName, element, type);
    }

    protected static void doInvoke(Project project, Editor editor, PsiFile file, @Nullable String resName, PsiElement element, ResourceType type) {
        List<String> dirNames;
        VirtualFile resourceDir;
        String fileName;
        String value2 = AndroidAddStringResourceAction.getStringLiteralValue(project, element, file, type);
        assert (value2 != null);
        if (resName == null) {
            resName = IdeResourcesUtil.buildResourceNameFromStringValue(value2);
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        assert (facet != null);
        String aPackage = ProjectSystemUtil.getModuleSystem(facet).getPackageName();
        if (aPackage == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("package.not.found.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (resName != null && ApplicationManager.getApplication().isUnitTestMode()) {
            fileName = IdeResourcesUtil.getDefaultResourceFileName(type);
            assert (fileName != null);
            resourceDir = ResourceFolderManager.getInstance(facet).getPrimaryFolder();
            assert (resourceDir != null);
            dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        } else {
            Module facetModule = facet.getModule();
            CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(facetModule, type, resName, value2, true, null, file.getVirtualFile());
            dialog2.setTitle("Extract Resource");
            if (!dialog2.showAndGet()) {
                return;
            }
            resourceDir = dialog2.getResourceDirectory();
            if (resourceDir == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", facetModule));
                return;
            }
            fileName = dialog2.getFileName();
            resName = dialog2.getResourceName();
            dirNames = dialog2.getDirNames();
            value2 = dialog2.getValue();
        }
        String finalValue = value2;
        String finalResName = resName;
        if (IdeResourcesUtil.createValueResource(project, resourceDir, finalResName, type, fileName, dirNames, finalValue)) {
            AndroidAddStringResourceAction.doAddStringResource(editor, file, finalResName, element, type, facet, aPackage);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            UndoUtil.markPsiFileForUndo((PsiFile)file);
            PsiManager.getInstance((Project)project).dropResolveCaches();
        }
    }

    private static void doAddStringResource(Editor editor, PsiFile file, @Nullable String resName, PsiElement element, ResourceType type, AndroidFacet facet, String aPackage) {
        WriteAction.run(() -> {
            if (file instanceof PsiJavaFile) {
                AndroidAddStringResourceAction.createJavaResourceReference(facet.getModule(), editor, file, element, aPackage, resName, type);
            } else {
                XmlAttribute attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
                if (attribute2 != null) {
                    attribute2.setValue(ResourceValue.referenceTo('@', null, type.getName(), resName).toString());
                }
            }
        });
    }

    private static boolean hasMethodOnlyOverloadedWithOneIntParameter(PsiMethod method2, int index) {
        PsiMethod[] sameNameMethods;
        if (method2.getNameIdentifier() == null) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount == 0) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String methodName = method2.getName();
        for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
            PsiParameterList otherParameterList;
            if (method2.equals((Object)sameNameMethod) || parameterCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
            boolean found = true;
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter[] otherParameters = otherParameterList.getParameters();
            for (int i = 0; i < parameterCount; ++i) {
                PsiParameter parameter = parameters2[i];
                PsiParameter otherParameter = otherParameters[i];
                if (i == index) {
                    if (!PsiTypes.intType().equals((Object)otherParameter.getType())) {
                        found = false;
                        break;
                    }
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)otherParameter, (String)ResourceEvaluator.STRING_RES_ANNOTATION.oldName(), (int)2) || AnnotationUtil.isAnnotated((PsiModifierListOwner)otherParameter, (String)ResourceEvaluator.STRING_RES_ANNOTATION.newName(), (int)2)) continue;
                    found = false;
                    break;
                }
                if (parameter.getType().equals(otherParameter.getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static boolean useGetStringMethodForStringRes(PsiElement element) {
        if (element.getParent() instanceof PsiExpressionList) {
            PsiElement resolved;
            PsiExpressionList expressionList = (PsiExpressionList)element.getParent();
            int index = Arrays.asList(expressionList.getExpressions()).indexOf((PsiExpression)element);
            PsiElement prevSibling = expressionList.getPrevSibling();
            if (prevSibling != null && prevSibling.getReference() != null && (resolved = prevSibling.getReference().resolve()) instanceof PsiMethod && AndroidAddStringResourceAction.hasMethodOnlyOverloadedWithOneIntParameter((PsiMethod)resolved, index)) {
                return false;
            }
        }
        return true;
    }

    private static void createJavaResourceReference(Module module, Editor editor, final PsiFile file, PsiElement element, String aPackage, String resName, ResourceType resType) {
        TemplateImpl template;
        boolean extendsContext = AndroidAddStringResourceAction.getContainingInheritorOf(element, "android.content.Context") != null;
        boolean extendsFragment = AndroidAddStringResourceAction.getContainingInheritorOf(element, "android.app.Fragment") != null || AndroidAddStringResourceAction.getContainingInheritorOf(element, AndroidXConstants.CLASS_V4_FRAGMENT.oldName()) != null || AndroidAddStringResourceAction.getContainingInheritorOf(element, AndroidXConstants.CLASS_V4_FRAGMENT.newName()) != null;
        String rJavaFieldName = IdeResourcesUtil.getRJavaFieldName(resName);
        String field2 = aPackage + ".R." + resType.getName() + "." + rJavaFieldName;
        String methodName = AndroidAddStringResourceAction.getGetterNameForResourceType(resType, element);
        assert (methodName != null);
        boolean inStaticContext = CommonJavaRefactoringUtil.isInStaticContext((PsiElement)element, null);
        final Project project = module.getProject();
        if ((extendsContext || extendsFragment) && !inStaticContext) {
            if (ResourceType.STRING == resType) {
                template = AndroidAddStringResourceAction.useGetStringMethodForStringRes(element) ? new TemplateImpl("", methodName + "(" + field2 + ")", "") : new TemplateImpl("", field2, "");
            } else {
                template = new TemplateImpl("", "$resources$." + methodName + "(" + field2 + ")", "");
                MacroCallNode node = new MacroCallNode((Macro)new MyVarOfTypeExpression("getResources()"));
                node.addParameter((Expression)new ConstantNode("android.content.res.Resources"));
                template.addVariable("resources", (Expression)node, (Expression)new ConstantNode(""), true);
            }
        } else {
            boolean addContextVariable = true;
            if (ResourceType.STRING == resType) {
                if (AndroidAddStringResourceAction.useGetStringMethodForStringRes(element)) {
                    template = new TemplateImpl("", "$context$." + methodName + "(" + field2 + ")", "");
                } else {
                    template = new TemplateImpl("", field2, "");
                    addContextVariable = false;
                }
            } else {
                template = new TemplateImpl("", "$context$.getResources()." + methodName + "(" + field2 + ")", "");
            }
            if (addContextVariable) {
                boolean extendsView = AndroidAddStringResourceAction.getContainingInheritorOf(element, "android.view.View") != null;
                MacroCallNode node = new MacroCallNode((Macro)(extendsView && !inStaticContext ? new MyVarOfTypeExpression("getContext()") : new VariableOfTypeMacro()));
                node.addParameter((Expression)new ConstantNode("android.content.Context"));
                template.addVariable("context", (Expression)node, (Expression)new ConstantNode(""), true);
            }
        }
        int offset = element.getTextOffset();
        editor.getCaretModel().moveToOffset(offset);
        TextRange elementRange = element.getTextRange();
        editor.getDocument().deleteString(elementRange.getStartOffset(), elementRange.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void waitingForInput(Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, marker.getStartOffset(), marker.getEndOffset());
            }

            public void beforeTemplateFinished(@NotNull TemplateState state2, Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, marker.getStartOffset(), marker.getEndOffset());
            }
        });
    }

    @Nullable
    private static String getGetterNameForResourceType(@NotNull ResourceType resourceType, @NotNull PsiElement element) {
        String type = resourceType.getName();
        if (type.length() < 2) {
            return null;
        }
        if (resourceType == ResourceType.DIMEN) {
            PsiType targetType = AndroidAddStringResourceAction.computeTargetType(element);
            if (PsiTypes.intType().equals((Object)targetType)) {
                return "getDimensionPixelSize";
            }
            return "getDimension";
        }
        return "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Nullable
    private static PsiType computeTargetType(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (call != null) {
            PsiParameterList parameterList;
            PsiParameter psiParameter;
            PsiMethod resolved;
            int index;
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionList.class, (boolean)true);
            if (expressionList != null && (index = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)element)) >= 0 && (resolved = call.resolveMethod()) != null && (psiParameter = (parameterList = resolved.getParameterList()).getParameter(index)) != null) {
                return psiParameter.getType();
            }
        } else {
            PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false);
            if (variable != null) {
                return variable.getType();
            }
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return super.generatePreview(project, editor, file);
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttributeValue) {
            String value2;
            Object defaultName = this.getType().getName() + "_name";
            PsiElement parentParent = parent.getParent();
            if (parentParent instanceof XmlAttribute && this.getType() == ResourceType.STRING && (value2 = ((XmlAttribute)parentParent).getValue()) != null) {
                defaultName = IdeResourcesUtil.buildResourceNameFromStringValue(value2);
            }
            int start2 = element.getTextOffset();
            int end = start2 + element.getTextLength();
            editor.getDocument().replaceString(start2, end, (CharSequence)("@" + this.getType().getName() + "/" + (String)defaultName));
            return IntentionPreviewInfo.DIFF;
        }
        return super.generatePreview(project, editor, file);
    }

    private static class MyVarOfTypeExpression
    extends VariableOfTypeMacro {
        private final String myDefaultValue;

        private MyVarOfTypeExpression(@NotNull String defaultValue) {
            this.myDefaultValue = defaultValue;
        }

        public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context) {
            return new TextResult(this.myDefaultValue);
        }

        public Result calculateQuickResult(@NotNull Expression[] params2, ExpressionContext context) {
            return new TextResult(this.myDefaultValue);
        }

        public LookupElement[] calculateLookupItems(@NotNull Expression[] params2, ExpressionContext context) {
            PsiElement[] vars = this.getVariables(params2, context);
            if (vars == null || vars.length == 0) {
                return null;
            }
            LinkedHashSet set2 = new LinkedHashSet();
            for (PsiElement var : vars) {
                JavaTemplateUtil.addElementLookupItem(set2, (PsiElement)var);
            }
            LookupElement[] elements = set2.toArray(LookupElement.EMPTY_ARRAY);
            if (elements.length == 0) {
                return elements;
            }
            LookupElementBuilder lookupElementForDefValue = LookupElementBuilder.create((String)this.myDefaultValue);
            LookupElement[] result2 = new LookupElement[elements.length + 1];
            result2[0] = lookupElementForDefValue;
            System.arraycopy(elements, 0, result2, 1, elements.length);
            return result2;
        }
    }
}

