/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.XmlLanguageCodeStyleSettingsProvider;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidCodeStyleNotificationProvider
implements EditorNotificationProvider {
    @NonNls
    private static final String ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP = "Android XML code style notification";
    private final Project myProject;
    private final EditorNotifications myNotifications;

    public AndroidCodeStyleNotificationProvider(Project project) {
        this.myProject = project;
        this.myNotifications = EditorNotifications.getInstance((Project)project);
    }

    @Nullable
    public Function<FileEditor, JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile resDir;
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return null;
        }
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(CodeStyle.getSettings((Project)this.myProject));
        if (androidSettings.USE_CUSTOM_SETTINGS) {
            return null;
        }
        if (NotificationsConfigurationImpl.getSettings((String)ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP).getDisplayType() == NotificationDisplayType.NONE) {
            return null;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = resDir = parent != null ? parent.getParent() : null;
        if (resDir == null || !ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(resDir)) {
            return null;
        }
        return this::createNotificationPanel;
    }

    @Nullable
    private MyPanel createNotificationPanel(FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        NotificationsConfiguration.getNotificationsConfiguration().register(ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.BALLOON, false);
        return new MyPanel(fileEditor);
    }

    public class MyPanel
    extends EditorNotificationPanel {
        MyPanel(FileEditor fileEditor) {
            super(fileEditor, EditorNotificationPanel.Status.Info);
            this.setText(AndroidBundle.message("android.xml.code.style.notification", new Object[0]));
            this.createActionLabel(AndroidBundle.message("action.label.code.style.notification.open.settings", new Object[0]), () -> {
                ShowSettingsUtilImpl.showSettingsDialog((Project)AndroidCodeStyleNotificationProvider.this.myProject, (String)("preferences.sourceCode." + XmlLanguageCodeStyleSettingsProvider.getConfigurableDisplayNameText()), (String)"");
                AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
            });
            this.createActionLabel(AndroidBundle.message("action.label.code.style.notification.disable", new Object[0]), () -> {
                NotificationsConfiguration.getNotificationsConfiguration().changeSettings(AndroidCodeStyleNotificationProvider.ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.NONE, false, false);
                AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
            });
        }
    }
}

