/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidSourceTypeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0013\u001c\u001d\u001e\u001f !\"#$%&'()*+,-.B/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\u0011\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0012/0123456789:;<=>?@\u00a8\u0006A"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType;", "", "name", "", "icon", "Ljavax/swing/Icon;", "isGenerated", "", "isCustom", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;ZZ)V", "getName", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "()Z", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "equals", "other", "", "hashCode", "", "toString", "compareTo", "Companion", "MANIFEST", "JAVA", "KOTLIN", "KOTLIN_AND_JAVA", "GENERATED_JAVA", "CPP", "AIDL", "RENDERSCRIPT", "SHADERS", "ASSETS", "GENERATED_ASSETS", "JNILIBS", "RES", "GENERATED_RES", "RESOURCES", "ML", "BASELINE_PROFILES", "Custom", "Lorg/jetbrains/android/facet/AndroidSourceType$AIDL;", "Lorg/jetbrains/android/facet/AndroidSourceType$ASSETS;", "Lorg/jetbrains/android/facet/AndroidSourceType$BASELINE_PROFILES;", "Lorg/jetbrains/android/facet/AndroidSourceType$CPP;", "Lorg/jetbrains/android/facet/AndroidSourceType$Custom;", "Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_ASSETS;", "Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_RES;", "Lorg/jetbrains/android/facet/AndroidSourceType$JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType$JNILIBS;", "Lorg/jetbrains/android/facet/AndroidSourceType$KOTLIN;", "Lorg/jetbrains/android/facet/AndroidSourceType$KOTLIN_AND_JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType$MANIFEST;", "Lorg/jetbrains/android/facet/AndroidSourceType$ML;", "Lorg/jetbrains/android/facet/AndroidSourceType$RENDERSCRIPT;", "Lorg/jetbrains/android/facet/AndroidSourceType$RES;", "Lorg/jetbrains/android/facet/AndroidSourceType$RESOURCES;", "Lorg/jetbrains/android/facet/AndroidSourceType$SHADERS;", "intellij.android.navigator"})
public abstract sealed class AndroidSourceType
implements Comparable<AndroidSourceType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final Icon icon;
    private final boolean isGenerated;
    private final boolean isCustom;
    @NotNull
    private static final String JAVA_NAME = "java";
    @NotNull
    private static final String RES_NAME = "res";
    @NotNull
    private static final String ASSETS_NAME = "assets";

    private AndroidSourceType(String name2, Icon icon, boolean isGenerated, boolean isCustom) {
        this.name = name2;
        this.icon = icon;
        this.isGenerated = isGenerated;
        this.isCustom = isCustom;
    }

    public /* synthetic */ AndroidSourceType(String string, Icon icon, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(string, icon, bl, bl2, null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean isGenerated() {
        return this.isGenerated;
    }

    @NotNull
    public abstract List<VirtualFile> getSources(@NotNull IdeaSourceProvider var1);

    public boolean equals(@Nullable Object other) {
        return !this.isCustom ? this == other : other instanceof AndroidSourceType && ((AndroidSourceType)other).isCustom && Intrinsics.areEqual((Object)((AndroidSourceType)other).name, (Object)this.name);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.isGenerated, this.isCustom};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return this.isCustom ? "Custom(" + this.name + ")" : (this.isGenerated ? this.name + " (generated)" : this.name);
    }

    @Override
    public int compareTo(@NotNull AndroidSourceType other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isCustom != other.isCustom ? (this.isCustom ? 1 : -1) : (this.isCustom ? this.name.compareTo(other.name) : Intrinsics.compare((int)AndroidSourceTypeKt.getBUILT_IN_TYPES().indexOf(this), (int)AndroidSourceTypeKt.getBUILT_IN_TYPES().indexOf(other)));
    }

    public /* synthetic */ AndroidSourceType(String name2, Icon icon, boolean isGenerated, boolean isCustom, DefaultConstructorMarker $constructor_marker) {
        this(name2, icon, isGenerated, isCustom);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$AIDL;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class AIDL
    extends AndroidSourceType {
        @NotNull
        public static final AIDL INSTANCE = new AIDL();

        private AIDL() {
            super("aidl", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getAidlDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$ASSETS;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class ASSETS
    extends AndroidSourceType {
        @NotNull
        public static final ASSETS INSTANCE = new ASSETS();

        private ASSETS() {
            super(AndroidSourceType.ASSETS_NAME, AllIcons.Modules.ResourcesRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getAssetsDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$BASELINE_PROFILES;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class BASELINE_PROFILES
    extends AndroidSourceType {
        @NotNull
        public static final BASELINE_PROFILES INSTANCE = new BASELINE_PROFILES();

        private BASELINE_PROFILES() {
            super("baselineProfiles", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getBaselineProfileDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$CPP;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class CPP
    extends AndroidSourceType {
        @NotNull
        public static final CPP INSTANCE = new CPP();

        private CPP() {
            super("cpp", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$Companion;", "", "<init>", "()V", "JAVA_NAME", "", "RES_NAME", "ASSETS_NAME", "intellij.android.navigator"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$Custom;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "name", "", "<init>", "(Ljava/lang/String;)V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class Custom
    extends AndroidSourceType {
        public Custom(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2, AllIcons.Modules.ResourcesRoot, false, true, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Object object = provider.getCustom().get(this.getName());
            if (object == null || (object = object.getDirectories()) == null) {
                object = CollectionsKt.emptyList();
            }
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)object);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_ASSETS;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class GENERATED_ASSETS
    extends AndroidSourceType {
        @NotNull
        public static final GENERATED_ASSETS INSTANCE = new GENERATED_ASSETS();

        private GENERATED_ASSETS() {
            super(AndroidSourceType.ASSETS_NAME, AllIcons.Modules.ResourcesRoot, true, false, 8, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getAssetsDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class GENERATED_JAVA
    extends AndroidSourceType {
        @NotNull
        public static final GENERATED_JAVA INSTANCE = new GENERATED_JAVA();

        private GENERATED_JAVA() {
            super(AndroidSourceType.JAVA_NAME, AllIcons.Modules.GeneratedSourceRoot, true, false, 8, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.concat(provider.getJavaDirectories(), provider.getKotlinDirectories()));
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$GENERATED_RES;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class GENERATED_RES
    extends AndroidSourceType {
        @NotNull
        public static final GENERATED_RES INSTANCE = new GENERATED_RES();

        private GENERATED_RES() {
            super(AndroidSourceType.RES_NAME, AllIcons.Modules.ResourcesRoot, true, false, 8, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getResDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    @SourceDebugExtension(value={"SMAP\nAndroidSourceType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$JAVA\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n827#2:243\n855#2,2:244\n*S KotlinDebug\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$JAVA\n*L\n64#1:243\n64#1:244,2\n*E\n"})
    public static final class JAVA
    extends AndroidSourceType {
        @NotNull
        public static final JAVA INSTANCE = new JAVA();

        private JAVA() {
            super(AndroidSourceType.JAVA_NAME, AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Set kotlinDirectories = CollectionsKt.toSet(provider.getKotlinDirectories());
            ImmutableList immutableList = ImmutableList.copyOf(provider.getJavaDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            Iterable $this$filterNot$iv = (Iterable)immutableList;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (kotlinDirectories.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$JNILIBS;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class JNILIBS
    extends AndroidSourceType {
        @NotNull
        public static final JNILIBS INSTANCE = new JNILIBS();

        private JNILIBS() {
            super("jniLibs", AllIcons.Modules.ResourcesRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getJniLibsDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$KOTLIN;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    @SourceDebugExtension(value={"SMAP\nAndroidSourceType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$KOTLIN\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n827#2:243\n855#2,2:244\n*S KotlinDebug\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$KOTLIN\n*L\n74#1:243\n74#1:244,2\n*E\n"})
    public static final class KOTLIN
    extends AndroidSourceType {
        @NotNull
        public static final KOTLIN INSTANCE = new KOTLIN();

        private KOTLIN() {
            super("kotlin", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Set javaDirectories = CollectionsKt.toSet(provider.getJavaDirectories());
            ImmutableList immutableList = ImmutableList.copyOf(provider.getKotlinDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            Iterable $this$filterNot$iv = (Iterable)immutableList;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (javaDirectories.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$KOTLIN_AND_JAVA;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    @SourceDebugExtension(value={"SMAP\nAndroidSourceType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$KOTLIN_AND_JAVA\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n774#2:243\n865#2,2:244\n*S KotlinDebug\n*F\n+ 1 AndroidSourceType.kt\norg/jetbrains/android/facet/AndroidSourceType$KOTLIN_AND_JAVA\n*L\n84#1:243\n84#1:244,2\n*E\n"})
    public static final class KOTLIN_AND_JAVA
    extends AndroidSourceType {
        @NotNull
        public static final KOTLIN_AND_JAVA INSTANCE = new KOTLIN_AND_JAVA();

        private KOTLIN_AND_JAVA() {
            super("kotlin+java", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Set javaDirectories = CollectionsKt.toSet(provider.getJavaDirectories());
            ImmutableList immutableList = ImmutableList.copyOf(provider.getKotlinDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            Iterable $this$filter$iv = (Iterable)immutableList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!javaDirectories.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$MANIFEST;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class MANIFEST
    extends AndroidSourceType {
        @NotNull
        public static final MANIFEST INSTANCE = new MANIFEST();

        private MANIFEST() {
            super("manifest", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getManifestFiles());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$ML;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class ML
    extends AndroidSourceType {
        @NotNull
        public static final ML INSTANCE = new ML();

        private ML() {
            super("ml", AllIcons.Modules.ResourcesRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getMlModelsDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$RENDERSCRIPT;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class RENDERSCRIPT
    extends AndroidSourceType {
        @NotNull
        public static final RENDERSCRIPT INSTANCE = new RENDERSCRIPT();

        private RENDERSCRIPT() {
            super("renderscript", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getRenderscriptDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$RES;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class RES
    extends AndroidSourceType {
        @NotNull
        public static final RES INSTANCE = new RES();

        private RES() {
            super(AndroidSourceType.RES_NAME, AllIcons.Modules.ResourcesRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getResDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$RESOURCES;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class RESOURCES
    extends AndroidSourceType {
        @NotNull
        public static final RESOURCES INSTANCE = new RESOURCES();

        private RESOURCES() {
            super("resources", AllIcons.Modules.ResourcesRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getResourcesDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/facet/AndroidSourceType$SHADERS;", "Lorg/jetbrains/android/facet/AndroidSourceType;", "<init>", "()V", "getSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.navigator"})
    public static final class SHADERS
    extends AndroidSourceType {
        @NotNull
        public static final SHADERS INSTANCE = new SHADERS();

        private SHADERS() {
            super("shaders", AllIcons.Modules.SourceRoot, false, false, 12, null);
        }

        @Override
        @NotNull
        public List<VirtualFile> getSources(@NotNull IdeaSourceProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            ImmutableList immutableList = ImmutableList.copyOf(provider.getShadersDirectories());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return (List)immutableList;
        }
    }
}

