/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.AndroidManifestXmlFile;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a1\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00130\b\"\u0004\b\u0000\u0010\u0013*\u00020\u000f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\b\u0017\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u000f\"=\u0010\u0006\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t \u000b*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"=\u0010\u0010\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t \u000b*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"isRequiredAttribute", "", "attrName", "Lcom/intellij/util/xml/XmlName;", "element", "Lcom/intellij/util/xml/DomElement;", "CUSTOM_PERMISSIONS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCustomPermissions", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "CUSTOM_PERMISSION_GROUPS", "getCustomPermissionGroups", "cachedValueFromPrimaryManifest", "T", "valueSelector", "Lkotlin/Function1;", "Lorg/jetbrains/android/dom/manifest/AndroidManifestXmlFile;", "Lkotlin/ExtensionFunctionType;", "getPrimaryManifestXml", "intellij.android.core"})
@JvmName(name="AndroidManifestUtils")
public final class AndroidManifestUtils {
    @NotNull
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSIONS;
    @NotNull
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSION_GROUPS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element) {
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof CompatibleScreensScreen)) return false;
        if (!Intrinsics.areEqual((Object)attrName.getNamespaceKey(), (Object)"http://schemas.android.com/apk/res/android")) return false;
        String string = attrName.getLocalName();
        switch (string.hashCode()) {
            case -417399155: {
                if (string.equals("screenSize")) return true;
                return false;
            }
            case -1360635172: {
                if (!string.equals("screenDensity")) return false;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final Collection<String> getCustomPermissions(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        try {
            Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return (Collection)DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> AndroidManifestUtils.getCustomPermissions$lambda$0(facet));
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            CachedValue cachedValue = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet, AndroidManifestUtils::getCustomPermissions$lambda$1);
            return (Collection)((CachedValue)facet.putUserDataIfAbsent(CUSTOM_PERMISSIONS, cachedValue)).getValue();
        }
    }

    @Nullable
    public static final Collection<String> getCustomPermissionGroups(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        try {
            Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return (Collection)DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> AndroidManifestUtils.getCustomPermissionGroups$lambda$0(facet));
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            CachedValue cachedValue = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet, AndroidManifestUtils::getCustomPermissionGroups$lambda$1);
            return (Collection)((CachedValue)facet.putUserDataIfAbsent(CUSTOM_PERMISSION_GROUPS, cachedValue)).getValue();
        }
    }

    @NotNull
    public static final <T> CachedValue<T> cachedValueFromPrimaryManifest(@NotNull AndroidFacet $this$cachedValueFromPrimaryManifest, @NotNull Function1<? super AndroidManifestXmlFile, ? extends T> valueSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$cachedValueFromPrimaryManifest, (String)"<this>");
        Intrinsics.checkNotNullParameter(valueSelector, (String)"valueSelector");
        CachedValue cachedValue = CachedValuesManager.getManager((Project)$this$cachedValueFromPrimaryManifest.getModule().getProject()).createCachedValue(() -> AndroidManifestUtils.cachedValueFromPrimaryManifest$lambda$0($this$cachedValueFromPrimaryManifest, valueSelector));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
        return cachedValue;
    }

    @Nullable
    public static final AndroidManifestXmlFile getPrimaryManifestXml(@NotNull AndroidFacet $this$getPrimaryManifestXml) {
        AndroidManifestXmlFile androidManifestXmlFile;
        PsiFile psiFile;
        VirtualFile it;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimaryManifestXml, (String)"<this>");
        if ($this$getPrimaryManifestXml.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance($this$getPrimaryManifestXml).getMainManifestFile();
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl = false;
            psiFile = AndroidPsiUtils.getPsiFileSafely((Project)$this$getPrimaryManifestXml.getModule().getProject(), (VirtualFile)it);
        } else {
            psiFile = null;
        }
        PsiFile psiFile2 = psiFile;
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile != null) {
            it = xmlFile;
            boolean bl = false;
            XmlTag xmlTag = it.getRootTag();
            androidManifestXmlFile = Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"manifest") ? new AndroidManifestXmlFile((XmlFile)it) : null;
        } else {
            androidManifestXmlFile = null;
        }
        return androidManifestXmlFile;
    }

    private static final Collection getCustomPermissions$lambda$0(AndroidFacet $facet) {
        return AndroidManifestIndexQueryUtils.queryCustomPermissionsFromManifestIndex($facet);
    }

    private static final Collection getCustomPermissions$lambda$1(AndroidManifestXmlFile $this$cachedValueFromPrimaryManifest) {
        Intrinsics.checkNotNullParameter((Object)$this$cachedValueFromPrimaryManifest, (String)"$this$cachedValueFromPrimaryManifest");
        return $this$cachedValueFromPrimaryManifest.getCustomPermissions();
    }

    private static final Collection getCustomPermissionGroups$lambda$0(AndroidFacet $facet) {
        return AndroidManifestIndexQueryUtils.queryCustomPermissionGroupsFromManifestIndex($facet);
    }

    private static final Collection getCustomPermissionGroups$lambda$1(AndroidManifestXmlFile $this$cachedValueFromPrimaryManifest) {
        Intrinsics.checkNotNullParameter((Object)$this$cachedValueFromPrimaryManifest, (String)"$this$cachedValueFromPrimaryManifest");
        return $this$cachedValueFromPrimaryManifest.getCustomPermissionGroups();
    }

    private static final CachedValueProvider.Result cachedValueFromPrimaryManifest$lambda$0(AndroidFacet $this_cachedValueFromPrimaryManifest, Function1 $valueSelector) {
        CachedValueProvider.Result result2;
        AndroidManifestXmlFile primaryManifest = (AndroidManifestXmlFile)ActionsKt.runReadAction(() -> AndroidManifestUtils.cachedValueFromPrimaryManifest$lambda$0$0($this_cachedValueFromPrimaryManifest));
        if (primaryManifest == null) {
            Object[] objectArray = new Object[]{ModificationTracker.EVER_CHANGED};
            result2 = CachedValueProvider.Result.create(null, (Object[])objectArray);
        } else {
            Object result3 = ActionsKt.runReadAction(() -> AndroidManifestUtils.cachedValueFromPrimaryManifest$lambda$0$1($valueSelector, primaryManifest));
            Object[] objectArray = new Object[]{primaryManifest};
            result2 = CachedValueProvider.Result.create((Object)result3, (Object[])objectArray);
        }
        return result2;
    }

    private static final AndroidManifestXmlFile cachedValueFromPrimaryManifest$lambda$0$0(AndroidFacet $this_cachedValueFromPrimaryManifest) {
        return AndroidManifestUtils.getPrimaryManifestXml($this_cachedValueFromPrimaryManifest);
    }

    private static final Object cachedValueFromPrimaryManifest$lambda$0$1(Function1 $valueSelector, AndroidManifestXmlFile $primaryManifest) {
        return $valueSelector.invoke((Object)$primaryManifest);
    }

    static {
        Key key = Key.create((String)"merged.manifest.custom.permissions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CUSTOM_PERMISSIONS = key;
        Key key2 = Key.create((String)"merged.manifest.custom.permission.groups");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CUSTOM_PERMISSION_GROUPS = key2;
    }
}

