/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.lint;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.android.dom.lint.IssueIdConverter;
import org.jetbrains.android.dom.lint.LintDomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueIdDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof XmlAttributeValue)) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return null;
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)element.getProject()).getFileElement((XmlFile)file, LintDomElement.class);
        if (fileElement == null) {
            return null;
        }
        Issue issue2 = (Issue)IssueIdConverter.getIdSet().get((Object)((XmlAttributeValue)element).getValue());
        if (issue2 == null) {
            return null;
        }
        return this.getDocumentation(issue2);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @NotNull Object object, @NotNull PsiElement element) {
        if (!(object instanceof Issue)) {
            return null;
        }
        Issue issue2 = (Issue)object;
        return this.getDocumentationElementForLookupItem(psiManager, issue2);
    }

    @VisibleForTesting
    PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Issue issue2) {
        String documentation = this.getDocumentation(issue2);
        return new ProvidedDocumentationPsiElement(psiManager, Language.ANY, issue2.getId(), documentation);
    }

    @NotNull
    private String getDocumentation(Issue issue2) {
        Object documentation = issue2.getExplanation(TextFormat.HTML);
        List options = issue2.getOptions();
        if (!options.isEmpty()) {
            String optionsHtml = Option.Companion.describe(options, TextFormat.HTML, true);
            documentation = (String)documentation + "<br/>\n" + optionsHtml;
        }
        Vendor vendor = issue2.getVendor();
        IssueRegistry registry = issue2.getRegistry();
        if (vendor == null && registry != null) {
            vendor = registry.getVendor();
        }
        if (vendor != null && vendor != IssueRegistry.Companion.getAOSP_VENDOR()) {
            documentation = (String)documentation + "<br/>\n" + vendor.describe(TextFormat.HTML);
        }
        return documentation;
    }
}

